/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.mail;

import com.alexandriasoftware.swing.action.ButtonClickedActionListener;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsBulkLetterField;
import com.openindex.openestate.tool.contacts.ContactsBulkLetterTab;
import com.openindex.openestate.tool.contacts.addons.mail.MailEditorContactsExtension;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.extensions.BulkLetterAdapter;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultSplitButton;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.utils.MailTemplateDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.Email;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class BulkLetterMailExtension
extends BulkLetterAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkLetterMailExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(BulkLetterMailExtension.class);
    private MailTab mailTab = null;
    private boolean bulkMailSent = false;
    private long selectedTemplateMessageId = 0L;

    private synchronized void buildMailTab() {
        this.mailTab = new MailTab();
    }

    private void doInsertField(ContactsBulkLetterField contactsBulkLetterField) {
        if (this.mailTab == null || contactsBulkLetterField == null) {
            return;
        }
        this.mailTab.insertField(contactsBulkLetterField);
    }

    private void doInsertMenu() {
        if (this.mailTab == null) {
            return;
        }
        this.mailTab.fieldPopupMenu.show(this.mailTab.fieldButton, 0, ((MailTab)this.mailTab).fieldButton.getSize().height);
    }

    private void doSelectNewMail() {
        if (this.mailTab == null) {
            return;
        }
        this.mailTab.loadNewMessage();
    }

    private void doSelectTemplate() {
        if (this.mailTab == null) {
            return;
        }
        try {
            DbMailMessage dbMailMessage = MailTemplateDialog.showDialog((long)this.selectedTemplateMessageId, (ImmoToolProject)ImmoToolProject.getAppInstance(), (Window)this.getParentDialog());
            if (dbMailMessage == null) {
                return;
            }
            this.mailTab.loadTemplate(dbMailMessage.id);
        }
        catch (Exception exception) {
            LOGGER.error("Can't load mail template into editor!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't load mail template into editor!"), (Throwable)exception, (Window)this.getParentDialog());
        }
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"};
    }

    public ContactsBulkLetterTab[] getTabs() {
        if (this.mailTab == null) {
            this.buildMailTab();
        }
        return new ContactsBulkLetterTab[]{this.mailTab};
    }

    public String getTitle() {
        return "E-Mail-Rundschreiben";
    }

    private static String replaceFields(String string, DbContactsEntry dbContactsEntry, Map<ContactsBulkLetterField, String[]> map) {
        String string2 = string;
        for (Map.Entry<ContactsBulkLetterField, String[]> entry : map.entrySet()) {
            ContactsBulkLetterField contactsBulkLetterField = entry.getKey();
            String string3 = contactsBulkLetterField.getValue(dbContactsEntry);
            string3 = string3 != null ? string3.trim() : "";
            for (String string4 : entry.getValue()) {
                Pattern pattern = Pattern.compile("\\{\\s*" + Pattern.quote(string4) + "\\s*\\}", 2);
                Matcher matcher = pattern.matcher(string2);
                string2 = matcher.replaceAll(string3);
            }
        }
        return string2;
    }

    public boolean submit(DbContactsEntry[] dbContactsEntryArray) {
        String string;
        String string2;
        Object object2;
        if (this.mailTab == null || ArrayUtils.isEmpty((Object[])dbContactsEntryArray)) {
            return false;
        }
        final ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        MailHandler mailHandler = MailPlugin.getMailHandler();
        if (!this.mailTab.mailEditor.isValidInput()) {
            ImmoToolUtils.showMessageErrorDialog((String)"Bitte korrigieren Sie die Eingaben in den farblich hervorgehobenen Feldern.", (Component)this.getParentDialog());
            return false;
        }
        final HashMap<Long, DbContactsEntry> hashMap = new HashMap<Long, DbContactsEntry>();
        final HashMap<Long, InternetAddress> hashMap2 = new HashMap<Long, InternetAddress>();
        for (Object object2 : dbContactsEntryArray) {
            string2 = object2.getAddressMail();
            string = object2.address.writePersonFullName();
            if (StringUtils.isBlank((CharSequence)string2)) continue;
            try {
                InternetAddress exception = StringUtils.isBlank((CharSequence)string) ? new InternetAddress(string2) : new InternetAddress(string2, string);
                hashMap2.put(object2.id, exception);
                hashMap.put(object2.id, (DbContactsEntry)object2);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't create recipient address!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (hashMap2.isEmpty()) {
            ImmoToolUtils.showMessageErrorDialog((String)"Keine Empf\u00e4nger mit g\u00fcltigen Mailadressen gefunden!", (Component)this.getParentDialog());
            return false;
        }
        final Map map = this.mailTab.mailEditor.getEmailRecipients();
        final String string3 = this.mailTab.mailEditor.getEmailSubject();
        final String string4 = this.mailTab.mailEditor.getEmailPlainText();
        object2 = this.mailTab.mailEditor.getEmailHtmlText();
        this.bulkMailSent = false;
        string2 = this.mailTab.mailEditor.getSelectedAccount();
        string = new ImmoToolTask<Integer, Void>("Send bulk mail...", (String)object2, (DbMailAccount)string2, mailHandler){
            final /* synthetic */ String val$tplHtmlText;
            final /* synthetic */ DbMailAccount val$account;
            final /* synthetic */ MailHandler val$mailHandler;
            {
                this.val$tplHtmlText = string42;
                this.val$account = dbMailAccount;
                this.val$mailHandler = mailHandler;
                super(string);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Integer doInBackground() throws Exception {
                Integer n;
                Connection connection;
                EnumMap<ContactsBulkLetterField, String[]> enumMap = new EnumMap<ContactsBulkLetterField, String[]>(ContactsBulkLetterField.class);
                for (ContactsBulkLetterField contactsBulkLetterField : ContactsBulkLetterField.values()) {
                    enumMap.put(contactsBulkLetterField, contactsBulkLetterField.getLanguageNames());
                }
                Connection connection2 = null;
                try {
                    int n2 = 0;
                    connection = immoToolProject.getDbConnection();
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        Long l = (Long)entry.getKey();
                        DbContactsEntry dbContactsEntry = (DbContactsEntry)hashMap.get(l);
                        EnumMap enumMap2 = new EnumMap(MailEditor.RecipientType.class);
                        enumMap2.putAll(map);
                        if (!enumMap2.containsKey(MailEditor.RecipientType.TO)) {
                            enumMap2.put(MailEditor.RecipientType.TO, new ArrayList());
                        }
                        ((List)enumMap2.get(MailEditor.RecipientType.TO)).add(new MailEditorContactsExtension.ContactsAddress(dbContactsEntry));
                        String string = BulkLetterMailExtension.replaceFields(string3, dbContactsEntry, enumMap);
                        String string2 = BulkLetterMailExtension.replaceFields(string4, dbContactsEntry, enumMap);
                        String string32 = BulkLetterMailExtension.replaceFields(this.val$tplHtmlText, dbContactsEntry, enumMap);
                        Email email = BulkLetterMailExtension.this.mailTab.mailEditor.getEmail(this.val$account, enumMap2, string, string2, string32);
                        DbMailMessage dbMailMessage = this.val$mailHandler.sendMessage(immoToolProject, connection, email, this.val$account.id, true);
                        if (dbMailMessage != null) {
                            BulkLetterMailExtension.this.mailTab.mailEditor.saveAdditionally(connection, dbMailMessage, enumMap2, MailEditor.SaveMode.OUTBOX);
                        }
                        ++n2;
                    }
                    n = n2;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(connection2);
                    throw throwable;
                }
                JdbcUtils.closeQuietly((Connection)connection);
                return n;
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't send bulk mail!", (Throwable)throwable, (Window)this.getParentWindow());
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                BulkLetterMailExtension.this.bulkMailSent = n > 0;
            }
        };
        ImmoToolTaskDialog.showDialog((ImmoToolTask)string, (Window)this.getParentDialog());
        return this.bulkMailSent;
    }

    private class SelectTemplateAction
    extends AbstractI18nAction {
        public SelectTemplateAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon((String)"folder_templates.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BulkLetterMailExtension.this.doSelectTemplate();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select template")));
            this.setShortDescription(I18N.tr("Select a mail template, that shall be used for the bulk letter."));
        }
    }

    private class SelectNewMailAction
    extends AbstractI18nAction {
        public SelectNewMailAction() {
            this.setSmallIcon(MailPlugin.getResourceIcon((String)"mail_new.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BulkLetterMailExtension.this.doSelectNewMail();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new e-mail")));
            this.setShortDescription(I18N.tr("Select this option to compose a new e-mail."));
        }
    }

    private class InsertMenuAction
    extends AbstractI18nAction {
        public InsertMenuAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BulkLetterMailExtension.this.doInsertMenu();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("insert field")));
            this.setShortDescription(I18N.tr("Add a placeholder field into the e-mail text."));
        }
    }

    private class InsertFieldAction
    extends AbstractI18nAction {
        private final ContactsBulkLetterField field;

        public InsertFieldAction(ContactsBulkLetterField contactsBulkLetterField) {
            this.field = contactsBulkLetterField;
            this.setName(contactsBulkLetterField.getCurrentLanguageName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BulkLetterMailExtension.this.doInsertField(this.field);
        }
    }

    private final class MailTab
    extends ContactsBulkLetterTab {
        private JXTitledSeparator titleLabel;
        private DefaultSplitButton templateButton;
        private SelectTemplateAction templateAction;
        private JButton fieldButton;
        private JPopupMenu fieldPopupMenu;
        private JMenu addressFieldsMenu;
        private JMenu personFieldsMenu;
        private JMenu companyFieldsMenu;
        private JMenu bankAccountFieldsMenu;
        private MailEditor mailEditor;

        public MailTab() {
            this.build();
            this.updateLocalization();
            this.loadNewMessage();
        }

        private void build() {
            this.mailEditor = new MailEditor(MailEditor.RecipientMode.ONE_REPLY_TO, true);
            this.fieldButton = new JButton((Action)((Object)new InsertMenuAction()));
            this.fieldPopupMenu = new JPopupMenu();
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ID)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.NR)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.LETTER_ADDRESS)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.MAIL)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PHONE)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.MOBILEPHONE)));
            this.fieldPopupMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.FAX)));
            this.fieldPopupMenu.addSeparator();
            this.addressFieldsMenu = new JMenu();
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_LINE1)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_LINE2)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_LINE3)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_STREET)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_STREET_NR)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_POSTALCODE)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_CITY)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_DISTRICT)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_COUNTRY)));
            this.addressFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.ADDRESS_REGION)));
            this.fieldPopupMenu.add(this.addressFieldsMenu);
            this.personFieldsMenu = new JMenu();
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_FULLNAME)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_FIRSTNAME)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_MIDDLENAME)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_LASTNAME)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_TITLE)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_DAY_OF_BIRTH)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_MAIL)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_PHONE)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_MOBILEPHONE)));
            this.personFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.PERSON_FAX)));
            this.fieldPopupMenu.add(this.personFieldsMenu);
            this.companyFieldsMenu = new JMenu();
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_NAME)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_NAME_ADDITION)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_LEGAL_FORM)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_BUSINESS)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_DEPARTMENT)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_POSITION)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_MAIL)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_PHONE)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_MOBILEPHONE)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_FAX)));
            this.companyFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.COMPANY_WEBSITE)));
            this.fieldPopupMenu.add(this.companyFieldsMenu);
            this.bankAccountFieldsMenu = new JMenu();
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_OWNER)));
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_NR)));
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_BLZ)));
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_INSTITUTE)));
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_IBAN)));
            this.bankAccountFieldsMenu.add((Action)((Object)new InsertFieldAction(ContactsBulkLetterField.BANK_ACCOUNT_BIC)));
            this.fieldPopupMenu.add(this.bankAccountFieldsMenu);
            this.templateAction = new SelectTemplateAction();
            this.templateButton = new DefaultSplitButton();
            this.templateButton.setText(this.templateAction.getName() + "    ");
            this.templateButton.setToolTipText(this.templateAction.getShortDescription());
            this.templateButton.setIcon(this.templateAction.getSmallIcon());
            this.templateButton.setBounds(this.fieldButton.getBounds());
            this.templateButton.addButtonClickedActionListener(new ButtonClickedActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BulkLetterMailExtension.this.doSelectTemplate();
                }
            });
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new JMenuItem((Action)((Object)this.templateAction)));
            jPopupMenu.addSeparator();
            jPopupMenu.add(new JMenuItem((Action)((Object)new SelectNewMailAction())));
            this.templateButton.setPopupMenu(jPopupMenu);
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = new ButtonBarBuilder().addGrowing((JComponent)this.titleLabel).addRelatedGap().addFixed((JComponent)this.templateButton).addRelatedGap().addFixed((JComponent)this.mailEditor.getSaveButton()).addRelatedGap().addFixed((JComponent)this.mailEditor.getAttachmentButton()).addRelatedGap().addFixed((JComponent)this.fieldButton).addRelatedGap().addFixed((JComponent)this.mailEditor.getOptionsButton()).getPanel();
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add((Component)this.mailEditor, "Center");
        }

        public String getTabTitle() {
            return "E-Mailvorlage";
        }

        private void insertField(ContactsBulkLetterField contactsBulkLetterField) {
            String string = contactsBulkLetterField.getCurrentLanguageName();
            if (!StringUtils.isBlank((CharSequence)string)) {
                this.mailEditor.insertText("{ " + string + " }");
            }
        }

        private void loadNewMessage() {
            try {
                this.mailEditor.loadAsNew();
                String string = ContactsBulkLetterField.LETTER_ADDRESS.getCurrentLanguageName();
                if (!StringUtils.isBlank((CharSequence)string)) {
                    this.mailEditor.setPlainText("{ " + string + " }," + System.lineSeparator() + System.lineSeparator() + "...");
                    this.mailEditor.setHtmlText("<p>{ " + string + " },</p><p>...</p>");
                }
            }
            catch (Exception exception) {
                LOGGER.error("Can't load mail editor!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        private void loadTemplate(long l) throws SQLException, MessagingException, IOException {
            BulkLetterMailExtension.this.selectedTemplateMessageId = l;
            this.mailEditor.loadAsNew(l);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("edit bulk letter mail")));
            this.addressFieldsMenu.setText(StringUtils.capitalize((String)I18N.tr("address")));
            this.personFieldsMenu.setText(StringUtils.capitalize((String)I18N.tr("person")));
            this.companyFieldsMenu.setText(StringUtils.capitalize((String)I18N.tr("company")));
            this.bankAccountFieldsMenu.setText(StringUtils.capitalize((String)I18N.tr("bank account")));
        }
    }
}

