/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.CharsetRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsEntryExportDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryExportDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryExportDialog.class);
    private boolean submitted = false;
    private JLabel charsetLabel;
    private JComboBox<Charset> charsetField;
    private JLabel formatLabel;
    private JComboBox<Format> formatField;
    private JLabel groupLabel;
    private JComboBox<DbContactsGroup> groupField;

    private ContactsEntryExportDialog(Frame frame, boolean bl) {
        super(frame);
        this.updateLocalization();
        this.setFiltersSelectable(bl);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private ContactsEntryExportDialog(Dialog dialog, boolean bl) {
        super(dialog);
        this.updateLocalization();
        this.setFiltersSelectable(bl);
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{new SubmitAction()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.charsetLabel = new JLabel();
        this.charsetField = new JComboBox();
        this.charsetField.setRenderer((ListCellRenderer<Charset>)new DefaultListCellRenderer((Renderer)new CharsetRenderer()));
        this.charsetField.setSelectedIndex(-1);
        for (Charset charset : Charset.availableCharsets().values()) {
            this.charsetField.addItem(charset);
        }
        this.charsetField.setSelectedItem(Charset.defaultCharset());
        this.formatLabel = new JLabel();
        this.formatField = new JComboBox();
        this.formatField.setRenderer((ListCellRenderer<Format>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        for (Format format : Format.values()) {
            this.formatField.addItem(format);
        }
        this.formatField.setSelectedIndex(0);
        this.groupLabel = new JLabel();
        this.groupField = new JComboBox();
        this.groupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("all address groups") + " ]";
            }
        }));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[30dlu,pref], 3dlu, pref:grow, 3dlu, right:pref, 3dlu, [30dlu,pref]");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.formatLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.formatField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.charsetLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add(this.charsetField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.groupLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.groupField).xyw(3, defaultFormBuilder.row(), 5);
        return defaultFormBuilder.getPanel();
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("save addresses"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"file_export.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("save addresses to harddisk"));
    }

    private void doSubmit() {
        this.submitted = true;
        this.setVisible(false);
    }

    private Charset getSelectedCharset() {
        return (Charset)this.charsetField.getSelectedItem();
    }

    private DbContactsGroup getSelectedContactGroup() {
        if (this.groupField.getSelectedIndex() <= 0) {
            return null;
        }
        return (DbContactsGroup)this.groupField.getSelectedItem();
    }

    private Format getSelectedFormat() {
        return (Format)((Object)this.formatField.getSelectedItem());
    }

    private ExportSettings getSelectedSettings() {
        return new ExportSettings(this.getSelectedFormat(), this.getSelectedCharset(), this.getSelectedContactGroup());
    }

    private void loadContactGroups(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        defaultComboBoxModel.addElement(null);
        for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
            defaultComboBoxModel.addElement(dbContactsGroup);
        }
        this.groupField.setModel(defaultComboBoxModel);
    }

    private void setFiltersSelectable(boolean bl) {
        this.groupLabel.setVisible(bl);
        this.groupField.setVisible(bl);
    }

    public static ExportSettings showDialog(Window window) {
        ExportSettings exportSettings;
        ContactsEntryExportDialog contactsEntryExportDialog = null;
        try {
            contactsEntryExportDialog = window instanceof Dialog ? new ContactsEntryExportDialog((Dialog)window, false) : (window instanceof Frame ? new ContactsEntryExportDialog((Frame)window, false) : new ContactsEntryExportDialog((Frame)null, false));
            contactsEntryExportDialog.setVisible(true);
            exportSettings = contactsEntryExportDialog.submitted ? contactsEntryExportDialog.getSelectedSettings() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(contactsEntryExportDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)contactsEntryExportDialog));
        return exportSettings;
    }

    public static ExportSettings showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, Window window) throws SQLException {
        return ContactsEntryExportDialog.showDialog(abstractDbDriver, dbContactsHandler, true, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportSettings showDialog(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, boolean bl, Window window) throws SQLException {
        Object object;
        ContactsEntryExportDialog contactsEntryExportDialog = null;
        try {
            ContactsEntryExportDialog contactsEntryExportDialog2 = window instanceof Dialog ? new ContactsEntryExportDialog((Dialog)window, bl) : (contactsEntryExportDialog = window instanceof Frame ? new ContactsEntryExportDialog((Frame)window, bl) : new ContactsEntryExportDialog((Frame)null, bl));
            if (bl) {
                object = null;
                try {
                    object = abstractDbDriver.getConnection();
                    contactsEntryExportDialog.loadContactGroups((Connection)object, dbContactsHandler);
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)object);
                }
            }
            contactsEntryExportDialog.setVisible(true);
            object = contactsEntryExportDialog.submitted ? contactsEntryExportDialog.getSelectedSettings() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(contactsEntryExportDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)contactsEntryExportDialog));
        return object;
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.charsetLabel.setText(StringUtils.capitalize((String)I18N.tr("character-set")) + ":");
        this.formatLabel.setText(StringUtils.capitalize((String)I18N.tr("format")) + ":");
        this.groupLabel.setText(StringUtils.capitalize((String)I18N.tr("group")) + ":");
    }

    public static enum Format implements Translatable
    {
        CSV(I18n.marktr((String)"CSV table"), new String[]{".csv"}),
        XLS(I18n.marktr((String)"Excel table"), new String[]{".xls"}),
        VCARD(I18n.marktr((String)"vCard file"), new String[]{".vcf", ".vcard"});

        private final String i18nKey;
        private final String[] extensions;

        private Format(String string2, String[] stringArray) {
            this.i18nKey = string2;
            this.extensions = stringArray;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(ContactsEntryExportDialog.class, (String)this.i18nKey, (Locale)locale);
        }

        public boolean isSupported(File file) {
            if (file == null || !file.isFile()) {
                return false;
            }
            String string = file.getName().toLowerCase();
            for (String string2 : this.extensions) {
                if (!string.endsWith(string2)) continue;
                return true;
            }
            return false;
        }

        public String writeExtensions() {
            return "*" + StringUtils.join((Object[])this.extensions, (String)", *");
        }
    }

    public static final class ExportSettings {
        public final Format format;
        public final Charset charset;
        public final DbContactsGroup group;

        private ExportSettings(Format format, Charset charset, DbContactsGroup dbContactsGroup) {
            this.format = format;
            this.charset = charset;
            this.group = dbContactsGroup;
        }

        public String getDefaultFileName() {
            String string = I18N.tr("addresses") + "-" + System.currentTimeMillis();
            if (this.format != null) {
                return string + this.format.extensions[0];
            }
            return string;
        }

        public FileFilter getFileFilter() {
            return new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return ExportSettings.this.format == null || ExportSettings.this.format.isSupported(file);
                }

                @Override
                public String getDescription() {
                    if (ExportSettings.this.format != null) {
                        return ExportSettings.this.format.getTranslation() + " (" + ExportSettings.this.format.writeExtensions() + ")";
                    }
                    return null;
                }
            };
        }

        public long getGroupId() {
            return this.group != null ? this.group.id : 0L;
        }
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryExportDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryExportDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
        }
    }
}

