/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryAddressPanel;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryExtendedAddressPanel
extends ContactsEntryAddressPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryExtendedAddressPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryExtendedAddressPanel.class);
    private JXTitledSeparator generalTitle;
    private JLabel addressNrLabel;
    private JTextField addressNrField;
    private JCheckBox contactAllowedBox;

    public ContactsEntryExtendedAddressPanel() {
        super(2);
    }

    public ContactsEntryExtendedAddressPanel(int n) {
        super(2, n);
    }

    protected void finishCompanyPanel(DefaultFormBuilder defaultFormBuilder) {
        super.finishCompanyPanel(defaultFormBuilder);
        this.generalTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.addressNrLabel = new JLabel();
        this.addressNrField = new JTextField();
        this.addressNrField.setName("addressNrField");
        this.contactAllowedBox = new JCheckBox();
        defaultFormBuilder.add((Component)new JLabel()).xyw(1, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns());
        defaultFormBuilder.add((Component)this.generalTitle).xyw(1, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns());
        defaultFormBuilder.add((Component)this.addressNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.addressNrField).xyw(3, defaultFormBuilder.row(), defaultFormBuilder.getNumberOfColumns() - 2);
        defaultFormBuilder.add((Component)this.contactAllowedBox).xyw(3, defaultFormBuilder.nextRow(), defaultFormBuilder.getNumberOfColumns() - 2);
    }

    @Override
    public void load(DbContactsEntry dbContactsEntry) {
        super.load(dbContactsEntry);
        this.addressNrField.setText(dbContactsEntry != null ? StringUtils.trimToEmpty((String)dbContactsEntry.publicId) : "");
        this.contactAllowedBox.setSelected(dbContactsEntry != null && dbContactsEntry.isContactAllowed());
    }

    @Override
    public void save(DbContactsEntry dbContactsEntry) {
        super.save(dbContactsEntry);
        dbContactsEntry.publicId = this.addressNrField.getText().trim();
        dbContactsEntry.setContactAllowed(this.contactAllowedBox.isSelected());
    }

    @Override
    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.addressNrField.setEditable(bl);
        this.contactAllowedBox.setEnabled(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.addressNrField.setEnabled(bl);
        this.contactAllowedBox.setEnabled(bl);
    }

    @Override
    protected void updateLocalization() {
        super.updateLocalization();
        this.generalTitle.setTitle(StringUtils.capitalize((String)I18N.tr("additional information")));
        this.addressNrLabel.setText(StringUtils.capitalize((String)I18N.tr("nr")) + ":");
        this.addressNrField.setToolTipText(I18N.tr("Enter a unique number for the address."));
        this.contactAllowedBox.setText(I18N.tr("Agreement for contacting is available."));
        this.contactAllowedBox.setToolTipText(StringUtils.capitalize((String)I18N.tr("Enable this option, if you are allowed to contact this person.")));
    }
}

