/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.extensions.FrameMenuAdapter;
import com.openindex.openestate.tool.gui.DefaultMenu;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsFrameMenuExtension
extends FrameMenuAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsFrameMenuExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsFrameMenuExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_SELECT = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_ENTRY = 4;
    public static final int MENU_ADD_GROUP = 5;
    public static final int MENU_ADD_END = 6;
    public static final int MENU_ENTRIES = 7;
    public static final int MENU_ELSE = 8;
    public static final int MENU_ELSE_BEGIN = 9;
    public static final int MENU_ELSE_IMPORT = 10;
    public static final int MENU_ELSE_EXPORT = 11;
    public static final int MENU_ELSE_BULK = 12;
    public static final int MENU_ELSE_END = 13;
    public static final int MENU_END = 14;

    public JMenu createMainMenu() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = ContactsFrameMenuExtension.getAddons((ImmoToolProject)immoToolProject, ((Object)((Object)this)).getClass());
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(ContactsPlugin.getInstance().getTitle());
            }
        };
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)0, (Collection)collection);
        defaultMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.SidebarSelectAction())));
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)1, (Collection)collection);
        DefaultMenu defaultMenu2 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the addressbook addon."));
            }
        };
        defaultMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)3, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EDIT)) {
            defaultMenu2.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryFormAction())));
        }
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)4, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.GROUPS_EDIT)) {
            if (defaultMenu2.getItemCount() > 0) {
                defaultMenu2.addSeparator();
            }
            defaultMenu2.add(new JMenuItem((Action)((Object)new ContactsPlugin.GroupDialogAction())));
        }
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)5, (Collection)collection);
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)6, (Collection)collection);
        if (defaultMenu2.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu2);
        }
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)2, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            defaultMenu.addSeparator();
        }
        defaultMenu.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryTableAction(true))));
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)7, (Collection)collection);
        defaultMenu.addSeparator();
        DefaultMenu defaultMenu3 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
                this.setToolTipText(I18N.tr("Further actions in the addressbook addon."));
            }
        };
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)9, (Collection)collection);
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_IMPORT)) {
            DefaultMenu defaultMenu4 = new DefaultMenu(){

                protected void updateLocalization() {
                    this.setText(StringUtils.capitalize((String)I18N.tr("import addresses")));
                    this.setToolTipText(I18N.tr("Import addresses from an external file."));
                }
            };
            defaultMenu4.setIcon(ImmoToolEnvironment.getResourceIcon((String)"file_import.png", (int)16));
            defaultMenu4.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryImportFromCsvAction())));
            defaultMenu4.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryImportFromVcardAction())));
            defaultMenu3.add((JMenuItem)defaultMenu4);
            ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)10, (Collection)collection);
        }
        if (ContactsPlugin.isUserAllowedTo(ContactsPermission.ENTRIES_EXPORT)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new ContactsPlugin.EntryExportAction())));
        }
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)11, (Collection)collection);
        defaultMenu3.add(new JMenuItem((Action)((Object)new ContactsPlugin.BulkLetterDialogAction())));
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)12, (Collection)collection);
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)13, (Collection)collection);
        if (defaultMenu3.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu3);
        }
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)8, (Collection)collection);
        ContactsFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)14, (Collection)collection);
        return defaultMenu;
    }
}

