/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.db;

import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.db.DbLog;
import com.openindex.openestate.tool.db.DbUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbContactsEntryLog
extends DbLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbContactsEntryLog.class);
    private static final I18n I18N = I18nFactory.getI18n(DbContactsEntryLog.class);
    public static final String TYPE = "Contacts.Entry";
    private static final String CHANGE_GROUP_ID = "groupId";
    private static final String CHANGE_ENTRY_PUBLIC_ID = "publicId";
    private static final String CHANGE_ENTRY_ACTIVE = "isActive";
    private static final String CHANGE_ENTRY_BIRTHDAY = "birthDay";
    private static final String CHANGE_ENTRY_NOTES = "notes";
    public long entryId = 0L;

    public DbContactsEntryLog() {
        this.entryType = TYPE;
    }

    public static DbContactsEntryLog create(long l, String string, DbUser dbUser) {
        DbContactsEntryLog dbContactsEntryLog = new DbContactsEntryLog();
        dbContactsEntryLog.entryId = l;
        dbContactsEntryLog.entryAction = string;
        dbContactsEntryLog.createdBy = dbUser != null ? dbUser.writeName() : null;
        dbContactsEntryLog.modifiedBy = dbUser != null ? dbUser.writeName() : null;
        return dbContactsEntryLog;
    }

    public final String getPluginName() {
        return "OpenEstate-Tool-Contacts";
    }

    public void initChanges(DbContactsEntry dbContactsEntry, DbContactsEntry dbContactsEntry2) {
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        this.changes = new HashMap();
        this.putChangedGroupId(dbContactsEntry != null ? Long.valueOf(dbContactsEntry.groupId) : null, dbContactsEntry2 != null ? Long.valueOf(dbContactsEntry2.groupId) : null);
        this.putChangedActive(dbContactsEntry != null ? Boolean.valueOf(dbContactsEntry.isActive) : null, dbContactsEntry2 != null ? Boolean.valueOf(dbContactsEntry2.isActive) : null);
        String string = dbContactsEntry != null ? dbContactsEntry.publicId : null;
        String string2 = dbContactsEntry2 != null ? dbContactsEntry2.publicId : null;
        this.addChange(CHANGE_ENTRY_PUBLIC_ID, string, string2);
        string = dbContactsEntry != null && dbContactsEntry.birthDay != null ? dateFormat.format(dbContactsEntry.birthDay) : null;
        string2 = dbContactsEntry2 != null && dbContactsEntry2.birthDay != null ? dateFormat.format(dbContactsEntry2.birthDay) : null;
        this.addChange(CHANGE_ENTRY_BIRTHDAY, string, string2);
        string = dbContactsEntry != null ? dbContactsEntry.notes : null;
        string2 = dbContactsEntry2 != null ? dbContactsEntry2.notes : null;
        this.addChange(CHANGE_ENTRY_NOTES, string, string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (dbContactsEntry != null) {
            if (dbContactsEntry.address != null) {
                dbContactsEntry.address.serializeToMap(hashMap, "entry.");
            }
            if (dbContactsEntry.values != null) {
                for (String object22 : dbContactsEntry.values.keySet()) {
                    hashMap.put(object22, dbContactsEntry.values.get(object22));
                }
            }
        }
        HashMap hashMap2 = new HashMap();
        if (dbContactsEntry2 != null) {
            if (dbContactsEntry2.address != null) {
                dbContactsEntry2.address.serializeToMap((Map)hashMap2, "entry.");
            }
            if (dbContactsEntry2.values != null) {
                for (String string3 : dbContactsEntry2.values.keySet()) {
                    hashMap2.put(string3, dbContactsEntry2.values.get(string3));
                }
            }
        }
        List list = ImmoToolUtils.compareMaps(hashMap, hashMap2);
        for (String string4 : list) {
            string = hashMap.containsKey(string4) ? (String)hashMap.get(string4) : null;
            string2 = hashMap2.containsKey(string4) ? (String)hashMap2.get(string4) : null;
            this.addChange(string4, string, string2);
        }
    }

    public void putChangedActive(Boolean bl, Boolean bl2) {
        String string;
        String string2 = bl != null ? (Boolean.TRUE.equals(bl) ? "1" : "0") : (string = null);
        String string3 = bl2 != null ? (Boolean.TRUE.equals(bl2) ? "1" : "0") : null;
        this.addChange(CHANGE_ENTRY_ACTIVE, string, string3);
    }

    public void putChangedGroupId(Long l, Long l2) {
        String string = l != null && l > 0L ? String.valueOf(l) : null;
        String string2 = l2 != null && l2 > 0L ? String.valueOf(l2) : null;
        this.addChange(CHANGE_GROUP_ID, string, string2);
    }

    public String writeAction() {
        return DbContactsEntryLog.writeAction(this.entryAction);
    }

    public static String writeAction(String string) {
        if ("ADD".equalsIgnoreCase(string)) {
            return I18N.tr("contact entry added");
        }
        if ("EDIT".equalsIgnoreCase(string)) {
            return I18N.tr("contact entry modified");
        }
        return null;
    }

    public String writeChangeKey(String string) {
        if (CHANGE_ENTRY_ACTIVE.equalsIgnoreCase(string)) {
            return I18N.tr("active");
        }
        if (CHANGE_ENTRY_BIRTHDAY.equalsIgnoreCase(string)) {
            return I18N.tr("date of birth");
        }
        if (CHANGE_ENTRY_NOTES.equalsIgnoreCase(string)) {
            return StringUtils.capitalize((String)I18N.tr(CHANGE_ENTRY_NOTES));
        }
        if (CHANGE_ENTRY_PUBLIC_ID.equalsIgnoreCase(string)) {
            return I18N.tr("address nr");
        }
        if (CHANGE_GROUP_ID.equalsIgnoreCase(string)) {
            return I18N.tr("group");
        }
        if ("entry.address.city".equalsIgnoreCase(string)) {
            return I18N.tr("place");
        }
        if ("entry.address.country".equalsIgnoreCase(string)) {
            return I18N.tr("country");
        }
        if ("entry.address.district".equalsIgnoreCase(string)) {
            return I18N.tr("district");
        }
        if ("entry.address.latitude".equalsIgnoreCase(string)) {
            return I18N.tr("latitude");
        }
        if ("entry.address.longitude".equalsIgnoreCase(string)) {
            return I18N.tr("longitude");
        }
        if ("entry.address.postalcode".equalsIgnoreCase(string)) {
            return I18N.tr("postcode");
        }
        if ("entry.address.region".equalsIgnoreCase(string)) {
            return I18N.tr("region");
        }
        if ("entry.address.street".equalsIgnoreCase(string)) {
            return I18N.tr("street");
        }
        if ("entry.address.street2".equalsIgnoreCase(string)) {
            return I18N.tr("street (addition)");
        }
        if ("entry.address.streetNr".equalsIgnoreCase(string)) {
            return I18N.tr("street-nr");
        }
        if ("entry.company.business".equalsIgnoreCase(string)) {
            return I18N.tr("branch");
        }
        if ("entry.company.department".equalsIgnoreCase(string)) {
            return I18N.tr("department");
        }
        if ("entry.company.fax".equalsIgnoreCase(string)) {
            return I18N.tr("fax") + " (" + I18N.tr("office") + ")";
        }
        if ("entry.company.legalForm".equalsIgnoreCase(string)) {
            return I18N.tr("legal form");
        }
        if ("entry.company.mail".equalsIgnoreCase(string)) {
            return I18N.tr("e-mail") + " (" + I18N.tr("office") + ")";
        }
        if ("entry.company.mobilePhone".equalsIgnoreCase(string)) {
            return I18N.tr("mobile") + " (" + I18N.tr("office") + ")";
        }
        if ("entry.company.name".equalsIgnoreCase(string)) {
            return I18N.tr("company");
        }
        if ("entry.company.nameAddition".equalsIgnoreCase(string)) {
            return I18N.tr("company (addition)");
        }
        if ("entry.company.phone".equalsIgnoreCase(string)) {
            return I18N.tr("phone") + " (" + I18N.tr("office") + ")";
        }
        if ("entry.company.position".equalsIgnoreCase(string)) {
            return I18N.tr("position");
        }
        if ("entry.company.website".equalsIgnoreCase(string)) {
            return I18N.tr("website");
        }
        if ("entry.person.dateOfBirth".equalsIgnoreCase(string)) {
            return I18N.tr("birthday");
        }
        if ("entry.person.fax".equalsIgnoreCase(string)) {
            return I18N.tr("fax") + " (" + I18N.tr("personal") + ")";
        }
        if ("entry.person.firstName".equalsIgnoreCase(string)) {
            return I18N.tr("first name");
        }
        if ("entry.person.gender".equalsIgnoreCase(string)) {
            return I18N.tr("gender");
        }
        if ("entry.person.lastName".equalsIgnoreCase(string)) {
            return I18N.tr("last name");
        }
        if ("entry.person.mail".equalsIgnoreCase(string)) {
            return I18N.tr("e-mail") + " (" + I18N.tr("personal") + ")";
        }
        if ("entry.person.middleName".equalsIgnoreCase(string)) {
            return I18N.tr("middle name");
        }
        if ("entry.person.mobilePhone".equalsIgnoreCase(string)) {
            return I18N.tr("mobile") + " (" + I18N.tr("personal") + ")";
        }
        if ("entry.person.phone".equalsIgnoreCase(string)) {
            return I18N.tr("phone") + " (" + I18N.tr("personal") + ")";
        }
        if ("entry.person.title".equalsIgnoreCase(string)) {
            return I18N.tr("title");
        }
        if ("value.bank_account.bank_code_nr".equalsIgnoreCase(string)) {
            return I18N.tr("bank nr");
        }
        if ("value.bank_account.bic".equalsIgnoreCase(string)) {
            return I18N.tr("bank account BIC");
        }
        if ("value.bank_account.iban".equalsIgnoreCase(string)) {
            return I18N.tr("bank account IBAN");
        }
        if ("value.bank_account.institute".equalsIgnoreCase(string)) {
            return I18N.tr("bank institute");
        }
        if ("value.bank_account.nr".equalsIgnoreCase(string)) {
            return I18N.tr("bank account nr");
        }
        if ("value.bank_account.owner".equalsIgnoreCase(string)) {
            return I18N.tr("bank account owner");
        }
        if ("value.identification_nr".equalsIgnoreCase(string)) {
            return I18N.tr("ID-card nr");
        }
        if ("value.languages".equalsIgnoreCase(string)) {
            return I18N.tr("languages");
        }
        if ("value.letter_address".equalsIgnoreCase(string)) {
            return I18N.tr("letter address");
        }
        if ("value.tax.idnr".equalsIgnoreCase(string)) {
            return I18N.tr("tax ID nr");
        }
        if ("value.tax.nr".equalsIgnoreCase(string)) {
            return I18N.tr("tax nr");
        }
        if ("value.tax.uid".equalsIgnoreCase(string)) {
            return I18N.tr("sales tax ID nr");
        }
        if ("value.tax.wirtschaft_idnr".equalsIgnoreCase(string)) {
            return I18N.tr("economy ID nr");
        }
        return super.writeChangeKey(string);
    }

    public String writeChangeValue(String string, String string2) {
        if (CHANGE_ENTRY_ACTIVE.equalsIgnoreCase(string)) {
            if ("1".equals(string2)) {
                return OpenEstateConstant.YES.getTranslation();
            }
            if ("0".equals(string2)) {
                return OpenEstateConstant.NO.getTranslation();
            }
        }
        return super.writeChangeValue(string, string2);
    }
}

