/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsBulkLetterTab;
import com.openindex.openestate.tool.contacts.ContactsEntryDialog;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.extensions.BulkLetterExtension;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsBulkLetterDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsBulkLetterDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsBulkLetterDialog.class);
    private static final String RECIPIENTS_TABLE_ID = "ContactsBulkLetterDialog.RecipientsTable";
    private Map<Class, ContactsBulkLetterTab[]> extensionTypeTabs = new HashMap<Class, ContactsBulkLetterTab[]>();
    private Map<Long, DbContactsEntry> contactsMap = new HashMap<Long, DbContactsEntry>();
    private BulkLetterExtension currentExtension = null;
    private boolean submitted = false;
    private JTabbedPane tabPanel;
    private RecipientsTab recipientsTab;
    private JLabel extensionTypeLabel;
    private JComboBox<BulkLetterExtension> extensionTypeField;
    private SubmitAction submitAction;

    private ContactsBulkLetterDialog(Dialog dialog) {
        super(dialog, true);
        this.updateLocalization();
        this.updateButtons();
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(dialog);
    }

    private ContactsBulkLetterDialog(Frame frame) {
        super(frame, true);
        this.updateLocalization();
        this.updateButtons();
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(frame);
    }

    private void addRecipient(Recipient recipient) {
        this.recipientsTab.table.addRow(new ContactsEntryTable.Row(recipient.entry, StringUtils.trimToEmpty((String)recipient.groupName)));
        this.contactsMap.put(recipient.entry.id, recipient.entry);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.extensionTypeLabel = new JLabel();
        this.extensionTypeField = new JComboBox();
        this.extensionTypeField.setRenderer((ListCellRenderer<BulkLetterExtension>)new DefaultListCellRenderer((Renderer)new AbstractRenderer<BulkLetterExtension>(){

            public String getEmptyText() {
                return "[ " + I18N.tr("Select type of bulk letter.") + " ]";
            }

            public void render(BulkLetterExtension bulkLetterExtension, JLabel jLabel) {
                if (bulkLetterExtension != null) {
                    jLabel.setText(bulkLetterExtension.getTitle());
                } else {
                    jLabel.setText(this.getEmptyText());
                }
            }
        }));
        this.extensionTypeField.addItem(null);
        this.extensionTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContactsBulkLetterDialog.this.updateExtensionTabs();
                ContactsBulkLetterDialog.this.updateButtons();
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, 50dlu:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add((Component)this.extensionTypeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.extensionTypeField).xy(3, defaultFormBuilder.row());
        this.tabPanel = new JTabbedPane();
        this.recipientsTab = (RecipientsTab)ImmoToolUtils.addTab((AbstractTab)new RecipientsTab(), (JTabbedPane)this.tabPanel);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setName("mainPanel");
        jPanel.setOpaque(false);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
        jPanel.add((Component)this.tabPanel, "Center");
        return jPanel;
    }

    private void doRecipientAdd() {
        ContactsEntryDialog.Result result = ContactsEntryDialog.showDialog((Window)((Object)this));
        if (result == null) {
            return;
        }
        for (int i = 0; i < this.recipientsTab.table.getRowCount(); ++i) {
            long l = this.recipientsTab.table.getContactEntryIdAt(i);
            if (l != result.entry.id) continue;
            LOGGER.warn("Contact entry is already selected!");
            return;
        }
        this.addRecipient(new Recipient(result.entry, result.group));
        this.updateButtons();
        this.updateRecipients();
    }

    private void doRecipientRemove() {
        int[] nArray = this.recipientsTab.table.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])nArray)) {
            return;
        }
        this.recipientsTab.table.clearSelection();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : nArray) {
            int n2 = this.recipientsTab.table.convertRowIndexToModel(n);
            arrayList.add(this.recipientsTab.table.getContactEntryIdAt(n2));
        }
        for (int i = this.recipientsTab.table.getRowCount() - 1; i >= 0; --i) {
            long l = this.recipientsTab.table.getContactEntryIdAt(i);
            if (!arrayList.contains(l)) continue;
            this.recipientsTab.table.removeRow(i);
        }
        for (Long l : arrayList) {
            this.contactsMap.remove(l);
        }
        this.updateButtons();
        this.updateRecipients();
    }

    private void doSubmit() {
        if (this.currentExtension == null || this.contactsMap.isEmpty()) {
            return;
        }
        DbContactsEntry[] dbContactsEntryArray = this.contactsMap.values().toArray(new DbContactsEntry[0]);
        this.submitted = this.currentExtension.submit(dbContactsEntryArray);
        if (this.submitted) {
            this.setVisible(false);
        }
    }

    protected String getDialogTitle() {
        return StringUtils.capitalize((String)I18N.tr("bulk letter wizard"));
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"wizard.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("create bulk letter"));
    }

    private void load() {
        this.extensionTypeField.setSelectedItem(null);
        this.extensionTypeField.removeAllItems();
        this.extensionTypeField.addItem(null);
        try {
            for (BulkLetterExtension bulkLetterExtension : ContactsPluginUtils.getBulkLetterExtensions()) {
                try {
                    bulkLetterExtension.setParentDialog(this);
                    this.extensionTypeField.addItem(bulkLetterExtension);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load bulk-letter-extension!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load bulk-letter-extensions!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    public static boolean showDialog(Window window) {
        return ContactsBulkLetterDialog.showDialog((Recipient[])null, window);
    }

    public static boolean showDialog(Recipient recipient, Window window) {
        Recipient[] recipientArray;
        if (recipient != null) {
            Recipient[] recipientArray2 = new Recipient[1];
            recipientArray = recipientArray2;
            recipientArray2[0] = recipient;
        } else {
            recipientArray = null;
        }
        return ContactsBulkLetterDialog.showDialog(recipientArray, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showDialog(Recipient[] recipientArray, Window window) {
        boolean bl;
        ContactsBulkLetterDialog contactsBulkLetterDialog = null;
        try {
            contactsBulkLetterDialog = window instanceof Dialog ? new ContactsBulkLetterDialog((Dialog)window) : (window instanceof Frame ? new ContactsBulkLetterDialog((Frame)window) : new ContactsBulkLetterDialog((Frame)null));
            contactsBulkLetterDialog.load();
            if (!ArrayUtils.isEmpty((Object[])recipientArray)) {
                for (Recipient recipient : recipientArray) {
                    if (recipient == null) continue;
                    contactsBulkLetterDialog.addRecipient(recipient);
                }
            }
            contactsBulkLetterDialog.setVisible(true);
            bl = contactsBulkLetterDialog.submitted;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(contactsBulkLetterDialog);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)contactsBulkLetterDialog));
        return bl;
    }

    private void update() {
        this.updateButtons();
        this.updateRecipients();
        this.updateLocalization();
    }

    private void updateButtons() {
        this.submitAction.setEnabled(this.currentExtension != null && !this.contactsMap.isEmpty());
    }

    private void updateExtensionTabs() {
        BulkLetterExtension bulkLetterExtension = (BulkLetterExtension)this.extensionTypeField.getSelectedItem();
        if (bulkLetterExtension != null && this.currentExtension != null && bulkLetterExtension.getClass().equals(this.currentExtension.getClass())) {
            return;
        }
        for (int i = 1; i < this.tabPanel.getTabCount(); ++i) {
            this.tabPanel.remove(i);
        }
        this.currentExtension = bulkLetterExtension;
        if (this.currentExtension == null) {
            return;
        }
        ContactsBulkLetterTab[] contactsBulkLetterTabArray = this.extensionTypeTabs.get(this.currentExtension.getClass());
        if (contactsBulkLetterTabArray == null && !ArrayUtils.isEmpty((Object[])(contactsBulkLetterTabArray = this.currentExtension.getTabs()))) {
            this.extensionTypeTabs.put(this.currentExtension.getClass(), contactsBulkLetterTabArray);
        }
        if (!ArrayUtils.isEmpty((Object[])contactsBulkLetterTabArray)) {
            for (ContactsBulkLetterTab contactsBulkLetterTab : contactsBulkLetterTabArray) {
                this.tabPanel.addTab(contactsBulkLetterTab.getTabTitle(), (Component)((Object)contactsBulkLetterTab));
            }
        }
        this.updateRecipients();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.extensionTypeLabel.setText(StringUtils.capitalize((String)I18N.tr("type of bulk letter")) + ":");
    }

    private void updateRecipients() {
        if (this.currentExtension == null) {
            return;
        }
        DbContactsEntry[] dbContactsEntryArray = null;
        if (!this.contactsMap.isEmpty()) {
            dbContactsEntryArray = this.contactsMap.values().toArray(new DbContactsEntry[0]);
        }
        this.currentExtension.setRecipients(dbContactsEntryArray);
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsBulkLetterDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and create / send the bulk letter."));
        }
    }

    private class RecipientRemoveAction
    extends AbstractI18nAction {
        private RecipientRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsBulkLetterDialog.this.doRecipientRemove();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove")));
            this.setShortDescription(I18N.tr("Remove the selected recipients from the bulk letter."));
        }
    }

    private class RecipientAddAction
    extends AbstractI18nAction {
        private RecipientAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsBulkLetterDialog.this.doRecipientAdd();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("add")));
            this.setShortDescription(I18N.tr("Add a recipient to the bulk letter."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsBulkLetterDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window and cancel bulk letter creation."));
        }
    }

    private class RecipientsTable
    extends ContactsEntryTable<ContactsEntryTable.Row> {
        private RecipientsTable() {
            super(ContactsBulkLetterDialog.RECIPIENTS_TABLE_ID);
        }

        protected void doRemove() {
        }

        protected void doSelect() {
            ContactsBulkLetterDialog.this.recipientsTab.removeAction.setEnabled(ContactsBulkLetterDialog.this.recipientsTab.table.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
        }

        protected void doView() {
        }
    }

    private final class RecipientsTab
    extends AbstractTab {
        private JXTitledSeparator titleLabel;
        private RecipientsTable table;
        private RecipientAddAction addAction;
        private RecipientRemoveAction removeAction;

        private RecipientsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.addAction = new RecipientAddAction();
            this.removeAction = new RecipientRemoveAction();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            JPanel jPanel = new ButtonBarBuilder().addGrowing((JComponent)this.titleLabel).addRelatedGap().addFixed((JComponent)new JButton((Action)((Object)this.addAction))).addRelatedGap().addFixed((JComponent)new JButton((Action)((Object)this.removeAction))).getPanel();
            this.table = new RecipientsTable();
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder((Border)Paddings.DIALOG);
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("recipients"));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("recipients of the bulk letter")));
            this.table.repaint();
        }
    }

    public static final class Recipient {
        public DbContactsEntry entry;
        public String groupName;

        public Recipient(DbContactsEntry dbContactsEntry) {
            this(dbContactsEntry, (String)null);
        }

        public Recipient(DbContactsEntry dbContactsEntry, DbContactsGroup dbContactsGroup) {
            this(dbContactsEntry, dbContactsGroup != null ? dbContactsGroup.name : null);
        }

        public Recipient(DbContactsEntry dbContactsEntry, String string) {
            this.entry = dbContactsEntry;
            this.groupName = string;
        }
    }
}

