/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.EntryRenderer;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Dimension;
import java.net.URL;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryField
extends DefaultAutoCompleteField<DbContactsEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryField.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryField.class);
    private long contactsGroupId = 0L;

    public ContactsEntryField() {
        this.setCustomValueAllowed(false);
        this.setMultipleSelectionAllowed(false);
        this.setAutoCompleteItemRenderer((ListCellRenderer)new DefaultListCellRenderer((Renderer)new EntryRenderer("-")));
        this.setAutoCompleteHandler(new Handler());
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        dbContactsEntry.address = new CompanyAddressImpl();
        dbContactsEntry.address.setCompanyName("example company");
        this.setContactsEntry(dbContactsEntry);
    }

    public DbContactsEntry getContactsEntry() {
        return (DbContactsEntry)this.getValue();
    }

    public long getContactsGroupId() {
        return this.contactsGroupId;
    }

    public void setContactsEntry(DbContactsEntry dbContactsEntry) {
        this.setValue(dbContactsEntry);
    }

    public void setContactsGroupId(long l) {
        this.contactsGroupId = l;
    }

    private final class Handler
    implements DefaultAutoCompleteField.AutoCompleteHandler<DbContactsEntry> {
        private Handler() {
        }

        public Dimension getOptionIconSize() {
            return new Dimension(16, 16);
        }

        public String getOptionText(DbContactsEntry dbContactsEntry) {
            if (dbContactsEntry != null) {
                return dbContactsEntry.print();
            }
            return "-";
        }

        public URL getOptionIconUrl(DbContactsEntry dbContactsEntry) {
            if (dbContactsEntry != null) {
                return ContactsPlugin.getResourceImageURL("edit_user.png", 16);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<DbContactsEntry> search(String string) throws Exception {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntriesByKeyword(connection, string, ContactsEntryField.this.getContactsGroupId(), 100);
                dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                List<DbContactsEntry> list = Arrays.asList(dbContactsEntryArray);
                return list;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }
}

