/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class ContactsEntryRelationPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryRelationPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryRelationPanel.class);
    private long currentEntryId = 0L;
    private long currentGroupId = 0L;
    private JXTitledSeparator formTitle;
    private JLabel entryLabel;
    private ContactsEntryField entryField;
    private JPanel entryFieldPanel;
    private JComboBox<DbContactsGroup> groupField;
    private JLabel notesLabel;
    private DefaultTextArea notesField;

    public ContactsEntryRelationPanel(boolean bl) {
        this.build(bl);
    }

    private void build(boolean bl) {
        this.entryLabel = new JLabel();
        this.entryField = new ContactsEntryField();
        this.entryFieldPanel = new JPanel(new BorderLayout());
        this.entryFieldPanel.add((Component)((Object)this.entryField), "Center");
        this.groupField = new JComboBox();
        this.groupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select address group") + " ]";
            }
        }));
        this.groupField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContactsEntryRelationPanel.this.groupField.isEnabled()) {
                    return;
                }
                DbContactsGroup dbContactsGroup = (DbContactsGroup)ContactsEntryRelationPanel.this.groupField.getSelectedItem();
                DbContactsEntry dbContactsEntry = ContactsEntryRelationPanel.this.entryField.getContactsEntry();
                if (dbContactsGroup == null) {
                    ContactsEntryRelationPanel.this.entryField.setContactsEntry(null);
                    ContactsEntryRelationPanel.this.entryField.setContactsGroupId(0L);
                    ContactsEntryRelationPanel.this.entryField.setEnabled(false);
                } else {
                    if (dbContactsEntry != null && dbContactsEntry.groupId != dbContactsGroup.id) {
                        ContactsEntryRelationPanel.this.entryField.setContactsEntry(null);
                    }
                    ContactsEntryRelationPanel.this.entryField.setContactsGroupId(dbContactsGroup.id);
                    ContactsEntryRelationPanel.this.entryField.setEnabled(true);
                }
            }
        });
        this.notesLabel = null;
        this.notesField = null;
        JScrollPane jScrollPane = null;
        if (bl) {
            this.notesLabel = new JLabel();
            this.notesField = new DefaultTextArea();
            jScrollPane = this.notesField.createScrollPane();
            jScrollPane.setPreferredSize(new Dimension(100, 100));
        }
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, pref:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.entryLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.groupField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.entryFieldPanel).xy(5, defaultFormBuilder.row());
        this.buildForm(defaultFormBuilder);
        if (jScrollPane != null) {
            defaultFormBuilder.add((Component)this.notesLabel).xy(1, defaultFormBuilder.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
            defaultFormBuilder.addRaw((Component)jScrollPane).xyw(3, defaultFormBuilder.row(), 3);
        }
        this.updateLocalization();
    }

    protected void buildForm(DefaultFormBuilder defaultFormBuilder) {
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        String string;
        DbContactsGroup dbContactsGroup = (DbContactsGroup)this.groupField.getSelectedItem();
        DbContactsEntry dbContactsEntry = this.entryField.getContactsEntry();
        String string2 = string = this.notesField != null ? this.notesField.getText().trim() : null;
        if (dbContactsGroup == null || dbContactsEntry == null) {
            return;
        }
        if (this.submit(dbContactsGroup, dbContactsEntry, string)) {
            this.unselectRelation();
        }
    }

    public long getCurrentContactEntryId() {
        return this.currentEntryId;
    }

    public long getCurrentContactGroupId() {
        return this.currentGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Connection connection, DbContactsHandler dbContactsHandler) throws SQLException {
        DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
        defaultComboBoxModel.addElement(null);
        try {
            for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
                defaultComboBoxModel.addElement(dbContactsGroup);
            }
        }
        finally {
            this.setContactsGroupsModel(defaultComboBoxModel);
        }
    }

    private void selectCurrentContactsGroup() {
        this.groupField.setSelectedIndex(0);
        if (this.currentGroupId > 0L) {
            for (int i = 0; i < this.groupField.getItemCount(); ++i) {
                DbContactsGroup dbContactsGroup = this.groupField.getItemAt(i);
                if (dbContactsGroup == null || dbContactsGroup.id != this.currentGroupId) continue;
                this.groupField.setSelectedIndex(i);
                break;
            }
        }
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbContactsEntry(), null);
    }

    public void selectRelation(DbContactsEntry dbContactsEntry, String string) {
        if (dbContactsEntry == null) {
            this.setVisible(false);
            return;
        }
        this.currentEntryId = dbContactsEntry.id;
        this.currentGroupId = dbContactsEntry.groupId;
        if (this.notesField != null) {
            this.notesField.setText(StringUtils.trimToEmpty((String)string));
            this.notesField.setCaretPosition(0);
        }
        this.groupField.setEnabled(false);
        this.groupField.setSelectedItem(null);
        this.entryField.setEnabled(false);
        if (this.currentGroupId < 1L) {
            this.groupField.setEnabled(true);
            this.entryField.setContactsGroupId(0L);
            this.entryField.setContactsEntry(null);
        } else {
            this.selectCurrentContactsGroup();
            this.groupField.setEnabled(true);
            this.entryField.setContactsGroupId(dbContactsEntry.groupId);
            this.entryField.setContactsEntry(dbContactsEntry);
            this.entryField.setCaretPosition(0);
            this.entryField.setEnabled(true);
        }
        this.updateLocalization();
        this.setVisible(true);
    }

    public void setContactsGroupsModel(ComboBoxModel<DbContactsGroup> comboBoxModel) {
        this.groupField.setEnabled(false);
        this.groupField.setModel(comboBoxModel);
        this.groupField.setSelectedIndex(0);
        this.selectCurrentContactsGroup();
        this.groupField.setEnabled(true);
    }

    public abstract boolean submit(DbContactsGroup var1, DbContactsEntry var2, String var3);

    public void unselectRelation() {
        this.selectRelation(null, null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentEntryId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.entryLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        if (this.notesLabel != null) {
            this.notesLabel.setText(StringUtils.capitalize((String)I18N.tr("notes")) + ":");
        }
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        private RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryRelationPanel.this.doRelationSubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        private RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryRelationPanel.this.doRelationClose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close assignment."));
        }
    }
}

