/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryViewTask
extends ImmoToolTask<ContactsEntryViewPanel, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryViewTask.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryViewTask.class);
    private long entryId;
    private boolean selectCreatedTab;
    private final ContactsEntryViewPanel viewTab;
    private AbstractDbDriver dbDriver;

    public ContactsEntryViewTask(AbstractDbDriver abstractDbDriver, long l) {
        this(abstractDbDriver, l, true);
    }

    public ContactsEntryViewTask(AbstractDbDriver abstractDbDriver, long l, boolean bl) {
        super(I18N.tr("Loading address {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.entryId = l;
        this.selectCreatedTab = bl;
        this.viewTab = null;
    }

    public ContactsEntryViewTask(AbstractDbDriver abstractDbDriver, long l, ContactsEntryViewPanel contactsEntryViewPanel) {
        super(I18N.tr("Loading address {0}.", (Object)("#" + l)));
        this.dbDriver = abstractDbDriver;
        this.entryId = l;
        this.selectCreatedTab = true;
        this.viewTab = contactsEntryViewPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ContactsEntryViewPanel doInBackground() throws Exception {
        Connection connection2;
        Object object;
        block8: {
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            if (this.viewTab == null) {
                object = ImmoToolAppUtils.getTabs(ContactsEntryViewPanel.class);
                for (AbstractMainTab abstractMainTab : object) {
                    ContactsEntryViewPanel contactsEntryViewPanel = (ContactsEntryViewPanel)abstractMainTab;
                    if (this.entryId < 1L && contactsEntryViewPanel.getCurrentEntryId() < 1L) {
                        if (!this.selectCreatedTab) return null;
                        ImmoToolAppUtils.selectTab((Component)((Object)contactsEntryViewPanel));
                        return null;
                    }
                    if (this.entryId <= 0L || contactsEntryViewPanel.getCurrentEntryId() != this.entryId) continue;
                    if (!this.selectCreatedTab) return null;
                    ImmoToolAppUtils.selectTab((Component)((Object)contactsEntryViewPanel));
                    return null;
                }
            }
            if (this.entryId < 1L) {
                return this.viewTab != null ? this.viewTab : ContactsEntryViewPanel.createTab();
            }
            Connection connection = null;
            try {
                connection2 = this.dbDriver.getConnection();
                DbContactsEntry dbContactsEntry = dbContactsHandler.getEntry(connection2, this.entryId);
                if (dbContactsEntry == null) {
                    throw new Exception("Can't find address #" + this.entryId + "!");
                }
                dbContactsHandler.loadEntrySettings(connection2, dbContactsEntry);
                if (this.viewTab == null) {
                    object = ContactsEntryViewPanel.createTab(dbContactsEntry);
                    break block8;
                }
                object = this.viewTab;
                ((ContactsEntryViewPanel)((Object)object)).setEntry(dbContactsEntry);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Connection)connection2);
        return object;
    }

    protected void failed(Throwable throwable) {
        super.failed(throwable);
        ImmoToolUtils.showMessageErrorDialog((String)"Can't load address!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
    }

    protected void succeeded(ContactsEntryViewPanel contactsEntryViewPanel) {
        super.succeeded((Object)contactsEntryViewPanel);
        if (contactsEntryViewPanel != null) {
            if (this.viewTab == null) {
                ImmoToolAppUtils.showTab((AbstractMainTab)contactsEntryViewPanel, (boolean)this.selectCreatedTab);
            }
            contactsEntryViewPanel.loadInBackground(this.dbDriver);
        }
    }
}

