/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupListCellRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsGroupChooser
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsGroupChooser.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsGroupChooser.class);
    private String infoTxt = null;
    private boolean submitted = false;
    private JComboBox<DbContactsGroup> contactGroupBox;

    private ContactsGroupChooser(Dialog dialog) {
        super(dialog, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    private ContactsGroupChooser(Frame frame) {
        super(frame, true);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{new SubmitAction()});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        this.contactGroupBox = new JComboBox();
        this.contactGroupBox.setRenderer((ListCellRenderer<DbContactsGroup>)((Object)new GroupListCellRenderer(){

            @Override
            public String getEmptyText() {
                return I18N.tr("select address group");
            }
        }));
        this.contactGroupBox.addItem(null);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"200dlu:grow");
        defaultFormBuilder.opaque(false);
        defaultFormBuilder.add(this.contactGroupBox).xy(1, defaultFormBuilder.nextRow());
        return defaultFormBuilder.getPanel();
    }

    private void doSubmit() {
        DbContactsGroup dbContactsGroup = this.getSelectedGroup();
        if (dbContactsGroup == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("An address group must be selected!"), (Component)((Object)this));
            return;
        }
        this.submitted = true;
        this.setVisible(false);
    }

    protected String getDialogTitle() {
        return I18N.tr("Select an address group.");
    }

    protected Icon getHeaderIcon() {
        return ContactsPlugin.getResourceIcon("edit_group.png", 32);
    }

    protected String getHeaderInfo() {
        return StringUtils.trimToNull((String)this.infoTxt);
    }

    protected String getHeaderTitle() {
        return I18N.tr("Select an address group.");
    }

    private DbContactsGroup getSelectedGroup() {
        return (DbContactsGroup)this.contactGroupBox.getSelectedItem();
    }

    private void load(Connection connection, boolean bl, boolean bl2) throws SQLException {
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
        this.contactGroupBox.removeAllItems();
        this.contactGroupBox.addItem(null);
        for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
            boolean bl3;
            if (bl && !(bl3 = dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId)) || bl2 && !(bl3 = dbContactsGroup.permission.canDelete(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId))) continue;
            this.contactGroupBox.addItem(dbContactsGroup);
        }
    }

    private void setInfoTxt(String string) {
        this.infoTxt = string;
    }

    public static DbContactsGroup showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        return ContactsGroupChooser.showDialog(immoToolProject, null, false, false, window);
    }

    public static DbContactsGroup showDialog(ImmoToolProject immoToolProject, String string, Window window) throws SQLException {
        return ContactsGroupChooser.showDialog(immoToolProject, string, false, false, window);
    }

    public static DbContactsGroup showDialog(ImmoToolProject immoToolProject, boolean bl, boolean bl2, Window window) throws SQLException {
        return ContactsGroupChooser.showDialog(immoToolProject, null, bl, bl2, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbContactsGroup showDialog(ImmoToolProject immoToolProject, String string, boolean bl, boolean bl2, Window window) throws SQLException {
        DbContactsGroup dbContactsGroup;
        ContactsGroupChooser contactsGroupChooser = null;
        try {
            contactsGroupChooser = window instanceof Dialog ? new ContactsGroupChooser((Dialog)window) : (window instanceof Frame ? new ContactsGroupChooser((Frame)window) : new ContactsGroupChooser((Frame)null));
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                contactsGroupChooser.load(connection, bl, bl2);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            if (!StringUtils.isBlank((CharSequence)string)) {
                contactsGroupChooser.setInfoTxt(string);
                contactsGroupChooser.updateLocalization();
                contactsGroupChooser.pack();
            }
            contactsGroupChooser.setVisible(true);
            dbContactsGroup = contactsGroupChooser.submitted ? contactsGroupChooser.getSelectedGroup() : null;
        }
        catch (Throwable throwable) {
            SwingUtils.disposeRecursively(contactsGroupChooser);
            throw throwable;
        }
        SwingUtils.disposeRecursively((Component)((Object)contactsGroupChooser));
        return dbContactsGroup;
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsGroupChooser.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsGroupChooser.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }
}

