/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryImportFields;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.utils.CsvImportTask;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryImportCsvTask
extends CsvImportTask<DbContactsEntry>
implements ContactsEntryImportFields {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryImportCsvTask.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryImportCsvTask.class);
    private final AbstractDbDriver dbDriver;
    private final DbContactsHandler contactsHandler;
    private Connection dbConnection = null;
    private DbContactsGroup importGroup = null;
    private Date importDate = null;

    public ContactsEntryImportCsvTask(AbstractDbDriver abstractDbDriver, DbContactsHandler dbContactsHandler, File file) {
        super(file);
        this.setTitle(I18N.tr("Import addresses from a CSV table."));
        this.dbDriver = abstractDbDriver;
        this.contactsHandler = dbContactsHandler;
    }

    protected DbContactsEntry createCsvObject() {
        DbContactsEntry dbContactsEntry = new DbContactsEntry();
        dbContactsEntry.address = new CompanyAddressImpl();
        dbContactsEntry.values = new HashMap<String, String>();
        return dbContactsEntry;
    }

    protected Long executeImport() throws IOException {
        this.importGroup = null;
        this.importDate = new Date();
        this.dbConnection = null;
        try {
            this.dbConnection = this.getDbDriver().getConnection();
            Long l = super.executeImport();
            return l;
        }
        catch (SQLException sQLException) {
            throw new IOException("Can't connect to database!", sQLException);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)this.dbConnection);
        }
    }

    protected DbContactsHandler getContactsHandler() {
        return this.contactsHandler;
    }

    protected AbstractDbDriver getDbDriver() {
        return this.dbDriver;
    }

    protected int getDefinedFieldCount() {
        return 49;
    }

    protected final String getFieldTitle(int n) {
        switch (n) {
            case 47: {
                return StringUtils.capitalize((String)I18N.tr("nr"));
            }
            case 48: {
                return StringUtils.capitalize((String)I18N.tr("notes"));
            }
            case 3: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("place"));
            }
            case 4: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("district"));
            }
            case 5: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("country"));
            }
            case 7: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("latitude"));
            }
            case 8: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("longitude"));
            }
            case 2: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("postcode"));
            }
            case 6: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("region"));
            }
            case 0: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("street"));
            }
            case 1: {
                return StringUtils.capitalize((String)I18N.tr("address")) + ", " + StringUtils.capitalize((String)I18N.tr("street-nr"));
            }
            case 17: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("fax"));
            }
            case 11: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("first name"));
            }
            case 12: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("gender"));
            }
            case 9: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("last name"));
            }
            case 14: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("e-mail"));
            }
            case 10: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("middle name"));
            }
            case 16: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("mobile"));
            }
            case 15: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("phone"));
            }
            case 13: {
                return StringUtils.capitalize((String)I18N.tr("person")) + ", " + StringUtils.capitalize((String)I18N.tr("title"));
            }
            case 29: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("branch"));
            }
            case 22: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("department"));
            }
            case 27: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("fax"));
            }
            case 24: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("e-mail"));
            }
            case 26: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("mobile"));
            }
            case 19: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("company"));
            }
            case 20: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("company (addition)"));
            }
            case 25: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("phone"));
            }
            case 23: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("position"));
            }
            case 21: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("legal form"));
            }
            case 28: {
                return StringUtils.capitalize((String)I18N.tr("company")) + ", " + StringUtils.capitalize((String)I18N.tr("website"));
            }
            case 30: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("birthday"));
            }
            case 31: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("birthplace"));
            }
            case 32: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("citizenship"));
            }
            case 33: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("languages"));
            }
            case 34: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank account owner");
            }
            case 35: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank institute");
            }
            case 36: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank account nr");
            }
            case 37: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank nr");
            }
            case 38: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank account IBAN");
            }
            case 39: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("bank account BIC");
            }
            case 40: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("tax nr"));
            }
            case 41: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("tax ID nr"));
            }
            case 42: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("sales tax ID nr"));
            }
            case 43: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + StringUtils.capitalize((String)I18N.tr("economy ID nr"));
            }
            case 44: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("ID-card nr");
            }
            case 45: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("ID-card type");
            }
            case 46: {
                return StringUtils.capitalize((String)I18N.tr("details")) + ", " + I18N.tr("ID-card issuer");
            }
        }
        return null;
    }

    public boolean isMultipleSelectionAllowed(int n) {
        return n == 48;
    }

    protected void readRecord(CSVRecord cSVRecord, DbContactsEntry dbContactsEntry) {
        Object object;
        Object object2;
        String string;
        String string2;
        dbContactsEntry.address.setCity(this.getValue(cSVRecord, 3));
        dbContactsEntry.address.setDistrict(this.getValue(cSVRecord, 4));
        dbContactsEntry.address.setPostalCode(this.getValue(cSVRecord, 2));
        dbContactsEntry.address.setRegion(this.getValue(cSVRecord, 6));
        dbContactsEntry.address.setStreet(this.getValue(cSVRecord, 0));
        dbContactsEntry.address.setStreetNr(this.getValue(cSVRecord, 1));
        String string3 = this.getValue(cSVRecord, 5);
        if (!StringUtils.isBlank((CharSequence)string3)) {
            dbContactsEntry.address.setCountry(ImmoToolUtils.getCountryCodeFromText((String)string3.trim()));
        }
        try {
            string2 = this.getValue(cSVRecord, 7);
            string = this.getValue(cSVRecord, 8);
            if (!StringUtils.isBlank((CharSequence)string2) && !StringUtils.isBlank((CharSequence)string)) {
                if (!string2.contains(".") && string2.contains(",")) {
                    string2 = StringUtils.replace((String)string2, (String)",", (String)".");
                }
                dbContactsEntry.address.setLatitude(new BigDecimal(string2));
                if (!string.contains(".") && string.contains(",")) {
                    string = StringUtils.replace((String)string, (String)",", (String)".");
                }
                dbContactsEntry.address.setLongitude(new BigDecimal(string));
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read latitude / longitude!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            dbContactsEntry.address.setLatitude(null);
            dbContactsEntry.address.setLongitude(null);
        }
        dbContactsEntry.address.setPersonFax(this.getValue(cSVRecord, 17));
        dbContactsEntry.address.setPersonFirstName(this.getValue(cSVRecord, 11));
        dbContactsEntry.address.setPersonLastName(this.getValue(cSVRecord, 9));
        dbContactsEntry.address.setPersonMail(this.getValue(cSVRecord, 14));
        dbContactsEntry.address.setPersonMiddleName(this.getValue(cSVRecord, 10));
        dbContactsEntry.address.setPersonMobilePhone(this.getValue(cSVRecord, 16));
        dbContactsEntry.address.setPersonPhone(this.getValue(cSVRecord, 15));
        dbContactsEntry.address.setPersonTitle(this.getValue(cSVRecord, 13));
        string2 = this.getValue(cSVRecord, 18);
        dbContactsEntry.setLetterAddress(!StringUtils.isBlank((CharSequence)string2) ? string2 : DbContactsEntry.DefaultLetterAddress.FORMAL.name());
        string = this.getValue(cSVRecord, 12);
        if (Gender.FEMALE.name().equalsIgnoreCase(string)) {
            dbContactsEntry.address.setPersonGender(Gender.FEMALE);
        } else if (Gender.MALE.name().equalsIgnoreCase(string)) {
            dbContactsEntry.address.setPersonGender(Gender.MALE);
        } else {
            object2 = I18N.tr("female;women;miss;madam;ms.;ms").split(";");
            boolean bl = false;
            for (String string4 : object2) {
                if ((string4 = StringUtils.trimToNull((String)string4)) == null || !string4.equalsIgnoreCase(string)) continue;
                bl = true;
                dbContactsEntry.address.setPersonGender(Gender.FEMALE);
                break;
            }
            if (!bl) {
                object = I18N.tr("male;men;mister;mr.;mr").split(";");
                for (String string5 : object) {
                    if ((string5 = StringUtils.trimToNull((String)string5)) == null || !string5.equalsIgnoreCase(string)) continue;
                    dbContactsEntry.address.setPersonGender(Gender.MALE);
                    break;
                }
            }
        }
        dbContactsEntry.address.setCompanyBusiness(this.getValue(cSVRecord, 29));
        dbContactsEntry.address.setCompanyDepartment(this.getValue(cSVRecord, 22));
        dbContactsEntry.address.setCompanyFax(this.getValue(cSVRecord, 27));
        dbContactsEntry.address.setCompanyMail(this.getValue(cSVRecord, 24));
        dbContactsEntry.address.setCompanyMobilePhone(this.getValue(cSVRecord, 26));
        dbContactsEntry.address.setCompanyName(this.getValue(cSVRecord, 19));
        dbContactsEntry.address.setCompanyNameAddition(this.getValue(cSVRecord, 20));
        dbContactsEntry.address.setCompanyPhone(this.getValue(cSVRecord, 25));
        dbContactsEntry.address.setCompanyPosition(this.getValue(cSVRecord, 23));
        dbContactsEntry.address.setCompanyLegalForm(this.getValue(cSVRecord, 21));
        try {
            object2 = StringUtils.trimToNull((String)this.getValue(cSVRecord, 28));
            if (StringUtils.isNotBlank((CharSequence)object2)) {
                if (!((String)object2).toLowerCase().startsWith("http://") && !((String)object2).toLowerCase().startsWith("https://")) {
                    object2 = "http://";
                }
                dbContactsEntry.address.setCompanyWebsite(new URI((String)object2));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read company-website!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
            dbContactsEntry.address.setCompanyWebsite(null);
        }
        dbContactsEntry.setCitizenship(this.getValue(cSVRecord, 32));
        dbContactsEntry.setIdentificationIssuer(this.getValue(cSVRecord, 46));
        dbContactsEntry.setIdentificationNr(this.getValue(cSVRecord, 44));
        dbContactsEntry.setPlaceOfBirth(this.getValue(cSVRecord, 31));
        dbContactsEntry.setBankAccountBIC(this.getValue(cSVRecord, 39));
        dbContactsEntry.setBankAccountBankCodeNr(this.getValue(cSVRecord, 37));
        dbContactsEntry.setBankAccountIBAN(this.getValue(cSVRecord, 38));
        dbContactsEntry.setBankAccountOwner(this.getValue(cSVRecord, 34));
        dbContactsEntry.setBankAccountInstitute(this.getValue(cSVRecord, 35));
        dbContactsEntry.setBankAccountNr(this.getValue(cSVRecord, 36));
        dbContactsEntry.setTaxIdNr(this.getValue(cSVRecord, 41));
        dbContactsEntry.setTaxNr(this.getValue(cSVRecord, 40));
        dbContactsEntry.setTaxUID(this.getValue(cSVRecord, 42));
        dbContactsEntry.setTaxWirtschaftIdNr(this.getValue(cSVRecord, 43));
        object2 = this.getValue(cSVRecord, 45);
        DbContactsEntry.IdentificationType identificationType = DbContactsEntry.IdentificationType.fromValue((String)object2);
        if (identificationType != null) {
            dbContactsEntry.setIdentificationType(identificationType.name());
        } else {
            dbContactsEntry.setIdentificationType(StringUtils.trimToNull((String)object2));
        }
        try {
            object = this.getValue(cSVRecord, 30);
            if (!StringUtils.isBlank((CharSequence)object)) {
                dbContactsEntry.birthDay = DateFormat.getDateInstance().parse((String)object);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read day of birth!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            dbContactsEntry.birthDay = null;
        }
        try {
            object = this.getValue(cSVRecord, 33);
            if (!StringUtils.isBlank((CharSequence)object)) {
                String[] stringArray = ((String)(object = ((String)object).trim())).contains(",") ? StringUtils.split((String)object, (String)",") : (((String)object).contains(";") ? StringUtils.split((String)object, (String)";") : (((String)object).contains(" ") ? StringUtils.split((String)object, (String)" ") : new String[]{}));
                ArrayList<Locale> arrayList = new ArrayList<Locale>();
                block10: for (String string6 : stringArray) {
                    if (StringUtils.isBlank((CharSequence)string6)) continue;
                    string6 = string6.trim();
                    for (Locale locale : Locale.getAvailableLocales()) {
                        if (!locale.getLanguage().equalsIgnoreCase(string6) && !locale.getDisplayLanguage().equalsIgnoreCase(string6)) continue;
                        arrayList.add(locale);
                        continue block10;
                    }
                }
                if (!arrayList.isEmpty()) {
                    dbContactsEntry.setLanguages(arrayList.toArray(new Locale[0]));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read languages!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            dbContactsEntry.setLanguages(null);
        }
        dbContactsEntry.publicId = StringUtils.trimToNull((String)this.getValue(cSVRecord, 47));
        object = this.getValue(cSVRecord, 48);
        if (!StringUtils.isBlank((CharSequence)object)) {
            dbContactsEntry.notes = ((String)object).replace("<br>", System.lineSeparator()).replace("<br/>", System.lineSeparator()).replace("<br />", System.lineSeparator()).trim();
        }
    }

    protected boolean saveCsvObject(DbContactsEntry dbContactsEntry, long l) {
        try {
            long l2;
            if (this.importGroup == null) {
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 3);
                this.setMessage(I18N.tr("Creating address group."));
                this.importGroup = new DbContactsGroup();
                this.importGroup.name = I18N.tr("import from {0}", (Object)dateFormat.format(this.importDate));
                this.importGroup.notes = I18N.tr("This address group stores addresses, that have been imported earlier.");
                this.getContactsHandler().saveGroup(this.dbConnection, this.importGroup);
            }
            this.setMessage(I18N.tr("Saving address at line {0}.", (Object)l));
            if (this.importGroup.id <= 0L) {
                throw new Exception("Invalid address group!");
            }
            dbContactsEntry.groupId = this.importGroup.id;
            if (!StringUtils.isBlank((CharSequence)dbContactsEntry.publicId) && (l2 = this.getContactsHandler().getEntryId(this.dbConnection, dbContactsEntry.publicId)) > 0L) {
                LOGGER.warn("Address nr '" + dbContactsEntry.publicId + "' is already in use!");
                dbContactsEntry.publicId = null;
            }
            this.getContactsHandler().saveEntry(this.dbConnection, dbContactsEntry);
            return true;
        }
        catch (Exception exception) {
            LOGGER.error("Can't save adress!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }
}

