/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.LocaleRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.IbanUtils;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import fr.marcwrobel.jbanking.iban.Iban;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ContactsEntryViewDetailsPanel
extends ContactsEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryViewDetailsPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryViewDetailsPanel.class);
    private ValidationHandler validationHandler;
    private ModificationHandler modificationHandler;
    private ContactsEntryAddressPanel entryAddressPanel;
    private JXTitledSeparator identificationTitle;
    private JXTitledSeparator idsAndNumbersTitle;
    private JXTitledSeparator languageTitle;
    private JXTitledSeparator bankAccountTitle;
    private JLabel dayOfBirthLabel;
    private DefaultDatePicker dayOfBirthField;
    private JLabel placeOfBirthLabel;
    private JTextField placeOfBirthField;
    private JLabel ausweisArtLabel;
    private JComboBox<DbContactsEntry.IdentificationType> ausweisArtField;
    private JLabel ausweisBehoerdeLabel;
    private JTextField ausweisBehoerdeField;
    private JLabel ausweisNrLabel;
    private JTextField ausweisNrField;
    private JLabel citizenshipLabel;
    private JTextField citizenshipField;
    private JLabel steuerNrLabel;
    private JTextField steuerNrField;
    private JLabel steuerIdNrLabel;
    private JTextField steuerIdNrField;
    private JLabel steuerUmsatzIdNrLabel;
    private JTextField steuerUmsatzIdNrField;
    private JLabel wirtschaftIdNrLabel;
    private JTextField wirtschaftIdNrField;
    private JLabel kontoInhaberLabel;
    private JTextField kontoInhaberField;
    private JLabel kontoInstitutLabel;
    private JTextField kontoInstitutField;
    private JLabel kontoNrLabel;
    private JTextField kontoNrField;
    private JLabel kontoBlzLabel;
    private JTextField kontoBlzField;
    private JLabel kontoIbanLabel;
    private JTextField kontoIbanField;
    private JLabel kontoBicLabel;
    private JTextField kontoBicField;
    private JList<Locale> languageList;
    private JPopupMenu languageMenu;
    private EntrySelectLanguageAction languageAction;
    private EntryBankAccountShowActionsAction bankAccountAction;

    public ContactsEntryViewDetailsPanel() {
        this(null);
    }

    public ContactsEntryViewDetailsPanel(ContactsEntryAddressPanel contactsEntryAddressPanel) {
        this.entryAddressPanel = contactsEntryAddressPanel;
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modificationHandler = ImmoToolUtils.createModificationHandler();
        this.identificationTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.idsAndNumbersTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.languageTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.bankAccountTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.dayOfBirthLabel = new JLabel();
        this.dayOfBirthField = new DefaultDatePicker();
        this.placeOfBirthLabel = new JLabel();
        this.placeOfBirthField = new JTextField();
        this.ausweisArtLabel = new JLabel();
        this.ausweisArtField = new JComboBox();
        this.ausweisArtField.addItem(null);
        for (DbContactsEntry.IdentificationType object2 : DbContactsEntry.IdentificationType.values()) {
            this.ausweisArtField.addItem(object2);
        }
        this.ausweisArtField.setRenderer((ListCellRenderer<DbContactsEntry.IdentificationType>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        this.ausweisArtField.setEditor(new AusweisArtEditor());
        this.ausweisArtField.setEditable(true);
        this.ausweisBehoerdeLabel = new JLabel();
        this.ausweisBehoerdeField = new JTextField();
        this.ausweisNrLabel = new JLabel();
        this.ausweisNrField = new JTextField();
        this.citizenshipLabel = new JLabel();
        this.citizenshipField = new JTextField();
        this.steuerNrLabel = new JLabel();
        this.steuerNrField = new JTextField();
        this.steuerIdNrLabel = new JLabel();
        this.steuerIdNrField = new JTextField();
        this.steuerUmsatzIdNrLabel = new JLabel();
        this.steuerUmsatzIdNrField = new JTextField();
        this.wirtschaftIdNrLabel = new JLabel();
        this.wirtschaftIdNrField = new JTextField();
        this.bankAccountAction = new EntryBankAccountShowActionsAction();
        this.kontoInhaberLabel = new JLabel();
        this.kontoInhaberField = new JTextField();
        this.kontoInstitutLabel = new JLabel();
        this.kontoInstitutField = new JTextField();
        this.kontoNrLabel = new JLabel();
        this.kontoNrField = new JTextField();
        this.kontoBlzLabel = new JLabel();
        this.kontoBlzField = new JTextField();
        this.kontoIbanLabel = new JLabel();
        this.kontoIbanField = new JTextField();
        this.kontoBicLabel = new JLabel();
        this.kontoBicField = new JTextField();
        this.languageAction = new EntrySelectLanguageAction();
        this.languageMenu = new JPopupMenu();
        this.languageList = new JList();
        this.languageList.setCellRenderer((ListCellRenderer<Locale>)new DefaultListCellRenderer((Renderer)new LocaleRenderer()));
        JScrollPane jScrollPane = new JScrollPane(this.languageList);
        jScrollPane.setPreferredSize(new Dimension(0, 125));
        this.validationHandler.putRule((JComponent)this.kontoBicField, new ValidationRule(){

            public boolean isValid(Object object) {
                String string = object != null ? StringUtils.trimToNull((String)object.toString()) : null;
                return string == null || IbanUtils.isValidBic((String)string);
            }
        });
        this.validationHandler.putRule((JComponent)this.kontoIbanField, new ValidationRule(){

            public boolean isValid(Object object) {
                String string = object != null ? StringUtils.trimToNull((String)object.toString()) : null;
                return string == null || IbanUtils.isValidIban((String)string);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[30dlu,pref], 3dlu, 30dlu:grow, 3dlu,right:pref, 3dlu, 30dlu:grow");
        defaultFormBuilder.add((Component)this.identificationTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.ausweisArtLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.ausweisArtField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.dayOfBirthLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.dayOfBirthField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.ausweisNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.ausweisNrField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.placeOfBirthLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.placeOfBirthField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.ausweisBehoerdeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.ausweisBehoerdeField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.citizenshipLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.citizenshipField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.idsAndNumbersTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.steuerNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.steuerNrField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.steuerIdNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.steuerIdNrField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.steuerUmsatzIdNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.steuerUmsatzIdNrField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.wirtschaftIdNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.wirtschaftIdNrField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.bankAccountTitle, (Action[])new Action[]{this.bankAccountAction})).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.kontoInhaberLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoInhaberField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.kontoInstitutLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoInstitutField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.kontoNrLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoNrField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.kontoBlzLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoBlzField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.kontoIbanLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoIbanField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.kontoBicLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.kontoBicField).xyw(3, defaultFormBuilder.row(), 5);
        DefaultFormBuilder defaultFormBuilder2 = DefaultFormBuilder.create((String)"75dlu:grow, 3dlu, pref");
        defaultFormBuilder2.add((Component)this.languageTitle).xy(1, defaultFormBuilder2.nextRow(), CellConstraints.DEFAULT, CellConstraints.TOP);
        defaultFormBuilder2.add((Component)new JButton((Action)((Object)this.languageAction))).xy(3, defaultFormBuilder2.row());
        defaultFormBuilder2.addRaw((Component)jScrollPane).xyw(1, defaultFormBuilder2.nextRow(), 3);
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder((Border)Paddings.DIALOG);
        jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
        jPanel.add((Component)defaultFormBuilder2.getPanel(), "East");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(Paddings.EMPTY);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
        jScrollPane2.getHorizontalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.setBorder(Paddings.EMPTY);
        this.add(jScrollPane2, "Center");
    }

    private void doEntryBankAccountIbanRead() {
        Iban iban = IbanUtils.getIban((String)StringUtils.trimToNull((String)this.kontoIbanField.getText()));
        if (iban == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No valid IBAN was provided!"), (Component)((Object)this));
            return;
        }
        String string = IbanUtils.getBankCodeNrFromIban((Iban)iban);
        String string2 = IbanUtils.getBankAccountNrFromIban((Iban)iban);
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't read bank account from IBAN!"), (Component)((Object)this));
        } else {
            this.kontoBlzField.setText(string);
            this.kontoNrField.setText(string2);
        }
    }

    private void doEntryBankAccountIbanWrite() {
        if (this.entryAddressPanel == null) {
            return;
        }
        String string = this.entryAddressPanel.getSelectedCountry();
        if (!IbanUtils.isValidCountry((String)string)) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't create IBAN for the selected country!"), (Component)((Object)this));
            return;
        }
        String string2 = StringUtils.trimToNull((String)this.kontoNrField.getText());
        String string3 = StringUtils.trimToNull((String)this.kontoBlzField.getText());
        if (string2 == null || string3 == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("No valid bank account was provided!"), (Component)((Object)this));
            return;
        }
        Iban iban = IbanUtils.getIbanFromBankAccount((String)string, (String)string3, (String)string2);
        if (iban == null) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The bank account is not valid for the selected country!"), (Component)((Object)this));
        } else {
            this.kontoIbanField.setText(iban.toPrintableString());
            this.validationHandler.validate((JComponent)this.kontoIbanField);
        }
    }

    private void doEntryBankAccountShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.entryAddressPanel != null) {
            jPopupMenu.add((Action)((Object)new EntryBankAccountIbanWriteAction()));
        }
        jPopupMenu.add((Action)((Object)new EntryBankAccountIbanReadAction()));
        jPopupMenu.show(component, n, n2);
    }

    private void doEntrySelectLanguage(Component component, int n, int n2) {
        this.languageMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("details"));
    }

    public boolean isTabModified() {
        return this.modificationHandler.isModified();
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbContactsEntry dbContactsEntry) {
        this.ausweisBehoerdeField.setText(dbContactsEntry != null ? dbContactsEntry.getIdentificationIssuer() : "");
        this.ausweisNrField.setText(dbContactsEntry != null ? dbContactsEntry.getIdentificationNr() : "");
        this.citizenshipField.setText(dbContactsEntry != null ? dbContactsEntry.getCitizenship() : "");
        this.kontoBicField.setText(dbContactsEntry != null ? dbContactsEntry.getBankAccountBIC() : "");
        this.kontoBlzField.setText(dbContactsEntry != null ? dbContactsEntry.getBankAccountBankCodeNr() : "");
        this.kontoInhaberField.setText(dbContactsEntry != null ? dbContactsEntry.getBankAccountOwner() : "");
        this.kontoInstitutField.setText(dbContactsEntry != null ? dbContactsEntry.getBankAccountInstitute() : "");
        this.kontoNrField.setText(dbContactsEntry != null ? dbContactsEntry.getBankAccountNr() : "");
        this.steuerIdNrField.setText(dbContactsEntry != null ? dbContactsEntry.getTaxIdNr() : "");
        this.steuerNrField.setText(dbContactsEntry != null ? dbContactsEntry.getTaxNr() : "");
        this.steuerUmsatzIdNrField.setText(dbContactsEntry != null ? dbContactsEntry.getTaxUID() : "");
        this.wirtschaftIdNrField.setText(dbContactsEntry != null ? dbContactsEntry.getTaxWirtschaftIdNr() : "");
        this.dayOfBirthField.setDate(dbContactsEntry != null ? dbContactsEntry.birthDay : null);
        this.placeOfBirthField.setText(dbContactsEntry != null ? dbContactsEntry.getPlaceOfBirth() : "");
        String string = dbContactsEntry != null ? StringUtils.trimToNull((String)dbContactsEntry.getBankAccountIBAN()) : null;
        Iban iban = IbanUtils.getIban((String)string);
        this.kontoIbanField.setText(StringUtils.trimToEmpty((String)(iban != null ? iban.toPrintableString() : string)));
        String string2 = dbContactsEntry != null ? StringUtils.trimToNull((String)dbContactsEntry.getIdentificationType()) : null;
        DbContactsEntry.IdentificationType identificationType = DbContactsEntry.IdentificationType.fromValue(string2);
        if (identificationType != null) {
            this.ausweisArtField.setSelectedItem((Object)identificationType);
        } else if (string2 != null) {
            this.ausweisArtField.setSelectedItem(string2);
        } else {
            this.ausweisArtField.setSelectedItem("");
        }
        this.loadLanguages(dbContactsEntry);
        this.modificationHandler.clear();
        this.modificationHandler.putValue((JComponent)this.ausweisNrField);
        this.modificationHandler.putValue((JComponent)this.kontoBicField);
        this.modificationHandler.putValue((JComponent)this.kontoBlzField);
        this.modificationHandler.putValue((JComponent)this.kontoIbanField);
        this.modificationHandler.putValue((JComponent)this.kontoInhaberField);
        this.modificationHandler.putValue((JComponent)this.kontoInstitutField);
        this.modificationHandler.putValue((JComponent)this.kontoNrField);
        this.modificationHandler.putValue((JComponent)this.steuerIdNrField);
        this.modificationHandler.putValue((JComponent)this.steuerNrField);
        this.modificationHandler.putValue((JComponent)this.steuerUmsatzIdNrField);
        if (dbContactsEntry == null || dbContactsEntry.id < 1L) {
            this.validationHandler.init();
        } else {
            this.validationHandler.validate();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadLanguages(DbContactsEntry dbContactsEntry) {
        Object object;
        List<Object> list = dbContactsEntry == null ? new ArrayList() : Arrays.asList(dbContactsEntry.getLanguages());
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        DefaultListModel<Locale> defaultListModel = new DefaultListModel<Locale>();
        for (Locale object22 : list) {
            treeMap.put(object22.getDisplayLanguage(), object22);
        }
        for (Locale locale : treeMap.values()) {
            defaultListModel.addElement(locale);
        }
        this.languageList.setModel(defaultListModel);
        TreeMap treeMap2 = new TreeMap();
        for (String string : Locale.getISOLanguages()) {
            object = new Locale(string);
            treeMap2.put(((Locale)object).getDisplayLanguage().toUpperCase(), object);
        }
        this.languageMenu.removeAll();
        Object var6_10 = null;
        JMenu jMenu = null;
        for (final Locale locale : treeMap2.values()) {
            void var6_11;
            object = locale.getDisplayLanguage();
            if (var6_11 == null || !var6_11.equals(((String)object).toUpperCase().substring(0, 1))) {
                String string = ((String)object).toUpperCase().substring(0, 1);
                jMenu = new JMenu(string);
                this.languageMenu.add(jMenu);
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((String)object);
            jCheckBoxMenuItem.setSelected(list.contains(locale));
            jCheckBoxMenuItem.setOpaque(true);
            jMenu.add(jCheckBoxMenuItem);
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                    if (jCheckBoxMenuItem.isSelected()) {
                        ((DefaultListModel)ContactsEntryViewDetailsPanel.this.languageList.getModel()).addElement(locale);
                    } else {
                        ((DefaultListModel)ContactsEntryViewDetailsPanel.this.languageList.getModel()).removeElement(locale);
                    }
                }
            });
        }
    }

    @Override
    public void save(DbContactsEntry dbContactsEntry) {
        dbContactsEntry.setCitizenship(this.citizenshipField.getText().trim());
        dbContactsEntry.setIdentificationIssuer(this.ausweisBehoerdeField.getText().trim());
        dbContactsEntry.setIdentificationNr(this.ausweisNrField.getText().trim());
        dbContactsEntry.setBankAccountBIC(this.kontoBicField.getText().replaceAll("\\s+", "").trim());
        dbContactsEntry.setBankAccountBankCodeNr(this.kontoBlzField.getText().trim());
        dbContactsEntry.setBankAccountOwner(this.kontoInhaberField.getText().trim());
        dbContactsEntry.setBankAccountInstitute(this.kontoInstitutField.getText().trim());
        dbContactsEntry.setBankAccountNr(this.kontoNrField.getText().trim());
        dbContactsEntry.setTaxIdNr(this.steuerIdNrField.getText().trim());
        dbContactsEntry.setTaxNr(this.steuerNrField.getText().trim());
        dbContactsEntry.setTaxUID(this.steuerUmsatzIdNrField.getText().trim());
        dbContactsEntry.setTaxWirtschaftIdNr(this.wirtschaftIdNrField.getText().trim());
        dbContactsEntry.setPlaceOfBirth(this.placeOfBirthField.getText().trim());
        dbContactsEntry.birthDay = this.dayOfBirthField.getDate();
        Iban iban = IbanUtils.getIban((String)StringUtils.trimToNull((String)this.kontoIbanField.getText()));
        dbContactsEntry.setBankAccountIBAN(iban != null ? iban.toString() : null);
        Object object = this.ausweisArtField.getSelectedItem();
        if (object instanceof DbContactsEntry.IdentificationType) {
            dbContactsEntry.setIdentificationType(((DbContactsEntry.IdentificationType)((Object)object)).name());
        } else if (object instanceof String) {
            dbContactsEntry.setIdentificationType(StringUtils.trimToNull((String)((String)object)));
        } else {
            dbContactsEntry.setIdentificationType((String)null);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        for (int i = 0; i < this.languageList.getModel().getSize(); ++i) {
            arrayList.add(this.languageList.getModel().getElementAt(i));
        }
        dbContactsEntry.setLanguages(arrayList.toArray(new Locale[0]));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dayOfBirthField.setEnabled(bl);
        this.placeOfBirthField.setEnabled(bl);
        this.ausweisArtField.setEnabled(bl);
        this.ausweisBehoerdeField.setEnabled(bl);
        this.ausweisNrField.setEnabled(bl);
        this.citizenshipField.setEnabled(bl);
        this.steuerNrField.setEnabled(bl);
        this.steuerIdNrField.setEnabled(bl);
        this.steuerUmsatzIdNrField.setEnabled(bl);
        this.wirtschaftIdNrField.setEnabled(bl);
        this.kontoInhaberField.setEnabled(bl);
        this.kontoInstitutField.setEnabled(bl);
        this.kontoNrField.setEnabled(bl);
        this.kontoBlzField.setEnabled(bl);
        this.kontoIbanField.setEnabled(bl);
        this.kontoBicField.setEnabled(bl);
        this.languageList.setEnabled(bl);
        this.languageAction.setEnabled(bl);
        this.bankAccountAction.setEnabled(bl);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.identificationTitle.setTitle(StringUtils.capitalize((String)I18N.tr("identification")));
        this.idsAndNumbersTitle.setTitle(StringUtils.capitalize((String)I18N.tr("ID's & numbers")));
        this.languageTitle.setTitle(StringUtils.capitalize((String)I18N.tr("contact languages")));
        this.bankAccountTitle.setTitle(StringUtils.capitalize((String)I18N.tr("bank account")));
        this.dayOfBirthLabel.setText(StringUtils.capitalize((String)I18N.tr("birthday")) + ":");
        this.dayOfBirthField.setToolTipText(I18N.tr("Enter the person's day of birth."));
        this.placeOfBirthLabel.setText(StringUtils.capitalize((String)I18N.tr("birthplace")) + ":");
        this.placeOfBirthField.setToolTipText(I18N.tr("Enter the person's place of birth."));
        this.ausweisArtLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-card type")) + ":");
        this.ausweisArtField.setToolTipText(I18N.tr("Enter the type of the person's ID card."));
        this.ausweisBehoerdeLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-card issuer")) + ":");
        this.ausweisBehoerdeField.setToolTipText(I18N.tr("Enter the issuing authority of the person's ID card."));
        this.ausweisNrLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-card nr")) + ":");
        this.ausweisNrField.setToolTipText(I18N.tr("Enter the number of the person's ID card."));
        this.citizenshipLabel.setText(StringUtils.capitalize((String)I18N.tr("citizenship")) + ":");
        this.citizenshipField.setToolTipText(I18N.tr("Enter the person's citizenship."));
        this.steuerNrLabel.setText(StringUtils.capitalize((String)I18N.tr("tax nr")) + ":");
        this.steuerNrField.setToolTipText(I18N.tr("Enter the person's tax number."));
        this.steuerIdNrLabel.setText(StringUtils.capitalize((String)I18N.tr("tax ID nr")) + ":");
        this.steuerIdNrField.setToolTipText(I18N.tr("Enter the person's tax identification number."));
        this.steuerUmsatzIdNrLabel.setText(StringUtils.capitalize((String)I18N.tr("sales tax ID nr")) + ":");
        this.steuerUmsatzIdNrField.setToolTipText(I18N.tr("Enter the person's sales tax identification number."));
        this.wirtschaftIdNrLabel.setText(StringUtils.capitalize((String)I18N.tr("economy ID nr")) + ":");
        this.wirtschaftIdNrField.setToolTipText(I18N.tr("Enter the person's economy identification number."));
        this.kontoInhaberLabel.setText(StringUtils.capitalize((String)I18N.tr("account owner")) + ":");
        this.kontoInhaberField.setToolTipText(I18N.tr("Enter the owner of the person's bank account."));
        this.kontoInstitutLabel.setText(StringUtils.capitalize((String)I18N.tr("institute")) + ":");
        this.kontoInstitutField.setToolTipText(I18N.tr("Enter the institute name of the person's bank account."));
        this.kontoNrLabel.setText(StringUtils.capitalize((String)I18N.tr("account nr")) + ":");
        this.kontoNrField.setToolTipText(I18N.tr("Enter the number of the person's bank account."));
        this.kontoBlzLabel.setText(StringUtils.capitalize((String)I18N.tr("bank code nr")) + ":");
        this.kontoBlzField.setToolTipText(I18N.tr("Enter the institute number of the person's bank account."));
        this.kontoIbanLabel.setText(StringUtils.capitalize((String)I18N.tr("IBAN")) + ":");
        this.kontoIbanField.setToolTipText(I18N.tr("Enter the IBAN number of the person's bank account."));
        this.kontoBicLabel.setText(StringUtils.capitalize((String)I18N.tr("BIC")) + ":");
        this.kontoBicField.setToolTipText(I18N.tr("Enter the BIC number of the person's bank account."));
    }

    private static class AusweisArtEditor
    extends JTextField
    implements ComboBoxEditor {
        private AusweisArtEditor() {
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public void setItem(Object object) {
            DbContactsEntry.IdentificationType identificationType = object instanceof DbContactsEntry.IdentificationType ? (DbContactsEntry.IdentificationType)((Object)object) : (object instanceof String ? DbContactsEntry.IdentificationType.fromValue((String)object) : null);
            if (identificationType != null) {
                this.setText(identificationType.getTranslation());
            } else if (object instanceof String) {
                this.setText(StringUtils.trimToEmpty((String)((String)object)));
            } else {
                this.setText("");
            }
        }

        @Override
        public Object getItem() {
            String string = StringUtils.trimToEmpty((String)this.getText());
            DbContactsEntry.IdentificationType identificationType = DbContactsEntry.IdentificationType.fromValue(string);
            return identificationType != null ? identificationType : string;
        }
    }

    private class EntrySelectLanguageAction
    extends AbstractI18nAction {
        private EntrySelectLanguageAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"flag.png", (int)16));
            this.setName("");
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            ContactsEntryViewDetailsPanel.this.doEntrySelectLanguage(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setShortDescription(I18N.tr("Select the languages, that are spoken by the person."));
        }
    }

    private class EntryBankAccountShowActionsAction
    extends AbstractI18nAction {
        private EntryBankAccountShowActionsAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            ContactsEntryViewDetailsPanel.this.doEntryBankAccountShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the bank account."));
        }
    }

    private class EntryBankAccountIbanWriteAction
    extends AbstractI18nAction {
        private EntryBankAccountIbanWriteAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryViewDetailsPanel.this.doEntryBankAccountIbanWrite();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.setName(I18N.tr("Create IBAN from account data."));
        }
    }

    private class EntryBankAccountIbanReadAction
    extends AbstractI18nAction {
        private EntryBankAccountIbanReadAction() {
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryViewDetailsPanel.this.doEntryBankAccountIbanRead();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.setName(I18N.tr("Create account data from IBAN."));
        }
    }
}

