/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.ContactsPluginUtils;
import com.openindex.openestate.tool.contacts.extensions.DbContactsExtension;
import com.openindex.openestate.tool.extensions.ProjectAdapter;
import java.io.IOException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsProjectExtension
extends ProjectAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsProjectExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsProjectExtension.class);

    public void close(ImmoToolProject immoToolProject) throws ImmoToolException {
        ContactsPlugin.unloadSettings();
        ContactsPlugin.setDbContactsExtension(null);
    }

    public void open(ImmoToolProject immoToolProject) throws ImmoToolException {
        DbContactsExtension dbContactsExtension = ContactsPluginUtils.getDbContactsExtension(immoToolProject);
        if (dbContactsExtension == null) {
            throw new ImmoToolException("Can't find a usable DbContactsExtension!");
        }
        ContactsPlugin.setDbContactsExtension(dbContactsExtension);
        try {
            ContactsPlugin.loadSettings(immoToolProject);
        }
        catch (SQLException sQLException) {
            throw new ImmoToolException("Can't load contacts settings!", (Throwable)sQLException);
        }
        catch (IOException iOException) {
            throw new ImmoToolException("Can't load contacts settings!", (Throwable)iOException);
        }
    }
}

