/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.gui;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EntryListCellRenderer
extends DefaultListCellRenderer<DbContactsEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryListCellRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(EntryListCellRenderer.class);
    private final String emptyText;

    public EntryListCellRenderer() {
        this(null);
    }

    public EntryListCellRenderer(String string) {
        this.emptyText = string;
    }

    public String getEmptyText() {
        return StringUtils.trimToEmpty((String)this.emptyText);
    }

    public Component getRenderedComponent(JList<? extends DbContactsEntry> jList, DbContactsEntry dbContactsEntry, int n, boolean bl, boolean bl2) {
        JLabel jLabel = (JLabel)super.getRenderedComponent(jList, (Object)dbContactsEntry, n, bl, bl2);
        jLabel.setBackground(bl ? jList.getSelectionBackground() : (n % 2 == 0 ? Color.WHITE : ImmoToolUtils.TABLE_HIGHLIGHT_COLOR));
        jLabel.setForeground(bl ? jList.getSelectionForeground() : Color.BLACK);
        if (dbContactsEntry == null) {
            jLabel.setText("<html><div style=\"margin:3px;\">[ " + StringEscapeUtils.escapeXml11((String)this.getEmptyText()) + " ]</div></html>");
        } else {
            String string;
            String string2 = dbContactsEntry.address.writePersonFullName();
            if (string2 != null) {
                string2 = string2.trim();
            }
            if ((string = dbContactsEntry.address.getCompanyName()) != null) {
                string = string.trim();
            }
            jLabel.setText("<html><div style=\"margin:3px;\"><b>#" + dbContactsEntry.id + "</b> | " + (string2 != null && string2.length() > 0 ? StringEscapeUtils.escapeXml11((String)string2) + "<br>" : "") + (string != null && string.length() > 0 ? StringEscapeUtils.escapeXml11((String)string) + "<br>" : "") + "<font size=\"-1\"><i>" + StringEscapeUtils.escapeXml11((String)dbContactsEntry.address.writeFullAddress(", ")) + "</i></font></div></html>");
        }
        return jLabel;
    }

    protected void init() {
        super.init();
        this.setOpaque(true);
    }
}

