-- -----------------------------------------------------
-- Calender extensions to the Contacts-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_contacts_entries_calendar_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_contacts_entries_calendar_entries (
  contacts_entry_id BIGINT NOT NULL,
  calendar_entry_id BIGINT NOT NULL,
  relation_type VARCHAR(100) DEFAULT NULL NULL,
  relation_notes LONGVARCHAR DEFAULT NULL NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (contacts_entry_id, calendar_entry_id),
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (calendar_entry_id)
    REFERENCES immotool_calendar_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_contacts_entries_calendar_entries AS
  SELECT * FROM immotool_contacts_entries_calendar_entries
  WHERE contacts_entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries)
  AND calendar_entry_id IN (SELECT entry_id FROM view_immotool_calendar_entries);

GRANT SELECT
  ON view_immotool_contacts_entries_calendar_entries
  TO "IMMOTOOL";
