-- -----------------------------------------------------
-- Contacts-Addon for OpenEstate-ImmoTool
-- update 5 for HSQLDB
-- Copyright (C) 2009-2018 OpenEstate.org
-- -----------------------------------------------------
-- Remove access fields in 'immotool_contacts_entries'
-- Rebuild 'view_immotool_contacts_entries'
-- Rebuild 'view_immotool_contacts_entries_logs'
-- Rebuild 'view_immotool_contacts_entries_settings'
-- Rebuild 'view_immotool_contacts_entries_files'
-- Rebuild 'view_immotool_contacts_entries_files_content'
-- Rebuild 'can_delete_immotool_contacts_entries'
-- Rebuild 'can_write_immotool_contacts_entries'
-- Rebuild 'remove_immotool_contacts_entries'
-- Rebuild 'remove_immotool_contacts_entries_address'
-- Rebuild 'remove_immotool_contacts_entries_settings'
-- Rebuild 'save_immotool_contacts_entries'
-- Rebuild 'save_immotool_contacts_entries_logs'
-- Rebuild 'save_immotool_contacts_entries_settings'
-- Rebuild 'set_immotool_contacts_entries_active'
-- Rebuild 'set_immotool_contacts_entries_group'
-- -----------------------------------------------------


DROP VIEW IF EXISTS view_immotool_contacts_entries CASCADE;
DROP VIEW IF EXISTS view_immotool_contacts_entries_logs CASCADE;
DROP VIEW IF EXISTS view_immotool_contacts_entries_settings CASCADE;
DROP VIEW IF EXISTS view_immotool_contacts_entries_files CASCADE;
DROP VIEW IF EXISTS view_immotool_contacts_entries_files_content CASCADE;
DROP FUNCTION IF EXISTS can_delete_immotool_contacts_entries CASCADE;
DROP FUNCTION IF EXISTS can_write_immotool_contacts_entries CASCADE;
DROP PROCEDURE IF EXISTS remove_immotool_contacts_entries CASCADE;
DROP PROCEDURE IF EXISTS remove_immotool_contacts_entries_address CASCADE;
DROP PROCEDURE IF EXISTS remove_immotool_contacts_entries_settings CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_contacts_entries CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_contacts_entries_logs CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_contacts_entries_settings CASCADE;
DROP PROCEDURE IF EXISTS set_immotool_contacts_entries_active CASCADE;
DROP PROCEDURE IF EXISTS set_immotool_contacts_entries_group CASCADE;


-- -----------------------------------------------------
-- Remove access fields in 'immotool_contacts_entries'
-- -----------------------------------------------------
ALTER TABLE immotool_contacts_entries
  DROP COLUMN access_owner_id CASCADE;
ALTER TABLE immotool_contacts_entries
  DROP COLUMN access_group_id CASCADE;
ALTER TABLE immotool_contacts_entries
  DROP COLUMN access_permissions CASCADE;


-- -----------------------------------------------------
-- Rebuild 'view_immotool_contacts_entries'
-- -----------------------------------------------------
CREATE VIEW view_immotool_contacts_entries AS
  SELECT * FROM immotool_contacts_entries
  WHERE group_id IN (SELECT group_id FROM view_immotool_contacts_groups);

GRANT SELECT
  ON view_immotool_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'view_immotool_contacts_entries_logs'
-- -----------------------------------------------------
CREATE VIEW view_immotool_contacts_entries_logs AS
  SELECT a.entry_id, b.* FROM immotool_contacts_entries_logs a
  INNER JOIN immotool_logs b ON ( a.log_id = b.log_id )
  WHERE a.entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries)
  AND b.plugin_id IN (SELECT plugin_id FROM view_immotool_plugins WHERE plugin_name='OpenEstate-Tool-Contacts');

GRANT SELECT
  ON view_immotool_contacts_entries_logs
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'view_immotool_contacts_entries_settings'
-- -----------------------------------------------------
CREATE VIEW view_immotool_contacts_entries_settings AS
  SELECT * FROM immotool_contacts_entries_settings
  WHERE entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_contacts_entries_settings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'view_immotool_contacts_entries_files'
-- -----------------------------------------------------
CREATE VIEW view_immotool_contacts_entries_files (
  file_id,
  entry_id,
  file_name,
  file_mimetype,
  created_at,
  modified_at) AS
  SELECT
    file_id,
    entry_id,
    file_name,
    file_mimetype,
    created_at,
    modified_at
  FROM immotool_contacts_entries_files
  WHERE entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_contacts_entries_files
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'view_immotool_contacts_entries_files_content'
-- -----------------------------------------------------
CREATE VIEW view_immotool_contacts_entries_files_content (
  file_id,
  file_content,
  created_at,
  modified_at) AS
  SELECT
    file_id,
    file_content,
    created_at,
    modified_at
  FROM immotool_contacts_entries_files
  WHERE entry_id IN (SELECT entry_id FROM view_immotool_contacts_entries);

GRANT SELECT
  ON view_immotool_contacts_entries_files_content
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'can_delete_immotool_contacts_entries'
-- -----------------------------------------------------
\.
CREATE FUNCTION can_delete_immotool_contacts_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_contacts_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Benutzer-Rechte der Adress-Gruppe ermitteln
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_contacts_groups
      WHERE group_id IN (SELECT group_id FROM immotool_contacts_entries WHERE entry_id = val_entry_id);

    -- Zum Löschen eines Adress-Eintrages müssen Schreibrechte auf der Adress-Gruppe vorliegen
    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild 'can_write_immotool_contacts_entries'
-- -----------------------------------------------------
\.
CREATE FUNCTION can_write_immotool_contacts_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_contacts_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Benutzer-Rechte der Adress-Gruppe ermitteln
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_contacts_groups
      WHERE group_id IN (SELECT group_id FROM immotool_contacts_entries WHERE entry_id = val_entry_id);

    -- Zum Bearbeiten eines Adress-Eintrages müssen Schreibrechte auf der Adress-Gruppe vorliegen
    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild 'remove_immotool_contacts_entries'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_immotool_contacts_entries( val_entry_id BIGINT )
  SPECIFIC remove_immotool_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lösch-Rechte besitzt
    SET allowed = can_delete_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag entfernen
    DELETE
      FROM immotool_contacts_entries
      WHERE entry_id = val_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'remove_immotool_contacts_entries_address'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_immotool_contacts_entries_address(
    val_entry_id BIGINT,
    val_setting_key VARCHAR(255)
  )
  SPECIFIC remove_immotool_contacts_entries_address
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Alle Settings des Eintrages entfernen
    IF val_setting_key IS NULL THEN
      DELETE
        FROM immotool_contacts_entries_settings
        WHERE entry_id = val_entry_id
        AND setting_key LIKE 'entry.%';

    -- Spezifisches Setting des Eintrages entfernen
    ELSE
      DELETE
        FROM immotool_contacts_entries_settings
        WHERE entry_id = val_entry_id
        AND setting_key LIKE 'entry.%'
        AND setting_key = val_setting_key;
    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_contacts_entries_address
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'remove_immotool_contacts_entries_settings'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_immotool_contacts_entries_settings(
    val_entry_id BIGINT,
    val_setting_key VARCHAR(255)
  )
  SPECIFIC remove_immotool_contacts_entries_settings
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Alle Settings des Eintrages entfernen
    IF val_setting_key IS NULL THEN
      DELETE
        FROM immotool_contacts_entries_settings
        WHERE entry_id = val_entry_id
        AND setting_key NOT LIKE 'entry.%';

    -- Spezifisches Setting des Eintrages entfernen
    ELSE
      DELETE
        FROM immotool_contacts_entries_settings
        WHERE entry_id = val_entry_id
        AND setting_key NOT LIKE 'entry.%'
        AND setting_key = val_setting_key;
    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_contacts_entries_settings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_contacts_entries'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_contacts_entries(
    INOUT val_entry_id BIGINT,
    val_group_id BIGINT,
    val_entry_public_id VARCHAR(255),
    val_entry_notes LONGVARCHAR,
    val_entry_active BOOLEAN,
    val_entry_birthday DATE
  )
  SPECIFIC save_immotool_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte auf der Adress-Gruppe vorliegen
    IF val_group_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;
    SET allowed = can_write_immotool_contacts_groups( val_group_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Eintrag erzeugen
    IF val_entry_id < 1 THEN

      -- Eintrag speichern
      INSERT INTO immotool_contacts_entries (
        group_id,
        entry_public_id,
        entry_notes,
        entry_active,
        entry_birthday )
      VALUES (
        val_group_id,
        val_entry_public_id,
        val_entry_notes,
        val_entry_active,
        val_entry_birthday );

      -- ID zurückliefern
      SET val_entry_id = IDENTITY();

    -- Bestehenden Eintrag bearbeiten
    ELSE

      -- Eintrag bearbeiten
      UPDATE immotool_contacts_entries
        SET
          group_id = val_group_id,
          entry_public_id = val_entry_public_id,
          entry_notes = val_entry_notes,
          entry_active = val_entry_active,
          entry_birthday = val_entry_birthday,
          modified_at = NOW()
        WHERE
          entry_id = val_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_contacts_entries_logs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_contacts_entries_logs(
    val_log_id BIGINT,
    val_entry_id BIGINT
  )
  SPECIFIC save_immotool_contacts_entries_logs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Protokolleintrag aktualisieren
    DELETE
      FROM immotool_contacts_entries_logs
      WHERE log_id = val_log_id;

    INSERT
      INTO immotool_contacts_entries_logs (log_id, entry_id)
      VALUES (val_log_id, val_entry_id);

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_contacts_entries_logs
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_contacts_entries_settings'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_contacts_entries_settings(
    val_entry_id BIGINT,
    val_setting_key VARCHAR(255),
    val_setting_value LONGVARCHAR
  )
  SPECIFIC save_immotool_contacts_entries_settings
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Existierenden Eintrag entfernen, wenn vorhanden
    DELETE FROM immotool_contacts_entries_settings
      WHERE entry_id = val_entry_id
      AND setting_key = val_setting_key;

    -- Eintrag speichern, wenn ein Wert angegeben wurde
    IF (val_setting_value IS NOT NULL) THEN

      INSERT INTO immotool_contacts_entries_settings (
        entry_id,
        setting_key,
        setting_value )
      VALUES (
        val_entry_id,
        val_setting_key,
        val_setting_value );

  	END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_contacts_entries_settings
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'set_immotool_contacts_entries_active'
-- -----------------------------------------------------
\.
CREATE PROCEDURE set_immotool_contacts_entries_active(
    val_entry_id BIGINT,
    val_entry_active BOOLEAN
  )
  SPECIFIC set_immotool_contacts_entries_active
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag bearbeiten
    UPDATE immotool_contacts_entries
      SET
        entry_active = val_entry_active,
        modified_at = NOW()
      WHERE
        entry_id = val_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE set_immotool_contacts_entries_active
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'set_immotool_contacts_entries_group'
-- -----------------------------------------------------
\.
CREATE PROCEDURE set_immotool_contacts_entries_group(
    val_entry_id BIGINT,
    val_group_id BIGINT
  )
  SPECIFIC set_immotool_contacts_entries_group
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte auf der Adresse besitzt
    SET allowed = can_write_immotool_contacts_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte auf der neuen Adress-Gruppe besitzt
    SET allowed = can_write_immotool_contacts_groups( val_group_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag bearbeiten
    UPDATE immotool_contacts_entries
      SET
        group_id = val_group_id,
        modified_at = NOW()
      WHERE
        entry_id = val_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE set_immotool_contacts_entries_group
  TO "IMMOTOOL";
