/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.utils.ProjectPermission;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public enum CalendarPermission implements ProjectPermission
{
    USE_PLUGIN(null, I18n.marktr((String)"use addon")),
    GROUPS_EDIT(USE_PLUGIN, I18n.marktr((String)"edit calendar groups")),
    GROUPS_REMOVE(USE_PLUGIN, I18n.marktr((String)"remove calendar groups")),
    ENTRIES_EDIT(USE_PLUGIN, I18n.marktr((String)"edit calendar entries")),
    ENTRIES_EDIT_GROUP(ENTRIES_EDIT, I18n.marktr((String)"change group of calendar entries")),
    ENTRIES_IMPORT(USE_PLUGIN, I18n.marktr((String)"import calendar entries")),
    ENTRIES_REMOVE(USE_PLUGIN, I18n.marktr((String)"remove calendar entries"));

    private static final Logger LOGGER;
    private static final I18n I18N;
    private final String i18nKey;
    private final ProjectPermission parent;

    private CalendarPermission(ProjectPermission projectPermission, String string2) {
        this.parent = projectPermission;
        this.i18nKey = string2;
    }

    public ProjectPermission[] getChildren() {
        ArrayList<CalendarPermission> arrayList = new ArrayList<CalendarPermission>();
        for (CalendarPermission calendarPermission : CalendarPermission.values()) {
            if (!this.equals(calendarPermission.parent)) continue;
            arrayList.add(calendarPermission);
        }
        return arrayList.toArray(new ProjectPermission[0]);
    }

    public String getKey() {
        return this.name();
    }

    public ProjectPermission getParent() {
        return this.parent;
    }

    public String getTranslation() {
        return ImmoToolUtils.getI18nString(CalendarPermission.class, (String)this.i18nKey);
    }

    public String getTranslation(Locale locale) {
        return ImmoToolUtils.getI18nString(CalendarPermission.class, (String)this.i18nKey, (Locale)locale);
    }

    static {
        LOGGER = LoggerFactory.getLogger(CalendarPermission.class);
        I18N = I18nFactory.getI18n(CalendarPermission.class);
    }
}

