/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.gui;

import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import java.awt.Color;
import javax.swing.JLabel;
import net.fortuna.ical4j.model.property.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class StatusRenderer
extends AbstractRenderer<Status> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(StatusRenderer.class);
    private final DbCalendarEntry.Type type;

    public StatusRenderer() {
        this(null, null);
    }

    public StatusRenderer(DbCalendarEntry.Type type) {
        this(type, null);
    }

    public StatusRenderer(String string) {
        this(null, string);
    }

    public StatusRenderer(DbCalendarEntry.Type type, String string) {
        super(string);
        this.type = type;
    }

    protected DbCalendarEntry.Type getType() {
        return this.type;
    }

    public void render(Status status, JLabel jLabel) {
        if (status != null) {
            DbCalendarEntry.Type type = this.getType();
            jLabel.setText(DbCalendarEntry.writeStatus(type, status));
            if (DbCalendarEntry.Type.VEVENT.equals((Object)type)) {
                jLabel.setForeground(DbCalendarEventEntry.getStatusColor(status));
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            } else if (DbCalendarEntry.Type.VTODO.equals((Object)type)) {
                jLabel.setForeground(DbCalendarTodoEntry.getStatusColor(status));
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            } else {
                jLabel.setForeground(Color.BLACK);
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }
        } else {
            jLabel.setText(this.getEmptyText());
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setForeground(Color.BLACK);
        }
    }
}

