/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.calendar.CalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarEntry;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryTable.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryTable.class);

    public CalendarEntryTable(String string) {
        super(string);
    }

    public CalendarEntryTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public Long getCalendarGroupIdAt(int n) {
        CalendarEntry calendarEntry = this.getCalendarEntryAt(n);
        return calendarEntry instanceof DbCalendarEntry ? ((DbCalendarEntry)calendarEntry).groupId : 0L;
    }

    public CalendarEntry getCalendarEntryAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getEntry() : null;
    }

    public Long getCalendarEntryIdAt(int n) {
        CalendarEntry calendarEntry = this.getCalendarEntryAt(n);
        return calendarEntry instanceof DbCalendarEntry ? ((DbCalendarEntry)calendarEntry).id : 0L;
    }

    public int getRowForEntryId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getCalendarEntryIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.setColumnControlVisible(true);
        super.init();
        this.getColumn(Column.ID).setMaxWidth(75);
        this.setSortOrder(Column.DATE_BEGIN.getColumnId(), SortOrder.ASCENDING);
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    private static class CalendarDate
    extends Date {
        private boolean withTime;

        public CalendarDate(Date date, boolean bl) {
            this(date.getTime(), bl);
        }

        public CalendarDate(long l, boolean bl) {
            super(l);
            this.withTime = bl;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof CalendarDate && super.equals(object);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Boolean.valueOf(this.withTime).hashCode();
        }

        public boolean isWithTime() {
            return this.withTime;
        }
    }

    public static class Row
    extends AbstractTable.Row {
        private final CalendarEntry entry;
        private final String calendarName;

        public Row(VirtualCalendarEntry virtualCalendarEntry) {
            this.entry = virtualCalendarEntry;
            this.calendarName = virtualCalendarEntry.getExtension().getTitle();
        }

        public Row(DbCalendarEntry dbCalendarEntry, String string) {
            this.entry = dbCalendarEntry;
            this.calendarName = string;
        }

        public String getCalendarName() {
            return this.calendarName;
        }

        public CalendarEntry getEntry() {
            return this.entry;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForCalendar((Column)column);
            }
            return null;
        }

        public Object getValueForCalendar(Column column) {
            if (this.entry == null) {
                return null;
            }
            DbCalendarEntry dbCalendarEntry = this.entry instanceof DbCalendarEntry ? (DbCalendarEntry)this.entry : null;
            VirtualCalendarEntry virtualCalendarEntry = this.entry instanceof VirtualCalendarEntry ? (VirtualCalendarEntry)this.entry : null;
            switch (column) {
                case ID: {
                    return dbCalendarEntry != null ? dbCalendarEntry.id : 0L;
                }
                case CALENDAR: {
                    return StringUtils.trimToNull((String)this.calendarName);
                }
                case SUMMARY: {
                    if (virtualCalendarEntry != null) {
                        String string = StringUtils.trimToNull((String)virtualCalendarEntry.getSubTitle());
                        return StringUtils.trimToEmpty((String)virtualCalendarEntry.getTitle()) + (string != null ? " (" + string + ")" : "");
                    }
                    if (dbCalendarEntry != null) {
                        return StringUtils.trimToNull((String)dbCalendarEntry.getTitle());
                    }
                    return null;
                }
                case TYPE: {
                    return dbCalendarEntry != null ? dbCalendarEntry.writeType() : null;
                }
                case STATUS: {
                    return dbCalendarEntry != null ? dbCalendarEntry.writeStatus() : null;
                }
                case LOCATION: {
                    return dbCalendarEntry != null ? StringUtils.trimToNull((String)dbCalendarEntry.getLocation()) : null;
                }
                case DATE_BEGIN: {
                    if (virtualCalendarEntry != null) {
                        return new CalendarDate(virtualCalendarEntry.getBegin(), true);
                    }
                    if (dbCalendarEntry != null) {
                        return dbCalendarEntry.begin != null && dbCalendarEntry.hasBeginTime() ? new CalendarDate(dbCalendarEntry.begin, true) : (dbCalendarEntry.begin != null && dbCalendarEntry.hasBeginDate() ? new CalendarDate(dbCalendarEntry.begin, false) : null);
                    }
                    return null;
                }
                case DATE_FINISH: {
                    if (virtualCalendarEntry != null) {
                        return new CalendarDate(virtualCalendarEntry.getEnd(), true);
                    }
                    if (dbCalendarEntry != null) {
                        return dbCalendarEntry.end != null && dbCalendarEntry.hasEndTime() ? new CalendarDate(dbCalendarEntry.end, true) : (dbCalendarEntry.end != null && dbCalendarEntry.hasEndDate() ? new CalendarDate(dbCalendarEntry.end, false) : null);
                    }
                    return null;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        DATE_BEGIN,
        DATE_FINISH,
        SUMMARY,
        LOCATION,
        CALENDAR,
        TYPE,
        STATUS;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case DATE_BEGIN: 
                case DATE_FINISH: {
                    return new DefaultTableCellRenderer((Renderer)new AbstractRenderer<Date>(){
                        private final DateFormat dateFormatter = DateFormat.getDateInstance(2);
                        private final DateFormat dateTimeformatter = DateFormat.getDateTimeInstance(2, 3);

                        public void render(Date date, JLabel jLabel) {
                            if (date != null) {
                                if (date instanceof CalendarDate) {
                                    CalendarDate calendarDate = (CalendarDate)date;
                                    if (calendarDate.isWithTime()) {
                                        jLabel.setText(this.dateTimeformatter.format(calendarDate));
                                    } else {
                                        jLabel.setText(this.dateFormatter.format(calendarDate));
                                    }
                                } else {
                                    jLabel.setText(this.dateTimeformatter.format(date));
                                }
                            } else {
                                jLabel.setText(this.getEmptyText());
                            }
                        }
                    });
                }
                case LOCATION: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case DATE_BEGIN: 
                case DATE_FINISH: {
                    return CalendarDate.class;
                }
                case LOCATION: 
                case CALENDAR: 
                case SUMMARY: 
                case STATUS: 
                case TYPE: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case DATE_BEGIN: {
                    return StringUtils.capitalize((String)I18N.tr("begin"));
                }
                case DATE_FINISH: {
                    return StringUtils.capitalize((String)I18N.tr("end"));
                }
                case CALENDAR: {
                    return StringUtils.capitalize((String)I18N.tr("calendar"));
                }
                case SUMMARY: {
                    return StringUtils.capitalize((String)I18N.tr("title"));
                }
                case LOCATION: {
                    return StringUtils.capitalize((String)I18N.tr("place"));
                }
                case STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("status"));
                }
                case TYPE: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
                case LOCATION: {
                    return false;
                }
                case TYPE: {
                    return false;
                }
            }
            return true;
        }
    }
}

