/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.extensions.FrameMenuAdapter;
import com.openindex.openestate.tool.gui.DefaultMenu;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarFrameMenuExtension
extends FrameMenuAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarFrameMenuExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarFrameMenuExtension.class);
    public static final int MENU_BEGIN = 0;
    public static final int MENU_SELECT = 1;
    public static final int MENU_ADD = 2;
    public static final int MENU_ADD_BEGIN = 3;
    public static final int MENU_ADD_EVENT = 4;
    public static final int MENU_ADD_TODO = 5;
    public static final int MENU_ADD_GROUP = 6;
    public static final int MENU_ADD_END = 7;
    public static final int MENU_CALENDAR = 8;
    public static final int MENU_ELSE = 9;
    public static final int MENU_ELSE_BEGIN = 10;
    public static final int MENU_ELSE_SYNC = 11;
    public static final int MENU_ELSE_END = 12;
    public static final int MENU_END = 13;

    public JMenu createMainMenu() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        Collection collection = CalendarFrameMenuExtension.getAddons((ImmoToolProject)immoToolProject, ((Object)((Object)this)).getClass());
        DefaultMenu defaultMenu = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(CalendarPlugin.getInstance().getTitle());
            }
        };
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)0, (Collection)collection);
        defaultMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.SidebarSelectAction())));
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)1, (Collection)collection);
        DefaultMenu defaultMenu2 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("new entry")));
                this.setToolTipText(I18N.tr("Create a new entry in the calendar addon."));
            }
        };
        defaultMenu2.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)3, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)) {
            defaultMenu2.add(new JMenuItem((Action)((Object)new CalendarPlugin.EntryFormAction(DbCalendarEntry.Type.VTODO))));
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)5, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_EDIT)) {
            defaultMenu2.add(new JMenuItem((Action)((Object)new CalendarPlugin.EntryFormAction(DbCalendarEntry.Type.VEVENT))));
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)4, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT)) {
            if (defaultMenu2.getItemCount() > 0) {
                defaultMenu2.addSeparator();
            }
            defaultMenu2.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarDialogAction())));
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)6, (Collection)collection);
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu2, (int)7, (Collection)collection);
        if (defaultMenu2.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu2);
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)2, (Collection)collection);
        if (defaultMenu.getItemCount() > 0) {
            defaultMenu.addSeparator();
        }
        defaultMenu.add(new JMenuItem((Action)((Object)new CalendarPlugin.CalendarViewAction(0L, true))));
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)8, (Collection)collection);
        defaultMenu.addSeparator();
        DefaultMenu defaultMenu3 = new DefaultMenu(){

            protected void updateLocalization() {
                this.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")));
                this.setToolTipText(I18N.tr("Further actions in the calendar addon."));
            }
        };
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)10, (Collection)collection);
        if (CalendarPlugin.isUserAllowedTo(CalendarPermission.ENTRIES_IMPORT)) {
            defaultMenu3.add(new JMenuItem((Action)((Object)new CalendarPlugin.SyncAction())));
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)11, (Collection)collection);
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu3, (int)12, (Collection)collection);
        if (defaultMenu3.getItemCount() > 0) {
            defaultMenu.add((JMenuItem)defaultMenu3);
        }
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)9, (Collection)collection);
        CalendarFrameMenuExtension.loadMenu((JMenu)defaultMenu, (int)13, (Collection)collection);
        return defaultMenu;
    }
}

