/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarSourceDialogTab;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractDialog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.DefaultWebLinkField;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.HttpUtils;
import com.openindex.openestate.tool.utils.SwingUtils;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class CalendarSourceDialog
extends AbstractDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarSourceDialog.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarSourceDialog.class);
    private long currentGroupId = 0L;
    private boolean mayEditCalendar = false;
    private boolean submitted = false;
    private JTabbedPane tabPanel;
    private SourceTab sourceTab;
    private PermissionsTab permissionsTab;
    private SubmitAction submitAction;

    private CalendarSourceDialog(Frame frame) {
        super(frame);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private CalendarSourceDialog(Dialog dialog) {
        super(dialog);
        this.updateLocalization();
        this.pack();
        this.setLocationRelativeTo(dialog);
    }

    protected void buildFooterComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = new SubmitAction();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton(new Action[]{this.submitAction});
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton(new Action[]{new CancelAction()});
    }

    protected JComponent buildMainComponent() {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.tabPanel = new JTabbedPane();
        this.sourceTab = (SourceTab)ImmoToolUtils.addTab((AbstractTab)new SourceTab(), (JTabbedPane)this.tabPanel);
        this.permissionsTab = null;
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionsTab = (PermissionsTab)ImmoToolUtils.addTab((AbstractTab)new PermissionsTab(), (JTabbedPane)this.tabPanel);
        }
        return this.tabPanel;
    }

    private void doSourceSelectFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n != 0) {
            return;
        }
        this.sourceTab.setFile(jFileChooser.getSelectedFile());
    }

    private void doSourceTestUrl() {
        ImmoToolUtils.executeTask((ImmoToolTask)new SourceTestUrlTask());
    }

    private void doSubmit() {
        boolean bl = false;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            CalendarSourceDialogTab calendarSourceDialogTab;
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof CalendarSourceDialogTab) || (calendarSourceDialogTab = (CalendarSourceDialogTab)((Object)component)).hasValidInput()) continue;
            bl = true;
        }
        if (bl) {
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)((Object)this));
        } else {
            this.submitted = true;
            this.setVisible(false);
        }
    }

    protected String getDialogTitle() {
        if (this.currentGroupId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("edit calendar"));
        }
        return StringUtils.capitalize((String)I18N.tr("add calendar"));
    }

    protected Icon getHeaderIcon() {
        return CalendarPlugin.getResourceIcon("vcalendar.png", 32);
    }

    protected String getHeaderTitle() {
        if (this.currentGroupId > 0L) {
            return StringUtils.capitalize((String)I18N.tr("calendar")) + " #" + this.currentGroupId;
        }
        return StringUtils.capitalize((String)I18N.tr("add calendar"));
    }

    private void load(DbCalendarGroup dbCalendarGroup) {
        this.currentGroupId = dbCalendarGroup != null ? dbCalendarGroup.id : 0L;
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof CalendarSourceDialogTab)) continue;
            CalendarSourceDialogTab calendarSourceDialogTab = (CalendarSourceDialogTab)((Object)component);
            this.tabPanel.setEnabledAt(i, false);
            try {
                calendarSourceDialogTab.load(dbCalendarGroup);
                this.tabPanel.setEnabledAt(i, true);
                continue;
            }
            catch (Exception exception) {
                LOGGER.error("Can't load group into tab '" + calendarSourceDialogTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPermissions(Connection connection, DbExtension dbExtension, DbCalendarGroup dbCalendarGroup, DbUser dbUser) throws SQLException {
        this.mayEditCalendar = CalendarPlugin.isUserAllowedTo(CalendarPermission.GROUPS_EDIT);
        if (dbCalendarGroup.permission != null) {
            this.mayEditCalendar = this.mayEditCalendar && dbCalendarGroup.permission.canWrite(dbUser, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
        }
        try {
            if (this.permissionsTab != null) {
                this.permissionsTab.loadPermissions(connection, dbExtension, dbCalendarGroup, dbUser);
            }
        }
        finally {
            this.submitAction.setEnabled(this.mayEditCalendar);
        }
    }

    private void save(DbCalendarGroup dbCalendarGroup) {
        if (dbCalendarGroup == null) {
            throw new IllegalArgumentException("No calendar group provided!");
        }
        for (int i = 0; i < this.tabPanel.getTabCount(); ++i) {
            Component component = this.tabPanel.getComponentAt(i);
            if (!(component instanceof CalendarSourceDialogTab)) continue;
            CalendarSourceDialogTab calendarSourceDialogTab = (CalendarSourceDialogTab)((Object)component);
            calendarSourceDialogTab.save(dbCalendarGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbCalendarGroup showDialog(ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbCalendarGroup dbCalendarGroup;
        CalendarSourceDialog calendarSourceDialog;
        block7: {
            DbCalendarGroup dbCalendarGroup2;
            calendarSourceDialog = null;
            try {
                calendarSourceDialog = window instanceof Dialog ? new CalendarSourceDialog((Dialog)window) : (window instanceof Frame ? new CalendarSourceDialog((Frame)window) : new CalendarSourceDialog((Frame)null));
                dbCalendarGroup = new DbCalendarGroup();
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    calendarSourceDialog.load(dbCalendarGroup);
                    calendarSourceDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbCalendarGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                calendarSourceDialog.setVisible(true);
                if (calendarSourceDialog.submitted) break block7;
                dbCalendarGroup2 = null;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(calendarSourceDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
            return dbCalendarGroup2;
        }
        calendarSourceDialog.save(dbCalendarGroup);
        DbCalendarGroup dbCalendarGroup3 = dbCalendarGroup;
        SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
        return dbCalendarGroup3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbCalendarGroup showDialog(long l, ImmoToolProject immoToolProject, Window window) throws SQLException {
        DbCalendarGroup dbCalendarGroup;
        CalendarSourceDialog calendarSourceDialog;
        block9: {
            DbCalendarGroup dbCalendarGroup2;
            if (l < 1L) {
                return CalendarSourceDialog.showDialog(immoToolProject, window);
            }
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            calendarSourceDialog = null;
            try {
                calendarSourceDialog = window instanceof Dialog ? new CalendarSourceDialog((Dialog)window) : (window instanceof Frame ? new CalendarSourceDialog((Frame)window) : new CalendarSourceDialog((Frame)null));
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    dbCalendarGroup = dbCalendarHandler.getGroup(connection, l);
                    if (dbCalendarGroup == null) {
                        throw new SQLException("Can't find calendar #" + l + "!");
                    }
                    calendarSourceDialog.load(dbCalendarGroup);
                    calendarSourceDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbCalendarGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                calendarSourceDialog.setVisible(true);
                if (calendarSourceDialog.submitted) break block9;
                dbCalendarGroup2 = null;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(calendarSourceDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
            return dbCalendarGroup2;
        }
        calendarSourceDialog.save(dbCalendarGroup);
        DbCalendarGroup dbCalendarGroup3 = dbCalendarGroup;
        SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
        return dbCalendarGroup3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showDialog(DbCalendarGroup dbCalendarGroup, ImmoToolProject immoToolProject, Window window) throws SQLException {
        CalendarSourceDialog calendarSourceDialog;
        block8: {
            boolean bl;
            if (dbCalendarGroup == null) {
                throw new IllegalArgumentException("No calendar source provided!");
            }
            calendarSourceDialog = null;
            try {
                calendarSourceDialog = window instanceof Dialog ? new CalendarSourceDialog((Dialog)window) : (window instanceof Frame ? new CalendarSourceDialog((Frame)window) : new CalendarSourceDialog((Frame)null));
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    calendarSourceDialog.load(dbCalendarGroup);
                    calendarSourceDialog.loadPermissions(connection, immoToolProject.getDbExtension(), dbCalendarGroup, immoToolProject.getUser());
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                calendarSourceDialog.setVisible(true);
                if (calendarSourceDialog.submitted) break block8;
                bl = false;
            }
            catch (Throwable throwable) {
                SwingUtils.disposeRecursively(calendarSourceDialog);
                throw throwable;
            }
            SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
            return bl;
        }
        calendarSourceDialog.save(dbCalendarGroup);
        boolean bl = true;
        SwingUtils.disposeRecursively((Component)((Object)calendarSourceDialog));
        return bl;
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class SubmitAction
    extends AbstractI18nAction {
        private SubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarSourceDialog.this.doSubmit();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Close this window and save modifications."));
        }
    }

    private class SourceTestUrlTask
    extends ImmoToolTask<Calendar, Void> {
        private StatusLine status = null;

        private SourceTestUrlTask() {
        }

        /*
         * Loose catch block
         */
        protected Calendar doInBackground() throws Exception {
            Object object;
            String string;
            HttpClientBuilder httpClientBuilder = HttpUtils.builder();
            DbCalendarGroup.AuthMethod authMethod = (DbCalendarGroup.AuthMethod)((Object)CalendarSourceDialog.this.sourceTab.authMethodField.getSelectedItem());
            if (DbCalendarGroup.AuthMethod.HTTP_BASIC.equals((Object)authMethod)) {
                string = CalendarSourceDialog.this.sourceTab.authUserField.getText();
                object = String.valueOf(CalendarSourceDialog.this.sourceTab.authPassField.getPassword());
                httpClientBuilder.setDefaultCredentialsProvider(HttpUtils.createAuthentication((String)string, (String)object));
            }
            string = null;
            try {
                object = httpClientBuilder.build();
                Throwable throwable = null;
                try {
                    URI uRI = ImmoToolUtils.toIdnUrl((URI)CalendarSourceDialog.this.sourceTab.urlField.getUrl());
                    CloseableHttpResponse closeableHttpResponse = object.execute((HttpUriRequest)new HttpGet(uRI));
                    this.status = closeableHttpResponse.getStatusLine();
                    string = closeableHttpResponse.getEntity();
                    Calendar calendar = new CalendarBuilder().build(string.getContent());
                    return calendar;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            object.close();
                        }
                    }
                }
                {
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)string);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            LOGGER.warn("The connection test failed!");
            if (this.status != null) {
                LOGGER.warn("> code   : " + this.status.getStatusCode());
                LOGGER.warn("> reason : " + this.status.getReasonPhrase());
            }
            int n = this.status != null ? this.status.getStatusCode() : -1;
            ImmoToolUtils.showMessageErrorDialog((String)(I18N.tr("The connection test failed!") + " (" + n + ")"), (Throwable)throwable, (Window)((Object)CalendarSourceDialog.this));
        }

        protected void succeeded(Calendar calendar) {
            super.succeeded((Object)calendar);
            ImmoToolUtils.showMessageInfoDialog((String)I18N.tr("The connection test was successful!"), (Component)((Object)CalendarSourceDialog.this));
        }
    }

    private class SourceTestUrlAction
    extends AbstractI18nAction {
        private SourceTestUrlAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarSourceDialog.this.doSourceTestUrl();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("test")));
            this.setShortDescription(I18N.tr("Validate the entered iCal URL."));
        }
    }

    private class SourceSelectFileAction
    extends AbstractI18nAction {
        private SourceSelectFileAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarSourceDialog.this.doSourceSelectFile();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("select")));
            this.setShortDescription(I18N.tr("Select an iCal file from your harddisk."));
        }
    }

    private class CancelAction
    extends AbstractI18nAction {
        private CancelAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarSourceDialog.this.doClose();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close this window without saving modifications."));
        }
    }

    private static final class PermissionsTab
    extends CalendarSourceDialogTab {
        private ImmoToolPermissionPanel form;

        private PermissionsTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel(true);
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        @Override
        public void load(DbCalendarGroup dbCalendarGroup) {
        }

        public void loadPermissions(Connection connection, DbExtension dbExtension, DbCalendarGroup dbCalendarGroup, DbUser dbUser) throws SQLException {
            if (dbCalendarGroup != null && dbCalendarGroup.id > 0L) {
                this.form.setPermission(dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId, dbCalendarGroup.permission);
            } else {
                this.form.setPermission(dbUser.id, 0L, null);
            }
            this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
        }

        @Override
        public void save(DbCalendarGroup dbCalendarGroup) {
            DbGroup dbGroup;
            dbCalendarGroup.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbCalendarGroup.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbCalendarGroup.ownerGroupId = dbGroup.id;
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
        }
    }

    private final class SourceTab
    extends CalendarSourceDialogTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator nameLabel;
        private JTextField nameField;
        private JXTitledSeparator textLabel;
        private DefaultTextArea textField;
        private JXTitledSeparator typeLabel;
        private JFormattedTextField fileField;
        private DefaultWebLinkField urlField;
        private ButtonGroup typeGroup;
        private JRadioButton typeInternalField;
        private JRadioButton typeExternalFileField;
        private JRadioButton typeExternalUrlField;
        private JLabel authMethodLabel;
        private JComboBox<DbCalendarGroup.AuthMethod> authMethodField;
        private JLabel authUserLabel;
        private JTextField authUserField;
        private JLabel authPassLabel;
        private JPasswordField authPassField;
        private SourceSelectFileAction sourceFileAction;
        private SourceTestUrlAction sourceUrlAction;

        private SourceTab() {
            this.build();
            this.updateLocalization();
            this.updateTypeSelection();
        }

        private void build() {
            this.typeGroup = new ButtonGroup();
            this.typeLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.nameLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.nameField = new JTextField();
            this.textLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.textField = new DefaultTextArea();
            JScrollPane jScrollPane = this.textField.createScrollPane();
            jScrollPane.setPreferredSize(new Dimension(80, 80));
            this.typeInternalField = new JRadioButton();
            this.typeInternalField.setSelected(true);
            this.typeInternalField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTab.this.updateTypeSelection();
                    SourceTab.this.validationHandler.validate();
                }
            });
            this.typeGroup.add(this.typeInternalField);
            this.fileField = new JFormattedTextField();
            this.sourceFileAction = new SourceSelectFileAction();
            this.typeExternalFileField = new JRadioButton();
            this.typeExternalFileField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTab.this.updateTypeSelection();
                    SourceTab.this.validationHandler.validate();
                }
            });
            this.typeGroup.add(this.typeExternalFileField);
            this.urlField = new DefaultWebLinkField(false);
            this.sourceUrlAction = new SourceTestUrlAction();
            this.typeExternalUrlField = new JRadioButton();
            this.typeExternalUrlField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTab.this.updateTypeSelection();
                    SourceTab.this.validationHandler.validate();
                }
            });
            this.typeGroup.add(this.typeExternalUrlField);
            this.authUserLabel = new JLabel("", 4);
            this.authUserField = new JTextField();
            this.authPassLabel = new JLabel("", 4);
            this.authPassField = new JPasswordField();
            this.authMethodLabel = new JLabel("", 4);
            this.authMethodField = new JComboBox();
            this.authMethodField.addItem(DbCalendarGroup.AuthMethod.ANONYMOUS);
            this.authMethodField.addItem(DbCalendarGroup.AuthMethod.HTTP_BASIC);
            this.authMethodField.setRenderer((ListCellRenderer<DbCalendarGroup.AuthMethod>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            this.authMethodField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SourceTab.this.updateTypeSelection();
                    SourceTab.this.validationHandler.validate();
                }
            });
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule((JComponent)this.nameField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule((JComponent)this.authUserField, ValidationHandler.NOT_BLANK);
            this.validationHandler.putRule((JComponent)this.fileField, new ValidationRule(){

                public boolean isValid(Object object) {
                    return object != null && new File(object.toString()).isFile();
                }
            });
            this.validationHandler.putRule((JComponent)this.urlField, ValidationHandler.URL);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"pref, 3dlu, 100dlu:grow, 3dlu, pref");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.nameLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.nameField).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.textLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.addRaw((Component)jScrollPane).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.typeLabel).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.typeInternalField).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.typeExternalFileField).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.fileField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)new JButton((Action)((Object)this.sourceFileAction))).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.typeExternalUrlField).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.urlField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)new JButton((Action)((Object)this.sourceUrlAction))).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
            defaultFormBuilder.add((Component)this.authMethodLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.authMethodField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.authUserLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.authUserField).xyw(3, defaultFormBuilder.row(), 3);
            defaultFormBuilder.add((Component)this.authPassLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.authPassField).xyw(3, defaultFormBuilder.row(), 3);
            JScrollPane jScrollPane2 = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane2.setBorder(Paddings.EMPTY);
            jScrollPane2.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane2.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane2, "Center");
        }

        public URI getURL() {
            return this.urlField.getUrl();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("calendar"));
        }

        @Override
        public boolean hasValidInput() {
            this.validationHandler.validate();
            return this.validationHandler.isValid();
        }

        @Override
        public void load(DbCalendarGroup dbCalendarGroup) {
            this.nameField.setText(dbCalendarGroup != null ? dbCalendarGroup.name : "");
            this.textField.setText(dbCalendarGroup != null ? dbCalendarGroup.notes : "");
            this.fileField.setText("");
            this.urlField.setUrl(null);
            this.typeGroup.getSelection().setSelected(false);
            if (dbCalendarGroup != null && DbCalendarGroup.Type.LOCAL.equals((Object)dbCalendarGroup.type)) {
                this.typeInternalField.setSelected(true);
            } else if (dbCalendarGroup != null && DbCalendarGroup.Type.FILE.equals((Object)dbCalendarGroup.type)) {
                try {
                    this.typeExternalFileField.setSelected(true);
                    this.fileField.setText(dbCalendarGroup.url != null ? new File(dbCalendarGroup.url).getAbsolutePath() : "");
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load file from url!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.typeExternalFileField.setSelected(false);
                    this.typeInternalField.setSelected(true);
                }
            } else if (dbCalendarGroup != null && DbCalendarGroup.Type.URL.equals((Object)dbCalendarGroup.type)) {
                this.typeExternalUrlField.setSelected(true);
                this.urlField.setUrl(dbCalendarGroup.url);
            }
            this.authMethodField.setSelectedItem((Object)DbCalendarGroup.AuthMethod.ANONYMOUS);
            this.authPassField.setText("");
            this.authUserField.setText("");
            if (dbCalendarGroup != null && DbCalendarGroup.Type.URL.equals((Object)dbCalendarGroup.type)) {
                this.authMethodField.setSelectedItem((Object)dbCalendarGroup.authMethod);
                if (!DbCalendarGroup.AuthMethod.ANONYMOUS.equals((Object)dbCalendarGroup.authMethod)) {
                    this.authPassField.setText(String.valueOf(dbCalendarGroup.authPass));
                    this.authUserField.setText(dbCalendarGroup.authUser);
                }
            }
            this.updateTypeSelection();
            this.validationHandler.init();
            if (dbCalendarGroup != null) {
                this.validationHandler.validate();
            }
        }

        @Override
        public void save(DbCalendarGroup dbCalendarGroup) {
            dbCalendarGroup.name = ImmoToolUtils.stripTags((String)this.nameField.getText()).trim();
            dbCalendarGroup.notes = ImmoToolUtils.stripTags((String)this.textField.getText()).trim();
            if (this.typeInternalField.isSelected()) {
                dbCalendarGroup.url = null;
                dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
            } else if (this.typeExternalFileField.isSelected()) {
                try {
                    dbCalendarGroup.url = new File(this.fileField.getText()).toURI();
                    dbCalendarGroup.type = DbCalendarGroup.Type.FILE;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load file-URL!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
                    dbCalendarGroup.url = null;
                }
            } else if (this.typeExternalUrlField.isSelected()) {
                try {
                    dbCalendarGroup.url = this.urlField.getUrl();
                    dbCalendarGroup.type = DbCalendarGroup.Type.URL;
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load iCal-URL!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
                    dbCalendarGroup.url = null;
                }
            }
            dbCalendarGroup.authMethod = this.authMethodField.isEnabled() ? (DbCalendarGroup.AuthMethod)((Object)this.authMethodField.getSelectedItem()) : DbCalendarGroup.AuthMethod.ANONYMOUS;
            dbCalendarGroup.authPass = this.authPassField.isEnabled() ? this.authPassField.getPassword() : null;
            dbCalendarGroup.authUser = this.authUserField.isEnabled() ? this.authUserField.getText() : null;
        }

        public void setFile(File file) {
            this.fileField.setText(file != null ? file.getAbsolutePath() : "");
            this.validationHandler.validate((JComponent)this.fileField);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.nameLabel.setTitle(StringUtils.capitalize((String)I18N.tr("title")));
            this.nameField.setToolTipText(I18N.tr("Select a descriptive name for the calendar."));
            this.textLabel.setTitle(StringUtils.capitalize((String)I18N.tr("description")));
            this.textField.setToolTipText(I18N.tr("Enter a short description about the calendar."));
            this.fileField.setToolTipText(I18N.tr("Select a file in iCal format."));
            this.urlField.setToolTipText(I18N.tr("Enter an URL that points to an external iCal calendar."));
            this.typeLabel.setTitle(StringUtils.capitalize((String)I18N.tr("source")));
            this.typeInternalField.setText(I18N.tr("internal calendar"));
            this.typeInternalField.setToolTipText(I18N.tr("The calendar is stored internally into the database."));
            this.typeExternalFileField.setText(I18N.tr("from external iCal file") + ":");
            this.typeExternalFileField.setToolTipText(I18N.tr("The calendar is synchronized with an external iCal file."));
            this.typeExternalUrlField.setText(I18N.tr("from external iCal URL") + ":");
            this.typeExternalUrlField.setToolTipText(I18N.tr("The calendar is synchronized with an external iCal-URL."));
            this.authMethodLabel.setText(StringUtils.capitalize((String)I18N.tr("authentication")) + ":");
            this.authMethodField.setToolTipText(I18N.tr("Please select, if the calendar URL is protected with a password."));
            this.authUserLabel.setText(StringUtils.capitalize((String)I18N.tr("user")) + ":");
            this.authUserField.setToolTipText(I18N.tr("Enter the username, that is required to access the iCal URL."));
            this.authPassLabel.setText(StringUtils.capitalize((String)I18N.tr("password")) + ":");
            this.authPassField.setToolTipText(I18N.tr("Enter the password, that is required to access the iCal URL."));
        }

        private void updateTypeSelection() {
            this.fileField.setEnabled(this.typeExternalFileField.isSelected());
            this.sourceFileAction.setEnabled(this.typeExternalFileField.isSelected());
            this.urlField.setEnabled(this.typeExternalUrlField.isSelected());
            this.sourceUrlAction.setEnabled(this.typeExternalUrlField.isSelected());
            this.authMethodField.setEnabled(this.typeExternalUrlField.isSelected());
            this.authPassField.setEnabled(this.typeExternalUrlField.isSelected() && this.authMethodField.getSelectedIndex() > 0);
            this.authUserField.setEnabled(this.typeExternalUrlField.isSelected() && this.authMethodField.getSelectedIndex() > 0);
        }
    }
}

