/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarEventEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarTodoEntry;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Uid;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarUpgradeExtension.class);
    public static final String UPGRADE_ENTRIES = "OpenEstate-Tool-Calendar.entries";
    public static final String UPGRADE_GROUPS = "OpenEstate-Tool-Calendar.groups";

    private static DbCalendarEntry createEntry(Component component) {
        DbCalendarEntry dbCalendarEntry;
        Uid uid = (Uid)component.getProperty("UID");
        if (uid == null) {
            LOGGER.warn("Calendar component without uid!");
            return null;
        }
        if (component instanceof VEvent) {
            dbCalendarEntry = new DbCalendarEventEntry();
        } else if (component instanceof VToDo) {
            dbCalendarEntry = new DbCalendarTodoEntry();
        } else {
            if (component instanceof VJournal) {
                return null;
            }
            LOGGER.warn("Calendar component is not supported: " + component.getName());
            return null;
        }
        dbCalendarEntry.setComponent(component);
        dbCalendarEntry.updateFieldsFromComponent();
        return dbCalendarEntry;
    }

    private static DbCalendarGroup createGroup(Properties properties) throws URISyntaxException {
        DbCalendarGroup dbCalendarGroup = new DbCalendarGroup();
        dbCalendarGroup.id = ImmoToolUtils.getPropertyAsLong((String)"calendarId", (Long)0L, (Properties)properties);
        dbCalendarGroup.name = properties.getProperty("name", "");
        dbCalendarGroup.notes = properties.getProperty("description", "");
        int n = ImmoToolUtils.getPropertyAsInteger((String)"type", (Integer)0, (Properties)properties);
        String string = properties.getProperty("location", "");
        if (n == 1) {
            dbCalendarGroup.type = DbCalendarGroup.Type.FILE;
            dbCalendarGroup.url = new File(string).toURI();
        } else if (n == 2) {
            dbCalendarGroup.type = DbCalendarGroup.Type.URL;
            dbCalendarGroup.url = new URI(string);
        } else {
            dbCalendarGroup.type = DbCalendarGroup.Type.LOCAL;
            dbCalendarGroup.url = null;
        }
        int n2 = ImmoToolUtils.getPropertyAsInteger((String)"auth.method", (Integer)0, (Properties)properties);
        if (n2 == 1) {
            dbCalendarGroup.authMethod = DbCalendarGroup.AuthMethod.HTTP_BASIC;
            dbCalendarGroup.authUser = properties.getProperty("auth.user", "");
            dbCalendarGroup.authPass = properties.getProperty("auth.pass", "").toCharArray();
        } else {
            dbCalendarGroup.authMethod = DbCalendarGroup.AuthMethod.ANONYMOUS;
            dbCalendarGroup.authUser = null;
            dbCalendarGroup.authPass = null;
        }
        return dbCalendarGroup;
    }

    public String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Calendar"};
    }

    public void upgrade(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, Properties properties, ImmoToolTask.Callback callback) throws SQLException, IOException {
        Serializable serializable;
        Object throwable;
        Object object2;
        File[] fileArray;
        Serializable serializable2;
        this.setMessage("Upgrade calendars...", callback);
        DbCalendarExtension dbCalendarExtension = CalendarPluginUtils.getDbCalendarExtension(abstractDbDriver);
        DbCalendarHandler dbCalendarHandler = dbCalendarExtension.getCalendarHandler();
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        SuffixFileFilter suffixFileFilter2 = new SuffixFileFilter(".ics", IOCase.INSENSITIVE);
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        File file2 = new File(file.getAbsolutePath() + File.separator + "calendars");
        if (file2.isDirectory()) {
            serializable2 = new TreeMap();
            fileArray = file2.listFiles((FileFilter)suffixFileFilter);
            if (ArrayUtils.isNotEmpty((Object[])fileArray)) {
                for (File object3 : fileArray) {
                    try {
                        serializable2.put(Long.valueOf(object3.getName().split("\\.")[0]), object3);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read calendar-id!");
                        LOGGER.warn("> from " + object3.getAbsolutePath());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        this.setMessage("WARNING: Can't read calendar-id!", callback);
                        this.setMessage("> " + exception.getLocalizedMessage(), callback);
                    }
                }
            }
            for (Map.Entry entry : serializable2.entrySet()) {
                Long l = (Long)entry.getKey();
                this.setMessage("> Import calendar #" + l, callback);
                File entry2 = (File)entry.getValue();
                try {
                    FileInputStream fileInputStream = new FileInputStream(entry2);
                    object2 = null;
                    try {
                        throwable = new Properties();
                        ((Properties)throwable).loadFromXML(fileInputStream);
                        serializable = CalendarUpgradeExtension.createGroup((Properties)throwable);
                        ((DbCalendarGroup)serializable).id = 0L;
                        dbCalendarHandler.saveGroup(connection, (DbCalendarGroup)serializable);
                        hashMap.put(l, ((DbCalendarGroup)serializable).id);
                        dbUpgradeHandler.save(connection, UPGRADE_GROUPS, String.valueOf(l), ((DbCalendarGroup)serializable).id);
                    }
                    catch (Throwable throwable2) {
                        object2 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileInputStream == null) continue;
                        if (object2 != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Throwable exception) {
                                ((Throwable)object2).addSuppressed(exception);
                            }
                            continue;
                        }
                        fileInputStream.close();
                    }
                }
                catch (Exception l2) {
                    LOGGER.warn("Can't import calendar!");
                    LOGGER.warn("> from " + entry2.getAbsolutePath());
                    LOGGER.warn("> " + l2.getLocalizedMessage(), (Throwable)l2);
                    this.setMessage("WARNING: Can't import calendar!", callback);
                    this.setMessage("> " + l2.getLocalizedMessage(), callback);
                }
            }
        }
        if (((File)(serializable2 = new File(file.getAbsolutePath() + File.separator + "entries"))).isDirectory()) {
            fileArray = new CalendarBuilder(CalendarPluginUtils.getTimeZoneRegistry());
            TreeMap treeMap = new TreeMap();
            Object[] objectArray = ((File)serializable2).listFiles((FileFilter)suffixFileFilter2);
            if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                for (Object object2 : objectArray) {
                    try {
                        treeMap.put(Long.valueOf(((File)object2).getName().split("\\.")[0]), object2);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read calendar-id!");
                        LOGGER.warn("> from " + ((File)object2).getAbsolutePath());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        this.setMessage("WARNING: Can't read calendar-id!", callback);
                        this.setMessage("> " + exception.getLocalizedMessage(), callback);
                    }
                }
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                Long l = (Long)entry.getKey();
                if (!hashMap.containsKey(l)) continue;
                this.setMessage("> Import entries of calendar #" + l, callback);
                object2 = (File)entry.getValue();
                try {
                    throwable = new InputStreamReader((InputStream)new FileInputStream((File)object2), "UTF-8");
                    serializable = null;
                    try {
                        Calendar throwable3 = fileArray.build((Reader)throwable);
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (Object e : throwable3.getComponents()) {
                            Uid uid;
                            Component component = (Component)e;
                            DbCalendarEntry dbCalendarEntry = CalendarUpgradeExtension.createEntry(component);
                            if (dbCalendarEntry == null) continue;
                            if (dbCalendarEntry.uid == null) {
                                LOGGER.warn("UID is missing!");
                                LOGGER.warn("> calendar #" + l);
                                uid = CalendarPluginUtils.getUidGenerator().generateUid();
                                while (arrayList.contains(uid.getValue())) {
                                    uid = CalendarPluginUtils.getUidGenerator().generateUid();
                                }
                                dbCalendarEntry.uid = uid.getValue();
                                dbCalendarEntry.putProperty((Property)uid);
                            } else if (arrayList.contains(dbCalendarEntry.uid)) {
                                LOGGER.warn("UID already exists!");
                                LOGGER.warn("> calendar #" + l);
                                LOGGER.warn("> uid " + dbCalendarEntry.uid);
                                uid = CalendarPluginUtils.getUidGenerator().generateUid();
                                while (arrayList.contains(uid.getValue())) {
                                    uid = CalendarPluginUtils.getUidGenerator().generateUid();
                                }
                                dbCalendarEntry.uid = uid.getValue();
                                dbCalendarEntry.putProperty((Property)uid);
                            }
                            arrayList.add(dbCalendarEntry.uid);
                            dbCalendarEntry.id = 0L;
                            dbCalendarEntry.groupId = (Long)hashMap.get(l);
                            dbCalendarHandler.saveEntry(connection, dbCalendarEntry);
                            dbUpgradeHandler.save(connection, UPGRADE_ENTRIES, l + "/" + dbCalendarEntry.uid, dbCalendarEntry.id);
                        }
                    }
                    catch (Throwable throwable4) {
                        serializable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (throwable == null) continue;
                        if (serializable != null) {
                            try {
                                ((Reader)throwable).close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)serializable).addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ((Reader)throwable).close();
                    }
                }
                catch (Throwable throwable6) {
                    LOGGER.warn("Can't import calendar-entries!");
                    LOGGER.warn("> from " + ((File)object2).getAbsolutePath());
                    LOGGER.warn("> " + throwable6.getLocalizedMessage(), throwable6);
                    this.setMessage("WARNING: Can't import calendar-entries!", callback);
                    this.setMessage("> " + throwable6.getLocalizedMessage(), callback);
                }
            }
        }
        try {
            this.setMessage("> Save calendar-settings...", callback);
            CalendarPlugin.setWorktimeBegin(CalendarPluginUtils.parseTime(properties.getProperty("Calendar.WorkTime.Begin"), 0, 0));
            CalendarPlugin.setWorktimeEnd(CalendarPluginUtils.parseTime(properties.getProperty("Calendar.WorkTime.End"), 23, 59));
            CalendarPlugin.saveSettings(connection, dbUser, dbExtension, dbCalendarExtension);
        }
        catch (Throwable throwable7) {
            LOGGER.warn("Can't save calendar-settings!");
            LOGGER.warn("> " + throwable7.getLocalizedMessage(), throwable7);
            this.setMessage("WARNING: Can't save calendar-settings!", callback);
            this.setMessage("> " + throwable7.getLocalizedMessage(), callback);
        }
    }
}

