/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db;

import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarPluginUtils;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.util.Calendar;
import javax.swing.ImageIcon;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Due;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbCalendarEventEntry
extends DbCalendarEntry<VEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbCalendarEventEntry.class);
    private static final I18n I18N = I18nFactory.getI18n(DbCalendarEventEntry.class);
    public static final Status CANCELLED = Status.VEVENT_CANCELLED;
    public static final Status CONFIRMED = Status.VEVENT_CONFIRMED;
    public static final Status TENTATIVE = Status.VEVENT_TENTATIVE;
    public VEvent event = new VEvent();

    @Override
    public Color getColor() {
        if (CONFIRMED.equals((Object)this.status)) {
            return new Color(162, 249, 162);
        }
        if (TENTATIVE.equals((Object)this.status)) {
            return new Color(249, 162, 162);
        }
        return new Color(240, 240, 240);
    }

    @Override
    public final VEvent getComponent() {
        return this.event;
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(CalendarPlugin.getResourceImage("event.png", 16));
    }

    @Override
    public Color getStatusColor() {
        return DbCalendarEventEntry.getStatusColor(this.status);
    }

    public static Color getStatusColor(Status status) {
        if (Status.VEVENT_CANCELLED.equals((Object)status)) {
            return Color.GRAY;
        }
        if (Status.VEVENT_CONFIRMED.equals((Object)status)) {
            return Color.BLACK;
        }
        if (Status.VEVENT_TENTATIVE.equals((Object)status)) {
            return Color.RED;
        }
        return null;
    }

    public static Status[] getStatusOptions() {
        return new Status[]{CANCELLED, CONFIRMED, TENTATIVE};
    }

    @Override
    public final DbCalendarEntry.Type getType() {
        return DbCalendarEntry.Type.VEVENT;
    }

    @Override
    public boolean hasBeginDate() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && !DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasBeginTime() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        return dtStart != null && dtStart.getDate() != null && DateTime.class.isInstance(dtStart.getDate());
    }

    @Override
    public boolean hasEndDate() {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        return dtEnd != null && dtEnd.getDate() != null && !DateTime.class.isInstance(dtEnd.getDate());
    }

    @Override
    public boolean hasEndTime() {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        return dtEnd != null && dtEnd.getDate() != null && DateTime.class.isInstance(dtEnd.getDate());
    }

    @Override
    public void setBeginDate(java.util.Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            this.putProperty((Property)new DtStart(new Date(date)));
            this.begin = (java.util.Date)date.clone();
        }
    }

    @Override
    public void setBeginTime(java.util.Date date) {
        if (date == null) {
            this.removeProperty("DTSTART");
        } else {
            TimeZone timeZone = CalendarPluginUtils.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtStart((Date)dateTime));
            this.begin = calendar.getTime();
        }
    }

    @Override
    public final void setComponent(Component component) {
        this.event = component instanceof VEvent ? (VEvent)component : new VEvent();
    }

    @Override
    public void setEmptyComponent() {
        this.setComponent((Component)new VEvent());
    }

    @Override
    public void setEndDate(java.util.Date date) {
        this.removeProperty("DUE");
        this.removeProperty("DURATION");
        if (date == null) {
            this.removeProperty("DTEND");
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(6, 1);
            calendar.add(14, -1);
            this.setEndTime(calendar.getTime());
        }
    }

    @Override
    public void setEndTime(java.util.Date date) {
        this.removeProperty("DUE");
        this.removeProperty("DURATION");
        if (date == null) {
            this.removeProperty("DTEND");
        } else {
            TimeZone timeZone = CalendarPluginUtils.getTimeZone();
            Calendar calendar = Calendar.getInstance((java.util.TimeZone)timeZone);
            calendar.setTimeInMillis(date.getTime());
            DateTime dateTime = new DateTime(calendar.getTime());
            dateTime.setTimeZone(timeZone);
            this.putProperty((Property)new DtEnd((Date)dateTime));
            this.end = calendar.getTime();
        }
    }

    @Override
    public synchronized void updateTimeFieldsFromComponent() {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        this.begin = dtStart != null ? dtStart.getDate() : null;
        this.end = null;
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd != null) {
            this.end = dtEnd.getDate();
        } else {
            Duration duration;
            Due due = (Due)this.getProperty("DUE");
            if (due != null) {
                this.end = due.getDate();
            } else if (this.begin != null && (duration = (Duration)this.getProperty("DURATION")) != null) {
                this.end = duration.getDuration().getTime(this.begin);
            }
        }
        if (this.end != null && this.begin != null && this.end.before(this.begin)) {
            LOGGER.warn("Invalid calendar entry #" + this.id + "!");
            LOGGER.warn("> end time (" + this.end + ") is before start time (" + this.begin + ")");
            LOGGER.warn("> drop end time");
            this.setEndDate(null);
        }
    }
}

