/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.calendar.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntryLogHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.calendar.db.DbCalendarUpdateListener;
import com.openindex.openestate.tool.calendar.db.hsql.HSqlDbCalendarEntryLogHandler;
import com.openindex.openestate.tool.calendar.db.hsql.HSqlDbCalendarHandler;
import com.openindex.openestate.tool.calendar.extensions.DbCalendarAdapter;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCalendarExtension
extends DbCalendarAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCalendarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCalendarExtension.class);
    public static final String RESOURCE_PATH = "/com/openindex/openestate/tool/calendar/db/hsql/resources/";
    private static final DbCalendarEntryLogHandler CALENDAR_ENTRY_LOG_HANDLER = new HSqlDbCalendarEntryLogHandler();
    private static final DbCalendarHandler CALENDAR_HANDLER = new HSqlDbCalendarHandler();

    @Override
    public DbCalendarEntryLogHandler getCalendarEntryLogHandler() {
        return CALENDAR_ENTRY_LOG_HANDLER;
    }

    @Override
    public DbCalendarHandler getCalendarHandler() {
        return CALENDAR_HANDLER;
    }

    @Override
    public String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_logs", "remove_immotool_logs_changes", "save_immotool_calendar_entries_logs", "save_immotool_logs", "save_immotool_logs_changes", "remove_immotool_calendar_entries", "remove_immotool_calendar_groups", "save_immotool_calendar_entries", "save_immotool_calendar_groups"};
    }

    @Override
    public String[] getRequiredViews() {
        return new String[]{"view_immotool_calendar_entries_logs", "view_immotool_logs_changes", "view_immotool_calendar_entries", "view_immotool_calendar_groups"};
    }

    @Override
    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    @Override
    public String getUninstallQuery() throws IOException {
        return HSqlDbCalendarExtension.readHsqlQuery("uninstall.sql");
    }

    @Override
    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new CalendarUpdateHandler(string, new DbCalendarUpdateListener());
    }

    @Override
    public void install(Connection connection) throws IOException, SQLException {
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbCalendarExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbCalendarExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCalendarExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCalendarExtension.class.getClassLoader());
    }

    @Override
    public void repair(Connection connection, AbstractDbDriver abstractDbDriver) throws SQLException {
        super.repair(connection, abstractDbDriver);
        HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_calendar_groups");
        HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_calendar_groups");
    }

    private static final class CalendarUpdateHandler
    extends HSqlDbUpdateHandler {
        public CalendarUpdateHandler(String string, AbstractDbUpdateListener abstractDbUpdateListener) {
            super("OpenEstate-Tool-Calendar", DbUpdateHandlerImpl.Type.PLUGIN, CalendarPlugin.getInstance().getApiVersion(), string, HSqlDbCalendarExtension.RESOURCE_PATH, CalendarPlugin.class.getClassLoader(), abstractDbUpdateListener);
        }

        public void updateFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, long l, long l2) throws SQLException, IOException {
            super.updateFinished(connection, abstractDbDriver, dbExtension, l, l2);
            if (l < 7L) {
                HSqlUtils.updateAccessOwnerForeignKey((Connection)connection, (String)"immotool_calendar_groups");
            }
            if (l < 7L) {
                HSqlUtils.updateAccessGroupForeignKey((Connection)connection, (String)"immotool_calendar_groups");
            }
        }
    }
}

