/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.manual;

import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.extensions.ManualAdapter;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.manual.ManualPanel;
import com.openindex.openestate.tool.manual.ManualPlugin;
import com.openindex.openestate.tool.manual.OfflineManualDialog;
import java.awt.Component;
import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class OfflineManualExtension
extends ManualAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineManualExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(OfflineManualExtension.class);
    public static final String NAME = "offline";

    public String getName() {
        return NAME;
    }

    public String getTitle() {
        return "Offline-Handbuch";
    }

    public boolean showManual(String string, Window window) throws ImmoToolException {
        if (window != null) {
            OfflineManualDialog.showDialog(string, ManualPlugin.getHelpSet(), window);
            return true;
        }
        try {
            AbstractMainTab abstractMainTab = ImmoToolAppUtils.getTab(ManualPanel.class);
            if (abstractMainTab != null) {
                ManualPanel manualPanel = (ManualPanel)abstractMainTab;
                manualPanel.setCurrentId(string);
                ImmoToolAppUtils.selectTab((Component)((Object)manualPanel));
                return true;
            }
            ManualPanel manualPanel = ManualPanel.createTab(string);
            ImmoToolAppUtils.showTab((AbstractMainTab)manualPanel);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Can't show manual page!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return false;
        }
    }
}

