/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.news.db.DbNewsEntry;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.SortOrder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsEntryTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsEntryTable.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsEntryTable.class);

    public NewsEntryTable(String string) {
        super(string);
    }

    public NewsEntryTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public DbNewsEntry getEntryAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getEntry() : null;
    }

    public Long getEntryIdAt(int n) {
        DbNewsEntry dbNewsEntry = this.getEntryAt(n);
        return dbNewsEntry != null ? dbNewsEntry.id : 0L;
    }

    public String getFeedNameAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getFeedName() : null;
    }

    protected void init() {
        this.setSortable(true);
        this.setSingleSelection();
        this.setColumnControlVisible(true);
        super.init();
        this.setSortOrder(Column.DATE.getColumnId(), SortOrder.DESCENDING);
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbNewsEntry entry;
        private final String feedName;

        public Row(DbNewsEntry dbNewsEntry, String string) {
            this.entry = dbNewsEntry;
            this.feedName = string;
        }

        public DbNewsEntry getEntry() {
            return this.entry;
        }

        public String getFeedName() {
            return this.feedName;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForNews((Column)column);
            }
            return null;
        }

        public Object getValueForNews(Column column) {
            if (this.entry == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.entry.id;
                }
                case AUTHOR: {
                    return StringUtils.trimToNull((String)this.entry.author);
                }
                case FEED: {
                    return StringUtils.trimToNull((String)this.feedName);
                }
                case TITLE: {
                    return StringUtils.trimToNull((String)this.entry.title);
                }
                case DATE: {
                    return this.entry.time;
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        DATE,
        TITLE,
        AUTHOR,
        FEED;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case DATE: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(1, 3)));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case DATE: {
                    return Date.class;
                }
                case TITLE: 
                case AUTHOR: 
                case FEED: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case DATE: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("title"));
                }
                case AUTHOR: {
                    return StringUtils.capitalize((String)I18N.tr("author"));
                }
                case FEED: {
                    return StringUtils.capitalize((String)I18N.tr("source"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: {
                    return false;
                }
            }
            return true;
        }
    }
}

