/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.extensions.ProjectAdapter;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.NewsPluginUtils;
import com.openindex.openestate.tool.news.extensions.DbNewsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsProjectExtension
extends ProjectAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsProjectExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsProjectExtension.class);

    public void close(ImmoToolProject immoToolProject) throws ImmoToolException {
        super.close(immoToolProject);
        NewsPlugin.stopUpdateTimer();
        NewsPlugin.unloadSettings();
        NewsPlugin.setDbNewsExtension(null);
    }

    public void open(ImmoToolProject immoToolProject) throws ImmoToolException {
        DbNewsExtension dbNewsExtension = NewsPluginUtils.getDbNewsExtension(immoToolProject);
        if (dbNewsExtension == null) {
            throw new ImmoToolException("Can't find a usable DbNewsExtension!");
        }
        NewsPlugin.setDbNewsExtension(dbNewsExtension);
        try {
            NewsPlugin.loadSettings(immoToolProject);
        }
        catch (Exception exception) {
            throw new ImmoToolException("Can't load news settings!", (Throwable)exception);
        }
    }

    public void openFinished(ImmoToolProject immoToolProject) {
        NewsPlugin.createTimer(immoToolProject.getDbDriver());
        NewsPlugin.startUpdateTimer(30000);
    }
}

