/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.news;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.news.NewsDownloadTask;
import com.openindex.openestate.tool.news.NewsPlugin;
import com.openindex.openestate.tool.news.db.DbNewsFeed;
import com.openindex.openestate.tool.news.db.DbNewsHandler;
import com.openindex.openestate.tool.utils.StatusNotification;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class NewsUpdateTimer
extends Timer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsUpdateTimer.class);
    private static final I18n I18N = I18nFactory.getI18n(NewsUpdateTimer.class);
    private static final int DELAY = 60000;
    private final AbstractDbDriver dbDriver;
    private final DbNewsHandler newsHandler;
    private final boolean firstExecutionPassed;
    private boolean isRunning;

    public NewsUpdateTimer(AbstractDbDriver abstractDbDriver, DbNewsHandler dbNewsHandler) {
        super(60000, null);
        this.dbDriver = abstractDbDriver;
        this.newsHandler = dbNewsHandler;
        this.firstExecutionPassed = false;
        this.isRunning = false;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewsUpdateTimer.this.timingOccured();
            }
        });
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
    }

    public synchronized void timingOccured() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        NewsDownloadTask newsDownloadTask = new NewsDownloadTask(this.dbDriver, this.newsHandler){

            @Override
            protected Integer executeTask(Connection connection) throws Exception {
                long l = System.currentTimeMillis();
                int n = 0;
                for (DbNewsFeed dbNewsFeed : this.getNewsHandler().getFeeds(connection, true)) {
                    long l2;
                    long l3 = dbNewsFeed.updateInterval;
                    if (l3 < 0L || NewsUpdateTimer.this.firstExecutionPassed && l3 < 1L) continue;
                    Date date = dbNewsFeed.downloadedAt;
                    long l4 = l2 = date != null ? date.getTime() + l3 : 0L;
                    if (l2 > l) continue;
                    this.addFeed(dbNewsFeed);
                    ++n;
                }
                return n > 0 ? super.executeTask(connection) : 0;
            }

            protected void finished() {
                super.finished();
                NewsUpdateTimer.this.isRunning = false;
            }

            protected void succeeded(Integer n) {
                super.succeeded((Object)n);
                if (this.getModifiedFeeds().isEmpty() || n < 1) {
                    return;
                }
                JPanel jPanel = new JPanel(new GridLayout(0, 1));
                jPanel.setOpaque(false);
                for (DbNewsFeed dbNewsFeed : this.getModifiedFeeds()) {
                    int n2 = this.getNewEntriesCounter(dbNewsFeed);
                    if (n2 < 1) continue;
                    jPanel.add(new JLabel("<html><b>" + StringUtils.capitalize((String)I18N.tr("news feed")) + " '" + StringEscapeUtils.escapeXml11((String)StringUtils.abbreviate((String)dbNewsFeed.name, (int)40)) + "'</b></html>"));
                    jPanel.add((Component)((Object)new FeedLink(dbNewsFeed, "<html>" + I18N.trn("has {0} new message", "has {0} new messages", (long)n2, (Object)n2) + "</html>")));
                }
                StatusNotification statusNotification = new StatusNotification((JComponent)jPanel, NewsPlugin.getResourceIcon("news.png", 32));
                ImmoToolEnvironment.showStatusNotification((StatusNotification)statusNotification);
            }
        };
        ImmoToolUtils.executeTask((ImmoToolTask)newsDownloadTask);
    }

    private static class FeedLink
    extends JXHyperlink {
        private FeedLink(DbNewsFeed dbNewsFeed, String string) {
            this.setText(string);
            this.addActionListener((ActionListener)((Object)new NewsPlugin.EntryTableAction(dbNewsFeed.id, true)));
        }
    }
}

