/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarAdapter;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.addons.calendar.ContactsBirthdayCalendarEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={VirtualCalendarExtension.class}, plugins={"OpenEstate-Tool-Calendar", "OpenEstate-Tool-Contacts"})
public class ContactsBirthdayCalendarExtension
extends VirtualCalendarAdapter<ContactsBirthdayCalendarEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsBirthdayCalendarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsBirthdayCalendarExtension.class);

    public ImageIcon getIcon() {
        return new ImageIcon(ContactsPlugin.getResourceImage((String)"birthday.png", (int)16));
    }

    public List<ContactsBirthdayCalendarEntry> getEntries(Connection connection, String string, Date date, Date date2) throws SQLException, IOException {
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        int n = date != null ? DateUtils.toCalendar((Date)date).get(1) : (date2 != null ? DateUtils.toCalendar((Date)date2).get(1) : Calendar.getInstance().get(1));
        ArrayList<ContactsBirthdayCalendarEntry> arrayList = new ArrayList<ContactsBirthdayCalendarEntry>();
        DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntriesByBirthday(connection, date, date2, Boolean.valueOf(true));
        dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
        for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
            arrayList.add(new ContactsBirthdayCalendarEntry(dbContactsEntry, n, (VirtualCalendarExtension)this));
        }
        return arrayList;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Calendar"};
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("birthdays"));
    }

    public String getToolTip() {
        return I18N.tr("This calendar contains birthdates of the addressbook entries.");
    }

    public Action getViewAction(ImmoToolProject immoToolProject, ContactsBirthdayCalendarEntry contactsBirthdayCalendarEntry) {
        return new ViewAction(contactsBirthdayCalendarEntry);
    }

    public boolean isUsable() {
        return ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN);
    }

    private static class ViewAction
    extends AbstractI18nAction {
        private final ContactsBirthdayCalendarEntry entry;

        public ViewAction(ContactsBirthdayCalendarEntry contactsBirthdayCalendarEntry) {
            this.entry = contactsBirthdayCalendarEntry;
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                long l = this.entry.getContact().id;
                new ContactsPlugin.EntryFormAction(l).actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                LOGGER.error("Can't open contact!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the birthday child."));
        }
    }
}

