/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.calendar;

import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarExtension;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsCalendarHandler;
import com.openindex.openestate.tool.contacts.addons.calendar.db.DbContactsEntryCalendarEntry;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import com.openindex.openestate.tool.db.DbUpgradeHandler;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.extensions.DbRelationExtension;
import com.openindex.openestate.tool.extensions.UpgradeAdapter;
import com.openindex.openestate.tool.extensions.UpgradeExtension;
import com.openindex.openestate.tool.utils.Relation;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={UpgradeExtension.class}, plugins={"OpenEstate-Tool-Calendar", "OpenEstate-Tool-Contacts"})
public class ContactsCalendarUpgradeExtension
extends UpgradeAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsCalendarUpgradeExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsCalendarUpgradeExtension.class);

    public void upgradeFinished(Connection connection, AbstractDbDriver abstractDbDriver, DbExtension dbExtension, DbUser dbUser, File file, ImmoToolTask.Callback callback) {
        this.setMessage("Upgrade contacts-calendar relations...", callback);
        DbUpgradeHandler dbUpgradeHandler = dbExtension.getUpgradeHandler();
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter(".xml", IOCase.INSENSITIVE);
        File file2 = new File(file.getAbsolutePath() + File.separator + "entry_calendars");
        DbContactsCalendarHandler dbContactsCalendarHandler = null;
        Object[] objectArray = DbRelationExtension.load((AbstractDbDriver)abstractDbDriver, null).iterator();
        while (objectArray.hasNext()) {
            Object[] objectArray2 = (Object[])objectArray.next();
            if (!(objectArray2 instanceof DbContactsCalendarExtension)) continue;
            dbContactsCalendarHandler = ((DbContactsCalendarExtension)objectArray2).getHandler();
            break;
        }
        if (dbContactsCalendarHandler == null) {
            LOGGER.warn("Can't find relation-handler!");
            LOGGER.warn("> " + DbContactsCalendarExtension.class.getName());
            this.setMessage("WARNING: Can't find relation-handler!", callback);
            this.setMessage("> " + DbContactsCalendarExtension.class.getName(), callback);
            return;
        }
        if (file2.isDirectory() && ArrayUtils.isNotEmpty((Object[])(objectArray = file2.listFiles((FileFilter)suffixFileFilter)))) {
            for (Object object : objectArray) {
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream((File)object), StandardCharsets.UTF_8);){
                    Relation relation = new Relation();
                    relation.read((Reader)inputStreamReader);
                    DbContactsEntryCalendarEntry dbContactsEntryCalendarEntry = new DbContactsEntryCalendarEntry();
                    dbContactsEntryCalendarEntry.relationNotes = relation.getNotes();
                    if (dbContactsEntryCalendarEntry.relationNotes != null && dbContactsEntryCalendarEntry.relationNotes.trim().length() < 1) {
                        dbContactsEntryCalendarEntry.relationNotes = null;
                    }
                    dbContactsEntryCalendarEntry.contactsEntryId = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Contacts.entries", relation.getFirstObject("com.openindex.openestate.tool.contacts.ContactsEntry").getId());
                    dbContactsEntryCalendarEntry.calendarEntryId = dbUpgradeHandler.getNewId(connection, "OpenEstate-Tool-Calendar.entries", relation.getFirstObject("com.openindex.openestate.tool.calendar.CalendarEntry").getId());
                    if (dbContactsEntryCalendarEntry.contactsEntryId < 1L || dbContactsEntryCalendarEntry.calendarEntryId < 1L) {
                        LOGGER.warn("Relation is incomplete!");
                        this.setMessage("WARNING: Relation is incomplete!", callback);
                        continue;
                    }
                    this.setMessage("> contact-entry #" + dbContactsEntryCalendarEntry.contactsEntryId + " / calendar-entry #" + dbContactsEntryCalendarEntry.calendarEntryId, callback);
                    dbContactsCalendarHandler.saveEntryCalendarEntry(connection, dbContactsEntryCalendarEntry);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read relation!");
                    LOGGER.warn("> from " + ((File)object).getAbsolutePath());
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    this.setMessage("WARNING: Can't read relation!", callback);
                    this.setMessage("> " + exception.getLocalizedMessage(), callback);
                }
            }
        }
    }
}

