/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.addons.mail.MailEditorContactsExtension;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryTableAdapter;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.gui.AbstractMainTab;
import com.openindex.openestate.tool.mail.MailEditor;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailWritePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={EntryTableExtension.class}, plugins={"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"})
public class ContactsEntryTableMailExtension
extends EntryTableAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryTableMailExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryTableMailExtension.class);

    public JMenuItem[] createActionMenuItems(final ImmoToolProject immoToolProject, final Long[] longArray, JComponent jComponent) {
        if (ArrayUtils.isEmpty((Object[])longArray)) {
            return null;
        }
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        try {
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setText(StringUtils.capitalize((String)I18N.tr("compose e-mail")));
            jMenuItem.setIcon(MailPlugin.getResourceIcon((String)"mail_generic.png", (int)16));
            arrayList.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ContactsEntryTableMailExtension.this.doSendMailTo(longArray, immoToolProject);
                }
            });
        }
        catch (Throwable throwable) {
            LOGGER.error("Can't load contacts menu!");
            LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new JMenuItem[0]) : null;
    }

    private void doSendMailTo(final Long[] longArray, final ImmoToolProject immoToolProject) {
        final DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        ImmoToolTask<MailWritePanel, Void> immoToolTask = new ImmoToolTask<MailWritePanel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected MailWritePanel doInBackground() throws Exception {
                MailWritePanel mailWritePanel = MailWritePanel.createTab();
                Connection connection = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    long[] lArray = ArrayUtils.toPrimitive((Long[])longArray);
                    DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, lArray);
                    dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
                    for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
                        String string = dbContactsEntry.getAddressMail();
                        if (StringUtils.isBlank((CharSequence)string)) {
                            LOGGER.warn("Can't find mail address for contact entry #" + dbContactsEntry.id + "!");
                            continue;
                        }
                        mailWritePanel.addRecipient(MailEditor.RecipientType.TO, (MailEditor.Address)new MailEditorContactsExtension.ContactsAddress(dbContactsEntry));
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                return mailWritePanel;
            }

            protected void succeeded(MailWritePanel mailWritePanel) {
                super.succeeded((Object)mailWritePanel);
                if (mailWritePanel == null) {
                    return;
                }
                ImmoToolAppUtils.showTab((AbstractMainTab)mailWritePanel);
                mailWritePanel.loadInBackground(immoToolProject.getDbDriver());
            }
        };
        ImmoToolUtils.executeTask((ImmoToolTask)immoToolTask);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"};
    }
}

