/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.contacts.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.contacts.ContactsEntryImportVCardTask;
import com.openindex.openestate.tool.contacts.ContactsGroupChooser;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailViewer;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import com.openindex.openestate.tool.mail.extensions.MailViewerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailViewerExtension;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.ContentType;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.apache.commons.io.FileUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={MailViewerExtension.class}, plugins={"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"})
public class MailViewContactsExtension
extends MailViewerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailViewContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailViewContactsExtension.class);

    public JMenuItem[] createPartMenuItems(MailViewer.PartItem partItem, final MailViewer mailViewer) {
        DbMailMessage dbMailMessage = this.getMessage();
        if (dbMailMessage == null || partItem == null) {
            return null;
        }
        final long l = dbMailMessage.id;
        final long l2 = partItem.getId();
        String string = partItem.getFileName();
        ContentType contentType = partItem.getContentType();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        try {
            if (this.isVcard(contentType, string)) {
                JMenuItem jMenuItem = new JMenuItem();
                jMenuItem.setText("VCard als Adresse importieren");
                jMenuItem.setIcon(ContactsPlugin.getResourceIcon((String)"vcard.png", (int)16));
                arrayList.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MailViewContactsExtension.this.doImportVCard(l, l2, mailViewer);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Can't load attachment menu!");
            LOGGER.error("> " + throwable.getLocalizedMessage(), throwable);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new JMenuItem[0]) : null;
    }

    private void doImportVCard(long l, final long l2, MailViewer mailViewer) {
        DbContactsGroup dbContactsGroup;
        final ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        final DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        final DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        try {
            dbContactsGroup = ContactsGroupChooser.showDialog((ImmoToolProject)immoToolProject, (Window)ImmoToolEnvironment.getFrame());
            if (dbContactsGroup == null) {
                return;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't load contact groups!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load contact groups!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
            return;
        }
        ImmoToolTaskContainer immoToolTaskContainer = new ImmoToolTaskContainer("Import VCard"){
            private String successMessage;
            {
                super(string);
                this.successMessage = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean doInBackground() throws Exception {
                FileOutputStream fileOutputStream;
                Connection connection = null;
                File file = null;
                try {
                    connection = immoToolProject.getDbConnection();
                    this.setMessage("Store VCard temporarily");
                    file = File.createTempFile("temp.", ".vcard");
                    fileOutputStream = new FileOutputStream(file);
                    try {
                        dbMailMessageHandler.downloadPart(connection, l2, (OutputStream)fileOutputStream);
                    }
                    finally {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                finally {
                    JdbcUtils.closeQuietly((Connection)connection);
                }
                fileOutputStream = new ContactsEntryImportVCardTask(immoToolProject.getDbDriver(), dbContactsHandler, file){
                    private final List<Long> contactEntryIds;
                    {
                        this.contactEntryIds = new ArrayList<Long>();
                    }

                    protected void contactWasImported(DbContactsEntry dbContactsEntry) {
                        if (dbContactsEntry != null) {
                            this.contactEntryIds.add(dbContactsEntry.id);
                        }
                    }

                    protected Integer doInBackground() throws Exception {
                        Integer n = super.doInBackground();
                        return n;
                    }

                    protected void finished() {
                        super.finished();
                        this.setMessage("Remove temporarily saved VCard");
                        FileUtils.deleteQuietly((File)this.getImportFile());
                    }

                    protected void succeeded(Integer n) {
                        super.succeeded((Object)n);
                        successMessage = n != null && n > 0 ? "Es wurden " + n + " Adressen importiert." : "Es wurde keine Adressen importiert!";
                    }
                };
                fileOutputStream.setImportGroup(dbContactsGroup);
                this.add((ImmoToolTask)fileOutputStream);
                return super.doInBackground();
            }

            protected void failed(Throwable throwable) {
                super.failed(throwable);
                ImmoToolUtils.showMessageErrorDialog((String)"Can't import VCard attachment!", (Throwable)throwable, (Window)this.getParentWindow());
            }

            protected void succeeded(Boolean bl) {
                super.succeeded((Object)bl);
                if (!Boolean.TRUE.equals(bl)) {
                    return;
                }
                if (this.successMessage != null) {
                    ImmoToolUtils.showMessageInfoDialog((String)this.successMessage, (Component)this.getParentWindow());
                }
            }
        };
        ImmoToolTaskDialog.showDialog((ImmoToolTask)immoToolTaskContainer, (Window)ImmoToolEnvironment.getFrame());
    }

    public Icon getPartIcon(MailViewer.PartItem partItem, int n) {
        if (partItem != null && this.isVcard(partItem.getContentType(), partItem.getFileName())) {
            return ContactsPlugin.getResourceIcon((String)"vcard.png", (int)n);
        }
        return null;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Contacts", "OpenEstate-Tool-Mail"};
    }

    private boolean isVcard(ContentType contentType, String string) {
        if (contentType != null) {
            if (contentType.match("text/x-vcard")) {
                return true;
            }
            if (contentType.match("text/directory") && "vCard".equalsIgnoreCase(contentType.getParameter("profile"))) {
                return true;
            }
        }
        if (string != null) {
            if (string.trim().toLowerCase().endsWith(".vcf")) {
                return true;
            }
            if (string.trim().toLowerCase().endsWith(".vcard")) {
                return true;
            }
        }
        return false;
    }
}

