-- -----------------------------------------------------
-- Contacts-Addon for OpenEstate-ImmoTool
-- update 2 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'entry_public_id' to table 'immotool_contacts_entries'
-- Rename keys within table 'immotool_contacts_entries_settings'
-- Add letter address 'FORMAL' to all addresses by default
-- -----------------------------------------------------

DROP PROCEDURE IF EXISTS save_immotool_contacts_entries RESTRICT;

ALTER TABLE immotool_contacts_entries
  ADD COLUMN entry_public_id VARCHAR(255) DEFAULT NULL NULL
  BEFORE entry_notes;

ALTER VIEW view_immotool_contacts_entries AS
  SELECT * FROM immotool_contacts_entries
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (
      group_id IN (SELECT group_id FROM view_immotool_contacts_groups)
      AND
      (
        (BITAND(access_permissions, 64) = 64)
        OR
        (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
        OR
        (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
      )
    )
  );

\.
CREATE PROCEDURE save_immotool_contacts_entries(
  INOUT val_entry_id BIGINT,
  val_group_id BIGINT,
  val_entry_public_id VARCHAR(255),
  val_entry_notes LONGVARCHAR,
  val_entry_active BOOLEAN,
  val_entry_birthday DATE,
  val_access_owner_id BIGINT,
  val_access_group_id BIGINT,
  val_access_permissions INT )
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neuen Eintrag erzeugen
    IF val_entry_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Eintrag speichern
      INSERT INTO immotool_contacts_entries (
        group_id,
        entry_public_id,
        entry_notes,
        entry_active,
        entry_birthday,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_group_id,
        val_entry_public_id,
        val_entry_notes,
        val_entry_active,
        val_entry_birthday,
        owner_uid,
        owner_gid,
        permissions );

      -- ID zurückliefern
      SET val_entry_id = IDENTITY();

    -- Bestehenden Eintrag bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_contacts_entries
        WHERE entry_id = val_entry_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN
        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Eintrag bearbeiten
      UPDATE immotool_contacts_entries
        SET
          group_id = val_group_id,
          entry_public_id = val_entry_public_id,
          entry_notes = val_entry_notes,
          entry_active = val_entry_active,
          entry_birthday = val_entry_birthday,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          entry_id = val_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_contacts_entries
  TO "IMMOTOOL";

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.identification_nr'
  WHERE setting_key = 'value.ausweis_nr';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.letter_address'
  WHERE setting_key = 'value.briefanrede';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.owner'
  WHERE setting_key = 'value.konto_inhaber';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.institute'
  WHERE setting_key = 'value.konto_institut';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.nr'
  WHERE setting_key = 'value.konto_nr';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.bank_code_nr'
  WHERE setting_key = 'value.konto_blz';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.iban'
  WHERE setting_key = 'value.konto_iban';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.bank_account.bic'
  WHERE setting_key = 'value.konto_bic';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.languages'
  WHERE setting_key = 'value.sprachen';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.tax.nr'
  WHERE setting_key = 'value.steuer_nr';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.tax.idnr'
  WHERE setting_key = 'value.steuer_idnr';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.tax.uid'
  WHERE setting_key = 'value.steuer_umsatz_idnr';

UPDATE immotool_contacts_entries_settings
  SET setting_key = 'value.tax.wirtschaft_idnr'
  WHERE setting_key = 'value.wirtschaft_idnr';

INSERT INTO immotool_contacts_entries_settings (
  SELECT entry_id, 'value.letter_address' AS setting_key, 'FORMAL' AS setting_value
    FROM immotool_contacts_entries
    WHERE entry_id NOT IN (
      SELECT entry_id FROM immotool_contacts_entries_settings WHERE setting_key='value.letter_address'
    ));
