-- -----------------------------------------------------
-- Calender extensions to the Contacts-Addon for OpenEstate-ImmoTool
-- update 5 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Update procedure 'remove_immotool_contacts_entries_calendar_entries'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_contacts_entries_calendar_entries
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_contacts_entries_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    IF val_contacts_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_calendar_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lese-Rechte besitzt
    IF NOT is_admin() = TRUE THEN

      -- Lese-Rechte auf der Adresse müssen vorliegen
      IF NOT can_read_immotool_contacts_entries( val_contacts_entry_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

      -- Lese-Rechte auf dem Kalendereintrag müssen vorliegen
      IF NOT can_read_immotool_calendar_entries( val_calendar_entry_id ) = TRUE THEN
        SIGNAL SQLSTATE '45000';
      END IF;

    END IF;

    -- Relation entfernen
    DELETE
      FROM immotool_contacts_entries_calendar_entries
      WHERE contacts_entry_id = val_contacts_entry_id
      AND calendar_entry_id = val_calendar_entry_id;

  END;
.;
