-- -----------------------------------------------------
-- Contacts-Addon for OpenEstate-ImmoTool
-- update 7 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Call temporary procedure 'immotool_contacts_update_permissions'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Call temporary procedure 'immotool_contacts_update_permissions'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS immotool_contacts_update_permissions;

\.
CREATE PROCEDURE immotool_contacts_update_permissions()
  SPECIFIC immotool_contacts_update_permissions
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE pluginId BIGINT;
    DECLARE permissionId BIGINT;
    DECLARE groupId BIGINT;

    -- ID des Plugins ermitteln
    SELECT plugin_id
      INTO pluginId
      FROM immotool_plugins
      WHERE plugin_name = 'OpenEstate-Tool-Contacts';

    -- USE_PLUGIN-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'USE_PLUGIN' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ID der IMMOTOOL-Gruppe ermitteln
    SELECT group_id
      INTO groupId
      FROM immotool_groups
      WHERE group_name = 'IMMOTOOL';

    -- USE_PLUGIN-Berechtigung zur IMMOTOOL-Gruppe zuweisen
    INSERT INTO immotool_groups_permissions (
      group_id,
      permission_id )
    VALUES (
      groupId,
      permissionId );

    -- Umbenennung der bestehenden Berechtigungen
    UPDATE immotool_permissions
      SET permission_key = 'ENTRIES_EDIT', modified_at = NOW()
      WHERE permission_key = 'address.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'ENTRIES_EDIT_GROUP', modified_at = NOW()
      WHERE permission_key = 'address.group'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'ENTRIES_IMPORT', modified_at = NOW()
      WHERE permission_key = 'address.import'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'ENTRIES_REMOVE', modified_at = NOW()
      WHERE permission_key = 'address.remove'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'GROUPS_EDIT', modified_at = NOW()
      WHERE permission_key = 'group.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'GROUPS_REMOVE', modified_at = NOW()
      WHERE permission_key = 'group.remove'
      AND plugin_id = pluginId;


    -- ENTRIES_EXPORT-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ENTRIES_EXPORT' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ENTRIES_EXPORT-Berechtigung allen Benutzern mit ENTRIES_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='ENTRIES_EDIT')
      );

    -- ENTRIES_EXPORT-Berechtigung allen Gruppen mit ENTRIES_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='ENTRIES_EDIT')
      );

  END;
.;

CALL immotool_contacts_update_permissions();

DROP PROCEDURE
  IF EXISTS immotool_contacts_update_permissions;
