/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.agency;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolException;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.crm.CrmActivityRelationPanel;
import com.openindex.openestate.tool.crm.CrmActivityTable;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.agency.CrmAgencyUtils;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmActivityAgencyObject;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmAgencyEstateActivitiesPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmAgencyEstateActivitiesPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmAgencyEstateActivitiesPanel.class);
    private static final String RELATION_TABLE_ID = "CrmAgencyEstateActivitiesPanel.RelationTable";
    private WeakReference<DbAgencyObject> currentAgencyObject = null;
    private JXTitledSeparator activitiesTitle;
    private RelationTable activitiesTable;
    private RelationForm relationForm;
    private AbstractI18nAction relationAddAction;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction showActionsAction;

    public CrmAgencyEstateActivitiesPanel() {
        this.build();
    }

    private void build() {
        this.activitiesTable = new RelationTable();
        this.activitiesTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.activitiesTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.activitiesTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    private void doActivityView() {
        int n = this.activitiesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.activitiesTable.getActivityIdAt(this.activitiesTable.convertRowIndexToModel(n));
        new CrmPlugin.ActivityFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        DbAgencyObject dbAgencyObject;
        DbAgencyObject dbAgencyObject2 = dbAgencyObject = this.currentAgencyObject != null ? (DbAgencyObject)this.currentAgencyObject.get() : null;
        if (dbAgencyObject == null || dbAgencyObject.id < 1L) {
            return;
        }
        this.activitiesTable.setEnabled(false);
        this.activitiesTable.clearSelection();
        this.activitiesTable.clearRows();
        ArrayList<DbCrmActivity> arrayList = new ArrayList<DbCrmActivity>();
        try {
            DbCrmAgencyHandler dbCrmAgencyHandler = CrmAgencyUtils.getCrmAgencyHandler();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            DbCrmActivityAgencyObject[] dbCrmActivityAgencyObjectArray = dbCrmAgencyHandler.getActivityAgencyObjects(connection, 0L, dbAgencyObject.id);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            for (DbCrmActivityAgencyObject dbCrmActivityAgencyObject : dbCrmActivityAgencyObjectArray) {
                arrayList2.add(dbCrmActivityAgencyObject.crmActivityId);
            }
            long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
            DbCrmActivity[] dbCrmActivityArray = dbCrmActivityHandler.getActivities(connection, lArray);
            arrayList.addAll(Arrays.asList(dbCrmActivityArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList){
                final /* synthetic */ List val$activitiesList;
                {
                    this.val$activitiesList = list;
                }

                @Override
                public void run() {
                    try {
                        for (DbCrmActivity dbCrmActivity : this.val$activitiesList) {
                            CrmAgencyEstateActivitiesPanel.this.activitiesTable.addRow((AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                        }
                    }
                    finally {
                        CrmAgencyEstateActivitiesPanel.this.activitiesTable.setEnabled(true);
                        CrmAgencyEstateActivitiesPanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doRefresh() {
        try {
            this.load(this.currentAgencyObject != null ? (DbAgencyObject)this.currentAgencyObject.get() : null);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activities for calendar entry!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activities for calendar entry!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.activitiesTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.activitiesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ActivityViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("activities"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbAgencyObject dbAgencyObject) throws ImmoToolException {
        this.currentAgencyObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        this.relationForm.unselectRelation();
        this.activitiesTable.clearRows();
        this.updateTitle();
    }

    public void save(DbAgencyObject dbAgencyObject) throws ImmoToolException {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException, IOException {
        Object object2;
        DbCrmAgencyHandler dbCrmAgencyHandler = CrmAgencyUtils.getCrmAgencyHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbCrmAgencyHandler.getActivityAgencyObjects(connection, 0L, dbAgencyObject.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object2 : objectArray) {
                hashMap.put(((DbCrmActivityAgencyObject)object2).crmActivityId, object2);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.activitiesTable.getRowCount(); ++i) {
            Long l = this.activitiesTable.getActivityIdAt(i);
            if (!hashMap.containsKey(l)) {
                object2 = new DbCrmActivityAgencyObject();
                ((DbCrmActivityAgencyObject)object2).crmActivityId = l;
                ((DbCrmActivityAgencyObject)object2).agencyObjectId = dbAgencyObject.id;
                dbCrmAgencyHandler.saveActivityAgencyObject(connection, (DbCrmActivityAgencyObject)object2);
                hashMap.put(l, object2);
            }
            arrayList.add(l);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Long)entry.getKey();
            if (arrayList.contains(object2)) continue;
            dbCrmAgencyHandler.removeActivityAgencyObject(connection, (DbCrmActivityAgencyObject)entry.getValue());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        Object object = StringUtils.capitalize((String)I18N.tr("activities for the property"));
        int n2 = n = this.activitiesTable != null ? this.activitiesTable.getRowCount() : 0;
        if (n > 0) {
            object = (String)object + " / ";
            object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.activitiesTitle.setTitle((String)object);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        public ShowActionsAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmAgencyEstateActivitiesPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        public RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmAgencyEstateActivitiesPanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        public RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmAgencyEstateActivitiesPanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmAgencyEstateActivitiesPanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        public RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmAgencyEstateActivitiesPanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ActivityViewAction
    extends AbstractI18nAction {
        public ActivityViewAction() {
            this.setSmallIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmAgencyEstateActivitiesPanel.this.doActivityView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
            this.setShortDescription(I18N.tr("Show details about the activity."));
        }
    }

    private final class RelationTable
    extends CrmActivityTable<CrmActivityTable.Row> {
        public RelationTable() {
            super(CrmAgencyEstateActivitiesPanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CrmAgencyEstateActivitiesPanel.this.doRelationRemove();
        }

        protected void doSelect() {
            CrmAgencyEstateActivitiesPanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmAgencyEstateActivitiesPanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CrmAgencyEstateActivitiesPanel.this.relationForm.selectRelation(this.getActivityAt(n), null);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmAgencyEstateActivitiesPanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmAgencyEstateActivitiesPanel.this.doActivityView();
        }
    }

    private final class RelationForm
    extends CrmActivityRelationPanel {
        private RelationForm() {
            super(false);
        }

        protected void close() {
            if (CrmAgencyEstateActivitiesPanel.this.activitiesTable.getSelectedRowCount() > 0) {
                CrmAgencyEstateActivitiesPanel.this.activitiesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbCrmActivity dbCrmActivity, String string) {
            if (dbCrmActivity == null) {
                return false;
            }
            CrmAgencyEstateActivitiesPanel.this.activitiesTable.setEnabled(false);
            try {
                if (this.getCurrentCrmActivityId() < 1L) {
                    CrmAgencyEstateActivitiesPanel.this.activitiesTable.addRow((AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                } else {
                    int n = CrmAgencyEstateActivitiesPanel.this.activitiesTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmAgencyEstateActivitiesPanel.this.activitiesTable.convertRowIndexToModel(n);
                        CrmAgencyEstateActivitiesPanel.this.activitiesTable.setRowAt(n2, (AbstractTable.Row)new CrmActivityTable.Row(dbCrmActivity));
                    }
                }
            }
            finally {
                CrmAgencyEstateActivitiesPanel.this.activitiesTable.clearSelection();
                CrmAgencyEstateActivitiesPanel.this.activitiesTable.setEnabled(true);
                CrmAgencyEstateActivitiesPanel.this.updateTitle();
            }
            return true;
        }
    }
}

