/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.calendar;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.calendar.CalendarEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryRelationPanel;
import com.openindex.openestate.tool.calendar.CalendarEntryTable;
import com.openindex.openestate.tool.calendar.CalendarEventEntryPanel;
import com.openindex.openestate.tool.calendar.CalendarPermission;
import com.openindex.openestate.tool.calendar.CalendarPlugin;
import com.openindex.openestate.tool.calendar.CalendarTodoEntryPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.calendar.db.DbCalendarGroup;
import com.openindex.openestate.tool.calendar.db.DbCalendarHandler;
import com.openindex.openestate.tool.crm.CrmActivityViewPanel;
import com.openindex.openestate.tool.crm.addons.calendar.CrmCalendarUtils;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmActivityCalendarEntry;
import com.openindex.openestate.tool.crm.addons.calendar.db.DbCrmCalendarHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmActivityCalendarTablePanel
extends CrmActivityViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityCalendarTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityCalendarTablePanel.class);
    private static final String RELATION_TABLE_ID = "CrmActivityCalendarTablePanel.RelationTable";
    private DbCrmActivity currentActivity = null;
    private JXTitledSeparator formTitle;
    private JTabbedPane tabbedPane;
    private RelationsTab relationsTab;
    private NewEntryTab newEntryTab;

    public CrmActivityCalendarTablePanel() {
        this.build();
    }

    private void build() {
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.tabbedPane = new JTabbedPane();
        this.relationsTab = (RelationsTab)ImmoToolUtils.addTab((AbstractTab)new RelationsTab(), (JTabbedPane)this.tabbedPane);
        this.newEntryTab = CalendarPlugin.isUserAllowedTo((CalendarPermission)CalendarPermission.ENTRIES_EDIT) ? (NewEntryTab)ImmoToolUtils.addTab((AbstractTab)new NewEntryTab(), (JTabbedPane)this.tabbedPane) : null;
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.formTitle, "North");
        this.add(this.tabbedPane, "Center");
        this.updateLocalization();
    }

    private void doEntryAdd() {
        if (this.newEntryTab == null) {
            return;
        }
        DbCalendarEntry.Type type = (DbCalendarEntry.Type)this.newEntryTab.typeField.getSelectedItem();
        if (type == null || !this.newEntryTab.entryForms.containsKey(type)) {
            return;
        }
        CalendarEntryPanel calendarEntryPanel = this.newEntryTab.entryForms.get(type);
        DbCalendarEntry dbCalendarEntry = calendarEntryPanel.createEntry();
        if (!this.newEntryTab.submitNewCalendarEntry(dbCalendarEntry)) {
            return;
        }
        this.newEntryTab.entryAddAction.setEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new EntryAddTask(dbCalendarEntry));
    }

    private void doEntryView() {
        int n = this.relationsTab.entriesTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.relationsTab.entriesTable.getCalendarEntryIdAt(this.relationsTab.entriesTable.convertRowIndexToModel(n));
        new CalendarPlugin.EntryFormAction(l).actionPerformed(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.relationsTab.entriesTable.setEnabled(false);
        this.relationsTab.entriesTable.clearSelection();
        this.relationsTab.entriesTable.clearRows();
        DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
        ArrayList<DbCalendarEntry> arrayList = new ArrayList<DbCalendarEntry>();
        HashMap<Long, DbCalendarGroup> hashMap = new HashMap<Long, DbCalendarGroup>();
        try {
            int dbCalendarEntryArray;
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            DbCrmCalendarHandler dbCrmCalendarHandler = CrmCalendarUtils.getCrmCalendarHandler();
            DbCalendarGroup[] objectArray = dbCalendarHandler.getGroups(connection);
            int lArray = objectArray.length;
            for (dbCalendarEntryArray = 0; dbCalendarEntryArray < lArray; ++dbCalendarEntryArray) {
                DbCalendarGroup dbCalendarGroup = objectArray[dbCalendarEntryArray];
                hashMap.put(dbCalendarGroup.id, dbCalendarGroup);
            }
            if (this.currentActivity != null && this.currentActivity.id > 0L) {
                DbCrmActivityCalendarEntry[] dbCrmActivityCalendarEntryArray = dbCrmCalendarHandler.getActivityCalendarEntries(connection, this.currentActivity.id);
                long[] lArray2 = new long[dbCrmActivityCalendarEntryArray.length];
                for (dbCalendarEntryArray = 0; dbCalendarEntryArray < dbCrmActivityCalendarEntryArray.length; ++dbCalendarEntryArray) {
                    lArray2[dbCalendarEntryArray] = dbCrmActivityCalendarEntryArray[dbCalendarEntryArray].calendarEntryId;
                }
                DbCalendarEntry[] dbCalendarEntryArray2 = dbCalendarHandler.getEntries(connection, lArray2);
                arrayList.addAll(Arrays.asList(dbCalendarEntryArray2));
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(hashMap, dbUser, arrayList){
                final /* synthetic */ Map val$groupsMap;
                final /* synthetic */ DbUser val$currentUser;
                final /* synthetic */ List val$entriesList;
                {
                    this.val$groupsMap = map;
                    this.val$currentUser = dbUser;
                    this.val$entriesList = list;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultComboBoxModel<DbCalendarGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbCalendarGroup>();
                    DefaultComboBoxModel<DbCalendarGroup> defaultComboBoxModel2 = new DefaultComboBoxModel<DbCalendarGroup>();
                    try {
                        defaultComboBoxModel.addElement(null);
                        defaultComboBoxModel2.addElement(null);
                        for (DbCalendarGroup dbCalendarGroup : this.val$groupsMap.values()) {
                            boolean bl = dbCalendarGroup.permission.canRead(this.val$currentUser, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
                            boolean bl2 = dbCalendarGroup.permission.canWrite(this.val$currentUser, dbCalendarGroup.ownerUserId, dbCalendarGroup.ownerGroupId);
                            if (bl2) {
                                defaultComboBoxModel.addElement(dbCalendarGroup);
                            }
                            if (!bl) continue;
                            defaultComboBoxModel2.addElement(dbCalendarGroup);
                        }
                        for (DbCalendarEntry dbCalendarEntry : this.val$entriesList) {
                            String string = this.val$groupsMap.containsKey(dbCalendarEntry.groupId) ? ((DbCalendarGroup)this.val$groupsMap.get((Object)Long.valueOf((long)dbCalendarEntry.groupId))).name : null;
                            CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new CalendarEntryTable.Row(dbCalendarEntry, StringUtils.trimToNull((String)string)));
                        }
                    }
                    catch (Throwable throwable) {
                        CrmActivityCalendarTablePanel.this.relationsTab.relationForm.setCalendarGroupsModel(defaultComboBoxModel2);
                        if (CrmActivityCalendarTablePanel.this.newEntryTab != null) {
                            for (CalendarEntryPanel calendarEntryPanel : CrmActivityCalendarTablePanel.this.newEntryTab.entryForms.values()) {
                                calendarEntryPanel.load(calendarEntryPanel.createEntry());
                                calendarEntryPanel.setCalendarGroupsModel(defaultComboBoxModel);
                            }
                        }
                        CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.setEnabled(true);
                        CrmActivityCalendarTablePanel.this.relationsTab.showActionsAction.setEnabled(false);
                        CrmActivityCalendarTablePanel.this.relationsTab.updateTitle();
                        throw throwable;
                    }
                    CrmActivityCalendarTablePanel.this.relationsTab.relationForm.setCalendarGroupsModel(defaultComboBoxModel2);
                    if (CrmActivityCalendarTablePanel.this.newEntryTab != null) {
                        for (CalendarEntryPanel calendarEntryPanel : CrmActivityCalendarTablePanel.this.newEntryTab.entryForms.values()) {
                            calendarEntryPanel.load(calendarEntryPanel.createEntry());
                            calendarEntryPanel.setCalendarGroupsModel(defaultComboBoxModel);
                        }
                    }
                    CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.setEnabled(true);
                    CrmActivityCalendarTablePanel.this.relationsTab.showActionsAction.setEnabled(false);
                    CrmActivityCalendarTablePanel.this.relationsTab.updateTitle();
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doRefresh() {
        try {
            this.load(this.currentActivity);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload properties for activity!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload properties for activity!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationsTab.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.relationsTab.entriesTable.removeSelectedRows()) {
            this.relationsTab.relationForm.unselectRelation();
            this.relationsTab.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.relationsTab.entriesTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new EntryViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("calendar"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbCrmActivity dbCrmActivity) {
        this.currentActivity = dbCrmActivity;
        this.relationsTab.relationForm.unselectRelation();
        this.relationsTab.entriesTable.setEnabled(false);
        this.relationsTab.entriesTable.clearSelection();
        this.relationsTab.entriesTable.clearRows();
        this.relationsTab.showActionsAction.setEnabled(false);
        this.relationsTab.updateTitle();
        if (this.newEntryTab != null) {
            for (CalendarEntryPanel calendarEntryPanel : this.newEntryTab.entryForms.values()) {
                calendarEntryPanel.load(null);
            }
        }
    }

    public void save(DbCrmActivity dbCrmActivity) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCrmActivity dbCrmActivity) throws SQLException {
        DbCrmCalendarHandler dbCrmCalendarHandler = CrmCalendarUtils.getCrmCalendarHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbCrmCalendarHandler.getActivityCalendarEntries(connection, dbCrmActivity.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                hashMap.put(((DbCrmActivityCalendarEntry)object).calendarEntryId, object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.relationsTab.entriesTable.getRowCount(); ++i) {
            Object object;
            Long l = this.relationsTab.entriesTable.getCalendarEntryIdAt(i);
            object = hashMap.containsKey(l) ? (DbCrmActivityCalendarEntry)hashMap.get(l) : new DbCrmActivityCalendarEntry();
            ((DbCrmActivityCalendarEntry)object).calendarEntryId = l;
            ((DbCrmActivityCalendarEntry)object).crmActivityId = dbCrmActivity.id;
            dbCrmCalendarHandler.saveActivityCalendarEntries(connection, (DbCrmActivityCalendarEntry)object);
            arrayList.add(l);
            hashMap.put(l, object);
        }
        for (Long l : hashMap.keySet().toArray(new Long[0])) {
            if (arrayList.contains(l)) continue;
            dbCrmCalendarHandler.removeActivityCalendarEntry(connection, (DbCrmActivityCalendarEntry)hashMap.get(l));
            hashMap.remove(l);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("calendar entries for the activity")));
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon((String)"vcalendar.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CrmActivityCalendarTablePanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        private RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityCalendarTablePanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        private RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityCalendarTablePanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CrmActivityCalendarTablePanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityCalendarTablePanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class EntryViewAction
    extends AbstractI18nAction {
        private EntryViewAction() {
            this.setSmallIcon(CalendarPlugin.getResourceIcon((String)"vcalendar.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityCalendarTablePanel.this.doEntryView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("view entry")));
            this.setShortDescription(I18N.tr("Show details about the calendar entry."));
        }
    }

    private class EntryAddTask
    extends ImmoToolTask<Boolean, Void> {
        private final DbCalendarEntry newEntry;
        private String calendarGroupName = null;

        private EntryAddTask(DbCalendarEntry dbCalendarEntry) {
            this.newEntry = dbCalendarEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCalendarHandler dbCalendarHandler = CalendarPlugin.getDbCalendarExtension().getCalendarHandler();
            Connection connection = null;
            this.calendarGroupName = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCalendarHandler.saveEntry(connection, this.newEntry);
                DbCalendarGroup dbCalendarGroup = dbCalendarHandler.getGroup(connection, this.newEntry.groupId);
                if (dbCalendarGroup == null) {
                    throw new Exception("Can't find group #" + this.newEntry.groupId + "!");
                }
                this.calendarGroupName = dbCalendarGroup.name;
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            CrmActivityCalendarTablePanel.this.newEntryTab.entryAddAction.setEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            CrmActivityCalendarTablePanel.this.relationsTab.relationForm.unselectRelation();
            CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new CalendarEntryTable.Row(this.newEntry, this.calendarGroupName));
            CrmActivityCalendarTablePanel.this.relationsTab.updateTitle();
            CrmActivityCalendarTablePanel.this.newEntryTab.clearForm();
            CrmActivityCalendarTablePanel.this.tabbedPane.setSelectedIndex(0);
        }
    }

    private class EntryAddAction
    extends AbstractI18nAction {
        private EntryAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CrmActivityCalendarTablePanel.this.doEntryAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Save and assign the new calendar entry."));
        }
    }

    private final class RelationTable
    extends CalendarEntryTable<CalendarEntryTable.Row> {
        private RelationTable() {
            super(CrmActivityCalendarTablePanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CrmActivityCalendarTablePanel.this.doRelationRemove();
        }

        protected void doSelect() {
            if (!this.isEnabled()) {
                return;
            }
            CrmActivityCalendarTablePanel.this.relationsTab.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CrmActivityCalendarTablePanel.this.relationsTab.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CrmActivityCalendarTablePanel.this.relationsTab.relationForm.selectRelation(this.getCalendarEntryAt(n), null);
            }
        }

        protected void doShowActions(int n, int n2) {
            CrmActivityCalendarTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CrmActivityCalendarTablePanel.this.doEntryView();
        }
    }

    private final class RelationForm
    extends CalendarEntryRelationPanel {
        private RelationForm() {
            super(false);
        }

        protected void close() {
            if (CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.getSelectedRowCount() > 0) {
                CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbCalendarGroup dbCalendarGroup, DbCalendarEntry dbCalendarEntry, String string) {
            if (dbCalendarGroup == null || dbCalendarEntry == null) {
                return false;
            }
            CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.setEnabled(false);
            try {
                if (this.getCurrentCalendarEntryId() < 1L) {
                    CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.addRow((AbstractTable.Row)new CalendarEntryTable.Row(dbCalendarEntry, dbCalendarGroup.name));
                } else {
                    int n = CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.getSelectedRow();
                    if (n >= 0) {
                        int n2 = CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.convertRowIndexToModel(n);
                        CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.setRowAt(n2, (AbstractTable.Row)new CalendarEntryTable.Row(dbCalendarEntry, dbCalendarGroup.name));
                    }
                }
            }
            finally {
                CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.clearSelection();
                CrmActivityCalendarTablePanel.this.relationsTab.entriesTable.setEnabled(true);
                CrmActivityCalendarTablePanel.this.relationsTab.updateTitle();
            }
            return true;
        }
    }

    private final class RelationsTab
    extends AbstractTab {
        private JXTitledSeparator entriesTitle;
        private RelationTable entriesTable;
        private RelationForm relationForm;
        private AbstractI18nAction relationAddAction;
        private AbstractI18nAction refreshAction;
        private AbstractI18nAction showActionsAction;

        private RelationsTab() {
            this.build();
        }

        private void build() {
            this.entriesTable = new RelationTable();
            this.entriesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.showActionsAction = new ShowActionsAction();
            this.relationAddAction = new RelationAddAction();
            this.refreshAction = new RefreshAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.entriesTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
            this.relationForm = new RelationForm();
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.entriesTable.createScrollPane(), "Center");
            this.add((Component)((Object)this.relationForm), "South");
            this.updateLocalization();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("entries"));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.updateTitle();
        }

        private void updateTitle() {
            int n;
            Object object = StringUtils.capitalize((String)I18N.tr("assigned calendar entries"));
            int n2 = n = this.entriesTable != null ? this.entriesTable.getRowCount() : 0;
            if (n > 0) {
                object = (String)object + " / ";
                object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.entriesTitle.setTitle((String)object);
        }
    }

    private final class NewEntryTab
    extends AbstractTab {
        private ValidationHandler validationHandler;
        private JXTitledSeparator formTitle;
        private JLabel typeLabel;
        private JComboBox<DbCalendarEntry.Type> typeField;
        private JPanel entryPanel;
        private Map<DbCalendarEntry.Type, CalendarEntryPanel> entryForms;
        private AbstractI18nAction entryAddAction;

        private NewEntryTab() {
            this.build();
        }

        private void build() {
            this.entryPanel = new JPanel(new BorderLayout());
            this.entryForms = new EnumMap<DbCalendarEntry.Type, CalendarEntryPanel>(DbCalendarEntry.Type.class);
            this.entryForms.put(DbCalendarEntry.Type.VEVENT, (CalendarEntryPanel)new CalendarEventEntryPanel(false));
            this.entryForms.put(DbCalendarEntry.Type.VTODO, (CalendarEntryPanel)new CalendarTodoEntryPanel(false));
            this.typeLabel = new JLabel();
            this.typeField = new JComboBox();
            this.typeField.setRenderer((ListCellRenderer<DbCalendarEntry.Type>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
            this.typeField.addItem(null);
            for (DbCalendarEntry.Type type : DbCalendarEntry.Type.values()) {
                this.typeField.addItem(type);
            }
            this.typeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewEntryTab.this.selectForm((DbCalendarEntry.Type)NewEntryTab.this.typeField.getSelectedItem());
                }
            });
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.validationHandler.putRule(this.typeField, ValidationHandler.NOT_BLANK);
            this.validationHandler.init();
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.entryAddAction = new EntryAddAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{this.entryAddAction});
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[50dlu,pref], 3dlu, pref:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.typeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.typeField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.entryPanel).xyw(1, defaultFormBuilder.nextRow(), 3);
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add(jScrollPane, "Center");
            this.updateLocalization();
        }

        private void clearForm() {
            for (Map.Entry<DbCalendarEntry.Type, CalendarEntryPanel> entry : this.entryForms.entrySet()) {
                CalendarEntryPanel calendarEntryPanel = entry.getValue();
                calendarEntryPanel.load(calendarEntryPanel.createEntry());
            }
            this.typeField.setSelectedItem(null);
            this.validationHandler.init();
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("new entry"));
        }

        private void selectForm(DbCalendarEntry.Type type) {
            CalendarEntryPanel calendarEntryPanel = type != null && this.entryForms.containsKey(type) ? this.entryForms.get(type) : null;
            this.entryPanel.removeAll();
            if (calendarEntryPanel != null) {
                this.entryPanel.add((Component)calendarEntryPanel, "Center");
            }
            this.entryPanel.revalidate();
            this.entryPanel.repaint();
        }

        private boolean submitNewCalendarEntry(DbCalendarEntry dbCalendarEntry) {
            DbCalendarEntry.Type type = (DbCalendarEntry.Type)this.typeField.getSelectedItem();
            this.validationHandler.validate();
            if (!this.validationHandler.isValid() || type == null || !this.entryForms.containsKey(type)) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)CrmActivityCalendarTablePanel.this.getViewPanel());
                return false;
            }
            CalendarEntryPanel calendarEntryPanel = this.entryForms.get(type);
            if (!calendarEntryPanel.isTabValid()) {
                ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("The provided information is incomplete!"), (Component)CrmActivityCalendarTablePanel.this.getViewPanel());
                return false;
            }
            calendarEntryPanel.save(dbCalendarEntry);
            return true;
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("create a new calendar entry")));
            this.typeLabel.setText(StringUtils.capitalize((String)I18N.tr("entry type")) + ":");
        }
    }
}

