/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.addons.mail.CrmMailsUtils;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmActivityMailMessage;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.extensions.ActivityViewAdapter;
import com.openindex.openestate.tool.crm.extensions.ActivityViewExtension;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.MailViewer;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={ActivityViewExtension.class}, plugins={"OpenEstate-Tool-Contacts", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Mail"})
public class CrmActivityViewMailExtension
extends ActivityViewAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityViewMailExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityViewMailExtension.class);
    private static final String VIEW_INFO = "info";
    private static final String VIEW_MAIL = "mail";
    private final ActivityMailViewPanel activityMailViewer = new ActivityMailViewPanel();

    public JComponent getActivityView(DbCrmActivity dbCrmActivity) {
        if (dbCrmActivity == null || dbCrmActivity.id < 1L || !DbCrmActivity.Type.EMAIL.equals((Object)dbCrmActivity.type)) {
            return null;
        }
        return this.activityMailViewer;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public void load(ImmoToolProject immoToolProject, Connection connection, DbCrmActivity dbCrmActivity) throws SQLException {
        super.load(immoToolProject, connection, dbCrmActivity);
        DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
        if (dbCrmActivity == null || dbCrmActivity.id < 1L || !DbCrmActivity.Type.EMAIL.equals((Object)dbCrmActivity.type)) {
            this.activityMailViewer.setMessage(null);
            return;
        }
        DbCrmActivityMailMessage dbCrmActivityMailMessage = dbCrmMailsHandler.getRelationForActivity(connection, dbCrmActivity.id);
        DbMailMessage dbMailMessage = dbCrmActivityMailMessage != null && dbCrmActivityMailMessage.mailMessageId > 0L ? dbMailMessageHandler.getMessage(connection, dbCrmActivityMailMessage.mailMessageId) : null;
        this.activityMailViewer.setMessage(dbMailMessage);
    }

    private static class ActivityMailViewPanel
    extends AbstractPanel {
        private JXTitledSeparator titleLabel;
        private JPanel mainPanel;
        private JLabel infoLabel;
        private MailViewer mailViewer;
        private JButton mailViewerActionButton;

        public ActivityMailViewPanel() {
            this.build();
        }

        private void build() {
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.mailViewer = new MailViewer();
            this.mailViewerActionButton = this.mailViewer.getActionButton();
            this.infoLabel = new JLabel();
            this.infoLabel.setHorizontalAlignment(2);
            this.infoLabel.setVerticalAlignment(1);
            this.infoLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)32));
            this.mainPanel = new JPanel(new CardLayout());
            this.mainPanel.add((Component)this.infoLabel, CrmActivityViewMailExtension.VIEW_INFO);
            this.mainPanel.add((Component)this.mailViewer, CrmActivityViewMailExtension.VIEW_MAIL);
            this.showMainPanel(CrmActivityViewMailExtension.VIEW_INFO);
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.titleLabel, (JComponent[])new JComponent[]{this.mailViewerActionButton});
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.mainPanel, "Center");
            this.updateLocalization();
        }

        private void setMessage(DbMailMessage dbMailMessage) {
            this.mailViewerActionButton.setEnabled(dbMailMessage != null);
            if (dbMailMessage == null) {
                this.infoLabel.setText("<html>" + StringEscapeUtils.escapeXml11((String)I18N.tr("No e-mail is assigned or the e-mail is not archived anymore.")) + "</html>");
                this.showMainPanel(CrmActivityViewMailExtension.VIEW_INFO);
            } else {
                this.infoLabel.setText("");
                this.mailViewer.setMessage(dbMailMessage);
                this.mailViewer.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
                this.showMainPanel(CrmActivityViewMailExtension.VIEW_MAIL);
            }
        }

        private void showMainPanel(String string) {
            CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
            cardLayout.show(this.mainPanel, string);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("assigned e-mail message")));
        }
    }
}

