/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.mail.CrmMailsUtils;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmActivityMailMessage;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.mail.MailTablePanel;
import com.openindex.openestate.tool.mail.db.DbMailFolder;
import com.openindex.openestate.tool.mail.extensions.MailTableAdapter;
import com.openindex.openestate.tool.mail.extensions.MailTableExtension;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={MailTableExtension.class}, plugins={"OpenEstate-Tool-Contacts", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Mail"})
public class MailTableCrmExtension
extends MailTableAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTableCrmExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailTableCrmExtension.class);
    private Map<Long, DbCrmActivityMailMessage> activities = null;

    public boolean canUnarchiveMessage(long l) {
        return this.activities == null || !this.activities.containsKey(l);
    }

    public JMenuItem[] createActionMenuItems(long[] lArray, MailTablePanel mailTablePanel) {
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return null;
        }
        long l = lArray[0];
        JMenu jMenu = new JMenu(StringUtils.capitalize((String)I18N.tr("activity")));
        jMenu.setIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
        boolean bl = false;
        boolean bl2 = false;
        for (long l2 : lArray) {
            bl = bl || !this.activities.containsKey(l2);
            boolean bl3 = bl2 = bl2 || this.activities.containsKey(l2);
            if (bl && bl2) break;
        }
        if (this.activities.containsKey(l)) {
            JMenuItem jMenuItem = new JMenuItem((Action)((Object)new RelationViewAction(this.activities.get(l))));
            jMenu.add(jMenuItem);
            jMenu.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem((Action)((Object)new RelationAddAction(lArray, this.activities)));
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem((Action)((Object)new RelationRemoveAction(lArray, this.activities)));
        jMenuItem2.setEnabled(bl2);
        jMenu.add(jMenuItem2);
        return new JMenuItem[]{jMenu};
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ImmoToolProject immoToolProject, Connection connection, DbMailFolder dbMailFolder) throws SQLException {
        super.load(immoToolProject, connection, dbMailFolder);
        DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
        DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray = this;
        synchronized (this) {
            if (this.activities == null) {
                this.activities = new HashMap<Long, DbCrmActivityMailMessage>();
            }
            this.activities.clear();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (dbMailFolder != null && dbMailFolder.id > 0L) {
                for (DbCrmActivityMailMessage dbCrmActivityMailMessage : dbCrmMailsHandler.getRelationsForFolder(connection, dbMailFolder.id)) {
                    this.activities.put(dbCrmActivityMailMessage.mailMessageId, dbCrmActivityMailMessage);
                }
            }
            return;
        }
    }

    private static class RelationViewAction
    extends AbstractI18nAction {
        private final DbCrmActivityMailMessage relation;

        public RelationViewAction(DbCrmActivityMailMessage dbCrmActivityMailMessage) {
            this.relation = dbCrmActivityMailMessage;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.relation != null) {
                new CrmPlugin.ActivityFormAction(this.relation.crmActivityId).actionPerformed(actionEvent);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show in CRM")));
            this.setShortDescription(I18N.tr("View CRM activity of the first selected message."));
        }
    }

    private static class RelationRemoveTask
    extends ImmoToolTask<Long[], Void> {
        private final long[] messageIds;
        private final Map<Long, DbCrmActivityMailMessage> activities;

        public RelationRemoveTask(long[] lArray, Map<Long, DbCrmActivityMailMessage> map) {
            this.messageIds = lArray;
            this.activities = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Long[] doInBackground() throws Exception {
            Long[] longArray;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
            Connection connection = null;
            try {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                connection = immoToolProject.getDbConnection();
                for (long l : this.messageIds) {
                    DbCrmActivityMailMessage dbCrmActivityMailMessage = this.activities.get(l);
                    if (dbCrmActivityMailMessage == null) continue;
                    arrayList.add(l);
                    dbCrmMailsHandler.removeRelation(connection, dbCrmActivityMailMessage);
                    dbCrmActivityHandler.removeActivity(connection, dbCrmActivityMailMessage.crmActivityId);
                }
                longArray = arrayList.toArray(new Long[0]);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return longArray;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't remove activities!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Long[] longArray) {
            super.succeeded((Object)longArray);
            if (ArrayUtils.isEmpty((Object[])longArray)) {
                return;
            }
            for (Long l : longArray) {
                this.activities.remove(l);
            }
            ImmoToolUtils.showMessageInfoDialog((String)I18N.trn("{0} activity was removed.", "{0} activities were removed.", (long)longArray.length, (Object)longArray.length), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static class RelationRemoveAction
    extends AbstractI18nAction {
        private final long[] messageIds;
        private final Map<Long, DbCrmActivityMailMessage> activities;

        public RelationRemoveAction(long[] lArray, Map<Long, DbCrmActivityMailMessage> map) {
            this.messageIds = lArray;
            this.activities = map;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ArrayUtils.isEmpty((long[])this.messageIds) && this.activities != null) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RelationRemoveTask(this.messageIds, this.activities));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove from CRM")));
            this.setShortDescription(I18N.tr("Remove CRM activities of the selected messages."));
        }
    }

    private static class RelationAddTask
    extends ImmoToolTask<DbCrmActivityMailMessage[], Void> {
        private final long[] messageIds;
        private final Map<Long, DbCrmActivityMailMessage> activities;

        public RelationAddTask(long[] lArray, Map<Long, DbCrmActivityMailMessage> map) {
            this.messageIds = lArray;
            this.activities = map;
        }

        protected DbCrmActivityMailMessage[] doInBackground() throws Exception {
            return CrmMailsUtils.addCrmActivityMailMessage(this.messageIds);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't create activities!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray) {
            super.succeeded((Object)dbCrmActivityMailMessageArray);
            if (ArrayUtils.isEmpty((Object[])dbCrmActivityMailMessageArray)) {
                return;
            }
            for (DbCrmActivityMailMessage dbCrmActivityMailMessage : dbCrmActivityMailMessageArray) {
                this.activities.put(dbCrmActivityMailMessage.mailMessageId, dbCrmActivityMailMessage);
            }
            ImmoToolUtils.showMessageInfoDialog((String)I18N.trn("{0} activity was created.", "{0} activities were created.", (long)dbCrmActivityMailMessageArray.length, (Object)dbCrmActivityMailMessageArray.length), (Component)ImmoToolEnvironment.getFrame());
        }
    }

    private static class RelationAddAction
    extends AbstractI18nAction {
        private final long[] messageIds;
        private final Map<Long, DbCrmActivityMailMessage> activities;

        public RelationAddAction(long[] lArray, Map<Long, DbCrmActivityMailMessage> map) {
            this.messageIds = lArray;
            this.activities = map;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ArrayUtils.isEmpty((long[])this.messageIds)) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RelationAddTask(this.messageIds, this.activities));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save into CRM")));
            this.setShortDescription(I18N.tr("Create CRM activities for the selected messages."));
        }
    }
}

