/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.alexandriasoftware.swing.action.ButtonClickedActionListener;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.mail.CrmMailsUtils;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmActivityMailMessage;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultSplitButton;
import com.openindex.openestate.tool.mail.MailViewer;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailPart;
import com.openindex.openestate.tool.mail.extensions.MailViewerAdapter;
import com.openindex.openestate.tool.mail.extensions.MailViewerExtension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={MailViewerExtension.class}, plugins={"OpenEstate-Tool-Contacts", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Mail"})
public class MailViewCrmExtension
extends MailViewerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailViewCrmExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(MailViewCrmExtension.class);
    private DbCrmActivityMailMessage currentRelation = null;
    private MailViewer viewPanel = null;
    private JButton crmButton = null;

    public boolean canUnarchiveMessage() {
        return this.currentRelation == null;
    }

    public JButton[] createActionButtons(MailViewer mailViewer) {
        JButton[] jButtonArray;
        this.viewPanel = mailViewer;
        DbMailMessage dbMailMessage = this.getMessage();
        if (dbMailMessage == null || dbMailMessage.id < 1L) {
            return null;
        }
        if (this.crmButton != null) {
            JButton[] jButtonArray2 = new JButton[1];
            jButtonArray = jButtonArray2;
            jButtonArray2[0] = this.crmButton;
        } else {
            jButtonArray = null;
        }
        return jButtonArray;
    }

    private JButton createCrmButton() {
        if (this.currentRelation == null) {
            return new JButton((Action)((Object)new RelationAddAction()));
        }
        final RelationViewAction relationViewAction = new RelationViewAction(this.currentRelation);
        DefaultSplitButton defaultSplitButton = new DefaultSplitButton(relationViewAction.getName() + "    ");
        defaultSplitButton.setIcon(relationViewAction.getSmallIcon());
        defaultSplitButton.addButtonClickedActionListener(new ButtonClickedActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                relationViewAction.actionPerformed(actionEvent);
            }
        });
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)relationViewAction)));
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        defaultSplitButton.setPopupMenu(jPopupMenu);
        return defaultSplitButton;
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Mail", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public void load(ImmoToolProject immoToolProject, Connection connection, DbMailMessage dbMailMessage, DbMailPart dbMailPart) throws SQLException {
        super.load(immoToolProject, connection, dbMailMessage, dbMailPart);
        DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
        this.currentRelation = dbCrmMailsHandler.getRelationForMessage(connection, dbMailMessage.id);
        this.crmButton = this.createCrmButton();
    }

    private static class RelationViewAction
    extends AbstractI18nAction {
        private final DbCrmActivityMailMessage relation;

        public RelationViewAction(DbCrmActivityMailMessage dbCrmActivityMailMessage) {
            this.relation = dbCrmActivityMailMessage;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"file_open.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.relation != null) {
                new CrmPlugin.ActivityFormAction(this.relation.crmActivityId).actionPerformed(actionEvent);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show in CRM")));
            this.setShortDescription(I18N.tr("View CRM activity of the opened message."));
        }
    }

    private class RelationRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
            DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbCrmMailsHandler.removeRelation(connection, MailViewCrmExtension.this.currentRelation);
                dbCrmActivityHandler.removeActivity(connection, MailViewCrmExtension.this.currentRelation.crmActivityId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            MailViewCrmExtension.this.crmButton.setEnabled(true);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't remove activity!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            MailViewCrmExtension.this.currentRelation = null;
            MailViewCrmExtension.this.crmButton = MailViewCrmExtension.this.createCrmButton();
            if (MailViewCrmExtension.this.viewPanel != null) {
                MailViewCrmExtension.this.viewPanel.updateMessage();
            }
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        public RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DbMailMessage dbMailMessage = MailViewCrmExtension.this.getMessage();
            if (MailViewCrmExtension.this.currentRelation != null && dbMailMessage != null) {
                MailViewCrmExtension.this.crmButton.setEnabled(false);
                if (MailViewCrmExtension.this.viewPanel != null) {
                    MailViewCrmExtension.this.viewPanel.setEnabled(false);
                }
                ImmoToolUtils.executeTask((ImmoToolTask)new RelationRemoveTask());
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove from CRM")));
            this.setShortDescription(I18N.tr("Remove CRM activity of the opened message."));
        }
    }

    private class RelationAddTask
    extends ImmoToolTask<DbCrmActivityMailMessage, Void> {
        private final DbMailMessage message;

        public RelationAddTask(DbMailMessage dbMailMessage) {
            this.message = dbMailMessage;
        }

        protected DbCrmActivityMailMessage doInBackground() throws Exception {
            Object[] objectArray = CrmMailsUtils.addCrmActivityMailMessage(new DbMailMessage[]{this.message});
            return !ArrayUtils.isEmpty((Object[])objectArray) ? objectArray[0] : null;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            MailViewCrmExtension.this.crmButton.setEnabled(true);
            ImmoToolUtils.showMessageErrorDialog((String)I18N.tr("Can't create activity!"), (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            MailViewCrmExtension.this.crmButton.setEnabled(true);
            if (MailViewCrmExtension.this.viewPanel != null) {
                MailViewCrmExtension.this.viewPanel.setEnabled(true);
            }
        }

        protected void succeeded(DbCrmActivityMailMessage dbCrmActivityMailMessage) {
            super.succeeded((Object)dbCrmActivityMailMessage);
            if (dbCrmActivityMailMessage == null) {
                return;
            }
            MailViewCrmExtension.this.currentRelation = dbCrmActivityMailMessage;
            MailViewCrmExtension.this.crmButton = MailViewCrmExtension.this.createCrmButton();
            if (MailViewCrmExtension.this.viewPanel != null) {
                MailViewCrmExtension.this.viewPanel.updateMessage();
            }
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        public RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DbMailMessage dbMailMessage = MailViewCrmExtension.this.getMessage();
            if (MailViewCrmExtension.this.currentRelation == null && dbMailMessage != null) {
                MailViewCrmExtension.this.crmButton.setEnabled(false);
                if (MailViewCrmExtension.this.viewPanel != null) {
                    MailViewCrmExtension.this.viewPanel.setEnabled(false);
                }
                ImmoToolUtils.executeTask((ImmoToolTask)new RelationAddTask(dbMailMessage));
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("save into CRM")));
            this.setShortDescription(I18N.tr("Create CRM activity for the opened message."));
        }
    }
}

