/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.agency.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyExtension;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyHandler;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyUpdateListener;
import com.openindex.openestate.tool.crm.addons.agency.db.hsql.HSqlDbCrmAgencyHandler;
import com.openindex.openestate.tool.db.AbstractDbUpdateListener;
import com.openindex.openestate.tool.db.DbUpdateHandler;
import com.openindex.openestate.tool.db.DbUpdateHandlerImpl;
import com.openindex.openestate.tool.db.hsql.HSqlDbUpdateHandler;
import com.openindex.openestate.tool.db.hsql.HSqlUtils;
import com.openindex.openestate.tool.extensions.DbExtension;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={DbCrmAgencyExtension.class}, plugins={"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts", "OpenEstate-Tool-CRM"})
public class HSqlDbCrmAgencyExtension
extends DbCrmAgencyExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmAgencyExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmAgencyExtension.class);
    private static final String RESOURCE_PATH = "/com/openindex/openestate/tool/crm/addons/agency/db/hsql/resources/";
    private static final DbCrmAgencyHandler HANDLER = new HSqlDbCrmAgencyHandler();

    @Override
    public DbCrmAgencyHandler getHandler() {
        return HANDLER;
    }

    public final String[] getRequiredProcedures() {
        return new String[]{"remove_immotool_crm_activities_agency_objects", "save_immotool_crm_activities_agency_objects"};
    }

    public final String[] getRequiredViews() {
        return new String[]{"view_immotool_crm_activities_agency_objects"};
    }

    public String[] getSupportedDrivers() {
        return new String[]{"HSQL.local", "HSQL.remote"};
    }

    public String getUninstallQuery() throws IOException {
        return HSqlDbCrmAgencyExtension.readHsqlQuery("uninstall.sql");
    }

    public DbUpdateHandler getUpdateHandler() {
        String string = null;
        try {
            string = this.getUninstallQuery();
        }
        catch (IOException iOException) {
            LOGGER.warn("Can't load uninstall query!");
            LOGGER.warn("> " + iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return new HSqlDbUpdateHandler("OpenEstate-CRM-Agency", DbUpdateHandlerImpl.Type.PLUGIN_RELATION, 1L, string, RESOURCE_PATH, ((Object)((Object)this)).getClass().getClassLoader(), (AbstractDbUpdateListener)new DbCrmAgencyUpdateListener());
    }

    public void install(Connection connection, DbExtension dbExtension) throws IOException, SQLException {
        super.install(connection, dbExtension);
        Statement statement = null;
        SqlFile sqlFile = null;
        try {
            statement = connection.createStatement();
            sqlFile = HSqlDbCrmAgencyExtension.readHsqlFile("schema.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            sqlFile = HSqlDbCrmAgencyExtension.readHsqlFile("routines.sql");
            sqlFile.setConnection(connection);
            sqlFile.execute();
            sqlFile.closeReader();
            statement.execute("CHECKPOINT;");
        }
        catch (SqlToolError sqlToolError) {
            sqlFile.closeReader();
            connection.rollback();
            LOGGER.error("Can't execute schema!");
            LOGGER.error("> " + sqlToolError.getLocalizedMessage(), (Throwable)sqlToolError);
            throw new SQLException("Can't execute schema!");
        }
        catch (SQLException sQLException) {
            if (sqlFile != null) {
                sqlFile.closeReader();
            }
            connection.rollback();
            throw sQLException;
        }
        finally {
            JdbcUtils.closeQuietly((Statement)statement);
        }
    }

    private static SqlFile readHsqlFile(String string) throws IOException {
        return HSqlUtils.readHSqlFile((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCrmAgencyExtension.class.getClassLoader());
    }

    private static String readHsqlQuery(String string) throws IOException {
        return HSqlUtils.readHSqlQuery((String)(RESOURCE_PATH + string), (ClassLoader)HSqlDbCrmAgencyExtension.class.getClassLoader());
    }
}

