/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.calendar;

import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarAdapter;
import com.openindex.openestate.tool.calendar.extensions.VirtualCalendarExtension;
import com.openindex.openestate.tool.crm.CrmPermission;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.calendar.CrmActivityCalendarEntry;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={VirtualCalendarExtension.class}, plugins={"OpenEstate-Tool-Calendar", "OpenEstate-Tool-Contacts", "OpenEstate-Tool-CRM"})
public class CrmActivityCalendarExtension
extends VirtualCalendarAdapter<CrmActivityCalendarEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmActivityCalendarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmActivityCalendarExtension.class);

    public List<CrmActivityCalendarEntry> getEntries(Connection connection, String string, Date date, Date date2) throws SQLException, IOException {
        DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
        ArrayList<CrmActivityCalendarEntry> arrayList = new ArrayList<CrmActivityCalendarEntry>();
        for (DbCrmActivity dbCrmActivity : dbCrmActivityHandler.getActivities(connection, date, date2)) {
            arrayList.add(new CrmActivityCalendarEntry(dbCrmActivity, (VirtualCalendarExtension)this));
        }
        return arrayList;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(CrmPlugin.getResourceImage((String)"crm.png", (int)16));
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("activities"));
    }

    public String getToolTip() {
        return I18N.tr("This calendar contains CRM activities.");
    }

    public Action getViewAction(ImmoToolProject immoToolProject, CrmActivityCalendarEntry crmActivityCalendarEntry) {
        return new ViewAction(crmActivityCalendarEntry);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Calendar", "OpenEstate-Tool-CRM", "OpenEstate-Tool-Contacts"};
    }

    public boolean isUsable() {
        return CrmPlugin.isUserAllowedTo((CrmPermission)CrmPermission.USE_PLUGIN) && CrmPlugin.isUserAllowedTo((CrmPermission)CrmPermission.ACTIVITIES);
    }

    private static class ViewAction
    extends AbstractI18nAction {
        private final CrmActivityCalendarEntry entry;

        public ViewAction(CrmActivityCalendarEntry crmActivityCalendarEntry) {
            this.entry = crmActivityCalendarEntry;
            this.setSmallIcon(CrmPlugin.getResourceIcon((String)"crm.png", (int)16));
            this.setEnabled(CrmPlugin.isUserAllowedTo((CrmPermission)CrmPermission.ACTIVITIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                long l = this.entry.getActivity().id;
                new CrmPlugin.ActivityFormAction(l).actionPerformed(actionEvent);
            }
            catch (Exception exception) {
                LOGGER.error("Can't open activity!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show activity")));
        }
    }
}

