/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.agency.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmActivityAgencyObject;
import com.openindex.openestate.tool.crm.addons.agency.db.DbCrmAgencyHandlerImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbCrmAgencyHandler
extends DbCrmAgencyHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbCrmAgencyHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbCrmAgencyHandler.class);
    public static final String VIEW_CRM_ACTIVITIES_AGENCY_OBJECTS = "view_immotool_crm_activities_agency_objects";
    public static final String PROC_REMOVE_CRM_ACTIVITIES_AGENCY_OBJECTS = "remove_immotool_crm_activities_agency_objects";
    public static final String PROC_SAVE_CRM_ACTIVITIES_AGENCY_OBJECTS = "save_immotool_crm_activities_agency_objects";
    private static final String FIELD_AGENCY_OBJECT_ID = "agency_object_id";
    private static final String FIELD_CRM_ACTIVITY_ID = "activity_id";

    private DbCrmActivityAgencyObject createActivityAgencyObject(ResultSet resultSet) throws SQLException {
        DbCrmActivityAgencyObject dbCrmActivityAgencyObject = this.buildActivityAgencyObject();
        dbCrmActivityAgencyObject.crmActivityId = resultSet.getLong(FIELD_CRM_ACTIVITY_ID);
        dbCrmActivityAgencyObject.agencyObjectId = resultSet.getLong(FIELD_AGENCY_OBJECT_ID);
        return dbCrmActivityAgencyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbCrmActivityAgencyObject[] getActivityAgencyObjects(Connection connection, long[] lArray, long[] lArray2) throws SQLException {
        DbCrmActivityAgencyObject[] dbCrmActivityAgencyObjectArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            if (lArray != null) {
                arrayList.add((CallSite)((Object)("activity_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")")));
            }
            if (lArray2 != null) {
                arrayList.add((CallSite)((Object)("agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")")));
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_crm_activities_agency_objects " + string + " ORDER BY activity_id ASC, agency_object_id ASC;");
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    preparedStatement.setLong(++n, l);
                }
            }
            if (lArray2 != null) {
                for (long l : lArray2) {
                    preparedStatement.setLong(++n, l);
                }
            }
            resultSet = preparedStatement.executeQuery();
            Object object = new ArrayList();
            while (resultSet.next()) {
                object.add(this.createActivityAgencyObject(resultSet));
            }
            dbCrmActivityAgencyObjectArray = object.toArray(new DbCrmActivityAgencyObject[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbCrmActivityAgencyObjectArray;
    }

    @Override
    public void removeActivityAgencyObjects(Connection connection, DbCrmActivityAgencyObject[] dbCrmActivityAgencyObjectArray) throws SQLException {
        if (dbCrmActivityAgencyObjectArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_crm_activities_agency_objects(:activity_id, :agency_object_id);");
            for (DbCrmActivityAgencyObject dbCrmActivityAgencyObject : dbCrmActivityAgencyObjectArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityAgencyObject.crmActivityId);
                namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbCrmActivityAgencyObject.agencyObjectId);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveActivityAgencyObject(Connection connection, DbCrmActivityAgencyObject dbCrmActivityAgencyObject) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_crm_activities_agency_objects(:activity_id, :agency_object_id);");
            namedCallableStatement.setLong(FIELD_CRM_ACTIVITY_ID, dbCrmActivityAgencyObject.crmActivityId);
            namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbCrmActivityAgencyObject.agencyObjectId);
            namedCallableStatement.execute();
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

