/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.crm.addons.mail;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.crm.CrmPlugin;
import com.openindex.openestate.tool.crm.addons.mail.MailAddressContactsDialog;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmActivityMailMessage;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsExtension;
import com.openindex.openestate.tool.crm.addons.mail.db.DbCrmMailsHandler;
import com.openindex.openestate.tool.crm.db.DbCrmActivity;
import com.openindex.openestate.tool.crm.db.DbCrmActivityHandler;
import com.openindex.openestate.tool.mail.MailHandler;
import com.openindex.openestate.tool.mail.MailPlugin;
import com.openindex.openestate.tool.mail.db.DbMailAccount;
import com.openindex.openestate.tool.mail.db.DbMailMessage;
import com.openindex.openestate.tool.mail.db.DbMailMessageHandler;
import java.awt.Window;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CrmMailsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmMailsUtils.class);
    private static final I18n I18N = I18nFactory.getI18n(CrmMailsUtils.class);
    private static final String CRM_STORE_AFTER_TRANSPORT = "crm.storeAfterTransport";
    private static DbCrmMailsExtension crmMailsExtension;

    private CrmMailsUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbCrmActivityMailMessage[] addCrmActivityMailMessage(long[] lArray) throws SQLException, MessagingException, IOException {
        if (ArrayUtils.isEmpty((long[])lArray)) {
            return null;
        }
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbMailMessageHandler dbMailMessageHandler = MailPlugin.getDbMailExtension().getMessageHandler();
        DbMailMessage[] dbMailMessageArray = null;
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            dbMailMessageArray = dbMailMessageHandler.getMessages(connection, lArray);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
        return CrmMailsUtils.addCrmActivityMailMessage(dbMailMessageArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbCrmActivityMailMessage[] addCrmActivityMailMessage(DbMailMessage[] dbMailMessageArray) throws SQLException, MessagingException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
        Map<Long, DbContactsEntry> map = MailAddressContactsDialog.showDialog(dbMailMessageArray, immoToolProject, (Window)ImmoToolEnvironment.getFrame());
        if (map == null || map.isEmpty()) {
            return null;
        }
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            ArrayList<DbCrmActivityMailMessage> arrayList = new ArrayList<DbCrmActivityMailMessage>();
            for (DbMailMessage dbMailMessage : dbMailMessageArray) {
                long[] lArray;
                DbContactsEntry dbContactsEntry = map.get(dbMailMessage.id);
                if (dbContactsEntry != null && dbContactsEntry.id < 1L) {
                    dbContactsHandler.saveEntry(connection, dbContactsEntry);
                }
                if (dbContactsEntry != null && dbContactsEntry.id > 0L) {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = dbContactsEntry.id;
                } else {
                    lArray = null;
                }
                long[] lArray3 = lArray;
                DbCrmActivityMailMessage dbCrmActivityMailMessage = CrmMailsUtils.addCrmActivityMailMessage(connection, dbMailMessage, lArray3);
                if (dbCrmActivityMailMessage == null) continue;
                arrayList.add(dbCrmActivityMailMessage);
            }
            DbCrmActivityMailMessage[] dbCrmActivityMailMessageArray = arrayList.toArray(new DbCrmActivityMailMessage[0]);
            return dbCrmActivityMailMessageArray;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static DbCrmActivityMailMessage addCrmActivityMailMessage(Connection connection, DbMailMessage dbMailMessage, long[] lArray) throws SQLException, MessagingException, IOException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        MailHandler mailHandler = MailPlugin.getMailHandler();
        DbCrmActivityHandler dbCrmActivityHandler = CrmPlugin.getDbCrmExtension().getCrmActivityHandler();
        DbCrmMailsHandler dbCrmMailsHandler = CrmMailsUtils.getCrmMailsHandler();
        DbCrmActivityMailMessage dbCrmActivityMailMessage = dbCrmMailsHandler.getRelationForMessage(connection, dbMailMessage.id);
        if (dbCrmActivityMailMessage != null) {
            LOGGER.warn("Mail #" + dbCrmActivityMailMessage.mailMessageId + " is already assigned to activity #" + dbCrmActivityMailMessage.crmActivityId + "!");
            return null;
        }
        if (!dbMailMessage.isArchived) {
            mailHandler.markMessageArchived(immoToolProject, connection, dbMailMessage, null, true);
        }
        DbCrmActivity dbCrmActivity = new DbCrmActivity();
        dbCrmActivity.type = DbCrmActivity.Type.EMAIL;
        dbCrmActivity.status = DbCrmActivity.Status.FINISHED;
        dbCrmActivity.begin = dbMailMessage.isReceived && dbMailMessage.receivedAt != null ? dbMailMessage.receivedAt : dbMailMessage.sentAt;
        dbCrmActivity.fixed = true;
        if (dbMailMessage.isReceived) {
            dbCrmActivity.subject = "Maileingang | " + dbMailMessage.subject;
            dbCrmActivity.direction = DbCrmActivity.Direction.IN;
        } else {
            dbCrmActivity.subject = "Mailausgang | " + dbMailMessage.subject;
            dbCrmActivity.direction = DbCrmActivity.Direction.OUT;
        }
        dbCrmActivityHandler.saveActivity(connection, dbCrmActivity);
        if (!ArrayUtils.isEmpty((long[])lArray)) {
            long[] lArray2 = lArray;
            int n = lArray2.length;
            for (int i = 0; i < n; ++i) {
                Long l = lArray2[i];
                dbCrmActivityHandler.saveActivityContactEntry(connection, dbCrmActivity.id, l.longValue());
            }
        }
        dbCrmActivityMailMessage = new DbCrmActivityMailMessage();
        dbCrmActivityMailMessage.mailMessageId = dbMailMessage.id;
        dbCrmActivityMailMessage.crmActivityId = dbCrmActivity.id;
        dbCrmMailsHandler.saveRelation(connection, dbCrmActivityMailMessage);
        return dbCrmActivityMailMessage;
    }

    public static DbCrmMailsExtension getCrmMailsExtension() {
        return crmMailsExtension;
    }

    public static DbCrmMailsHandler getCrmMailsHandler() {
        return crmMailsExtension != null ? crmMailsExtension.getHandler() : null;
    }

    public static boolean isCrmStoreAfterTransport(DbMailAccount dbMailAccount) {
        if (dbMailAccount == null) {
            return false;
        }
        String string = dbMailAccount.get(CRM_STORE_AFTER_TRANSPORT);
        return !StringUtils.isBlank((CharSequence)string) ? Boolean.valueOf(string) : false;
    }

    public static void setCrmMailsExtension(DbCrmMailsExtension dbCrmMailsExtension) {
        crmMailsExtension = dbCrmMailsExtension;
    }

    public static void setCrmStoreAfterTransport(DbMailAccount dbMailAccount, boolean bl) {
        if (dbMailAccount != null) {
            dbMailAccount.set(CRM_STORE_AFTER_TRANSPORT, String.valueOf(bl));
        }
    }
}

