-- -----------------------------------------------------
-- Agency extensions to the CRM-Addon for OpenEstate-ImmoTool
-- routines for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_activities_agency_objects
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_activities_agency_objects(
    val_activity_id BIGINT,
    val_agency_object_id BIGINT
  )
  SPECIFIC remove_immotool_crm_activities_agency_objects
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_activity_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_crm_activities(val_activity_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_agency_object_id < 1 THEN

      -- alle Relationen entfernen
      DELETE
        FROM immotool_crm_activities_agency_objects
        WHERE activity_id = val_activity_id;

    ELSE

      -- Relation entfernen
      DELETE
        FROM immotool_crm_activities_agency_objects
        WHERE activity_id = val_activity_id
        AND agency_object_id = val_agency_object_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_activities_agency_objects
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_activities_agency_objects
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_activities_agency_objects(
    val_activity_id BIGINT,
    val_agency_object_id BIGINT
  )
  SPECIFIC save_immotool_crm_activities_agency_objects
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_activity_id < 1 OR val_agency_object_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Relation ggf. entfernen
    CALL remove_immotool_crm_activities_agency_objects( val_activity_id, val_agency_object_id );

    -- Relation einfügen
    INSERT INTO immotool_crm_activities_agency_objects (
      activity_id,
      agency_object_id )
    VALUES (
      val_activity_id,
      val_agency_object_id );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities_agency_objects
  TO "IMMOTOOL";
