-- -----------------------------------------------------
-- Agency extensions to the CRM-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_crm_activities_agency_objects
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_activities_agency_objects (
  activity_id BIGINT NOT NULL,
  agency_object_id BIGINT NOT NULL,
  PRIMARY KEY (activity_id, agency_object_id),
  FOREIGN KEY (activity_id)
    REFERENCES immotool_crm_activities(activity_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (agency_object_id)
    REFERENCES openestate_objects(object_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_crm_activities_agency_objects AS
  SELECT * FROM immotool_crm_activities_agency_objects
  WHERE activity_id IN (SELECT activity_id FROM view_immotool_crm_activities)
  AND agency_object_id IN (SELECT object_id FROM view_openestate_objects);

GRANT SELECT
  ON view_immotool_crm_activities_agency_objects
  TO "IMMOTOOL";
