-- -----------------------------------------------------
-- Calender extensions to the CRM-Addon for OpenEstate-ImmoTool
-- routines for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_activities_calendar_entries
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_activities_calendar_entries(
    val_activity_id BIGINT,
    val_calendar_entry_id BIGINT
  )
  SPECIFIC remove_immotool_crm_activities_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_activity_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_crm_activities(val_activity_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_calendar_entry_id < 1 THEN

      -- alle Relationen entfernen
      DELETE
        FROM immotool_crm_activities_calendar_entries
        WHERE activity_id = val_activity_id;

    ELSE

      -- Relation entfernen
      DELETE
        FROM immotool_crm_activities_calendar_entries
        WHERE activity_id = val_activity_id
        AND calendar_entry_id = val_calendar_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_activities_calendar_entries
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_activities_calendar_entries
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_activities_calendar_entries(
    val_activity_id BIGINT,
    val_calendar_entry_id BIGINT
  )
  SPECIFIC save_immotool_crm_activities_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_activity_id < 1 OR val_calendar_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Relation ggf. entfernen
    CALL remove_immotool_crm_activities_calendar_entries( val_activity_id, val_calendar_entry_id );

    -- Relation einfügen
    INSERT INTO immotool_crm_activities_calendar_entries (
      activity_id,
      calendar_entry_id )
    VALUES (
      val_activity_id,
      val_calendar_entry_id );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities_calendar_entries
  TO "IMMOTOOL";
