-- -----------------------------------------------------
-- Calender extensions to the CRM-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_crm_activities_calendar_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_activities_calendar_entries (
  activity_id BIGINT NOT NULL,
  calendar_entry_id BIGINT NOT NULL,
  PRIMARY KEY (activity_id, calendar_entry_id),
  FOREIGN KEY (activity_id)
    REFERENCES immotool_crm_activities(activity_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (calendar_entry_id)
    REFERENCES immotool_calendar_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_crm_activities_calendar_entries AS
  SELECT * FROM immotool_crm_activities_calendar_entries
  WHERE activity_id IN (SELECT activity_id FROM view_immotool_crm_activities)
  AND calendar_entry_id IN (SELECT entry_id FROM view_immotool_calendar_entries);

GRANT SELECT
  ON view_immotool_crm_activities_calendar_entries
  TO "IMMOTOOL";
