-- -----------------------------------------------------
-- Mail extensions to the CRM-Addon for OpenEstate-ImmoTool
-- routines for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_activities_mails_messages
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_activities_mails_messages(
    val_activity_id BIGINT,
    val_mails_message_id BIGINT
  )
  SPECIFIC remove_immotool_crm_activities_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_activity_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_write_immotool_crm_activities(val_activity_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_mails_message_id < 1 THEN

      -- alle Relationen entfernen
      DELETE
        FROM immotool_crm_activities_mails_messages
        WHERE activity_id = val_activity_id;

    ELSE

      -- Relation entfernen
      DELETE
        FROM immotool_crm_activities_mails_messages
        WHERE activity_id = val_activity_id
        AND mails_message_id = val_mails_message_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_activities_mails_messages
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_activities_mails_messages
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_activities_mails_messages(
    val_activity_id BIGINT,
    val_mails_message_id BIGINT
  )
  SPECIFIC save_immotool_crm_activities_mails_messages
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_activity_id < 1 OR val_mails_message_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Relation ggf. entfernen
    CALL remove_immotool_crm_activities_mails_messages( val_activity_id, val_mails_message_id );

    -- Relation einfügen
    INSERT INTO immotool_crm_activities_mails_messages (
      activity_id,
      mails_message_id )
    VALUES (
      val_activity_id,
      val_mails_message_id );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities_mails_messages
  TO "IMMOTOOL";
