-- -----------------------------------------------------
-- Mail extensions to the CRM-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_crm_activities_mails_messages
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_activities_mails_messages (
  activity_id BIGINT NOT NULL,
  mails_message_id BIGINT NOT NULL,
  PRIMARY KEY (activity_id, mails_message_id),
  UNIQUE (activity_id),
  UNIQUE (mails_message_id),
  FOREIGN KEY (activity_id)
    REFERENCES immotool_crm_activities(activity_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (mails_message_id)
    REFERENCES immotool_mails_messages(message_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_crm_activities_mails_messages AS
  SELECT * FROM immotool_crm_activities_mails_messages
  WHERE activity_id IN (SELECT activity_id FROM view_immotool_crm_activities)
  AND mails_message_id IN (SELECT message_id FROM view_immotool_mails_messages);

GRANT SELECT
  ON view_immotool_crm_activities_mails_messages
  TO "IMMOTOOL";
